<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) {

    exit();
}



class _FichajesModel

{

    private $DBLink;



    public function __construct(&$DBLink)

    {

        //Continue if DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {

            trigger_error('No MySQL connection!', E_USER_ERROR);
        }



        $Users = new _UsersModel($this->DBLink);



        //Logout Function or Invalid Session

        if (isset($_GET['logout']) || $Users->_IsLogged() == false) {

            $Users->_Logout();



            header('Location: ./login');

            exit();
        }
    }



    public function GetUsuariosDisponibles()

    {

        $usuarios = array();



        // Obtener la lista de usuarios desde la tabla "users"

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM users;")) {





            while ($Result = mysqli_fetch_assoc($Query)) {

                $user_id = $Result['user_id'];



                // Verificar si se utilizan como clave externa en "miembro_equipo"

                $checkQuery = mysqli_query($this->DBLink, "SELECT COUNT(*) AS count FROM miembro_equipo WHERE user_id = $user_id;");

                $checkResult = mysqli_fetch_assoc($checkQuery);



                if ($checkResult['count'] == 0) {



                    $usuarios[] = $Result;
                }
            }



            return $usuarios;
        } else {

            return false; // Manejo de error o retorno adecuado en caso de fallo

        }
    }



    public function GetListCategorias()

    {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `categoria`;")) {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Clientes[] = $Result;
            }



            return $Clientes;
        }
    }
    public function GetListMiembros()
    {
        $sql = "
        SELECT 
            me.*, 
            u.user_full_name 
        FROM 
            miembro_equipo me
        LEFT JOIN 
            users u ON me.user_id = u.user_id;
    ";

        if ($Query = mysqli_query($this->DBLink, $sql)) {
            $Clientes = array();

            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    

    public function GetActividad($ClienteID)

    {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `actividad` WHERE id_actividad = {$ClienteID}")) {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;
            }



            return $Folders;
        }
    }

    public function GetEventosUsuario($ClienteID)

    {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if (

            $Query = mysqli_query($this->DBLink, "SELECT e.*

        FROM eventos e

        INNER JOIN user_evento ue ON e.id_evento = ue.id_evento

        WHERE ue.user_id = {$ClienteID}")

        ) {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;
            }



            return $Folders;
        }
    }

    public function GetCategoria($ClienteID)

    {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `categoria` WHERE id_categoria = {$ClienteID}")) {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;
            }

            if (!empty($Folders)) {

                return $Folders[0];
            } else {

                return null;
            }
        }
    }

    public function GetEvento($ClienteID)

    {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `eventos` WHERE id_evento = {$ClienteID}")) {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;
            }

            if (!empty($Folders)) {

                return $Folders[0];
            } else {

                return null;
            }
        }
    }

    public function GetUsersEvento($ClienteID)

    {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT `user_id` FROM `user_evento` WHERE id_evento = {$ClienteID}")) {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $Folders[] = $Result;
            }



            return $Folders;
        }
    }
}