<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) {
    exit();
}

class _FacturasModel
{
    private $DBLink;
    private $Presupuestos;
    public function __construct(&$DBLink)
    {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $Users = new _UsersModel($this->DBLink);
        $this->Presupuestos = new _PresupuestosModel($this->DBLink);
        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false) {
            $Users->_Logout();

            header('Location: ./login');
            exit();
        }
    }

    public function CreateFactura($numero, $fecha, $domicilio, $estado, $id_presupuesto, $email, $fecha_envio)
    {

        $presupuesto = $this->Presupuestos->GetPresupuesto($id_presupuesto);
        $importe = $presupuesto["importe"];

        $importe_s = $presupuesto["importe_final"];

        $fecha_envio = !empty($fecha_envio) ? "'$fecha_envio'" : "NULL";
        $numero = mysqli_real_escape_string($this->DBLink, $numero);

        $fecha = mysqli_real_escape_string($this->DBLink, $fecha);

        $domicilio = mysqli_real_escape_string($this->DBLink, $domicilio);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);
        $id_presupuesto = mysqli_real_escape_string($this->DBLink, $id_presupuesto);
        $pagos = mysqli_real_escape_string($this->DBLink, "[]");

        $sql = mysqli_query($this->DBLink, "INSERT INTO `facturas` (`numero`, `fecha`, `domicilio`, `importe`, `estado`, `id_presupuesto`,`email`,`fecha_envio`,`importe_restante`,`pagos`,`importe_s`)
												VALUES ('{$numero}', '{$fecha}',  '{$domicilio}', '{$importe}', '{$estado}', '{$id_presupuesto}', '{$email}', {$fecha_envio}, '{$importe_s}','{$pagos}','{$importe_s}');");
        if ($sql) {
            return mysqli_insert_id($this->DBLink);
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }

    public function CreatePago($id_miembro, $precio_hora, $horas_totales, $estado, $precio_horas_extra, $horas_extra_totales, $pagos)
    {
        $fecha = date("Y-m-d");
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $importe = $precio_hora * $horas_totales + $precio_horas_extra * $horas_extra_totales;
        $estado = mysqli_real_escape_string($this->DBLink, $estado);
        $id_miembro = mysqli_real_escape_string($this->DBLink, $id_miembro);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `pago` ( `fecha`,  `importe`, `estado`, `id_miembro`,`importe_restante`,`pagos` ,`precio_horas_extra`,`horas_extra`, `id_proveedor`)
															VALUES ( '{$fecha}',   '{$importe}', '{$estado}', '{$id_miembro}',  '{$importe}','{$pagos}',  '{$precio_horas_extra}',  '{$horas_extra_totales}', NULL);");
        if ($sql) {
            echo "Records added successfully.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }
    public function CreatePagoProveedor($id_proveedor, $importe, $pagos, $numero_factura, $fecha_vencimiento)
    {
        $fecha = date("Y-m-d");
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $importe = mysqli_real_escape_string($this->DBLink, $importe);

        $id_proveedor = mysqli_real_escape_string($this->DBLink, $id_proveedor);
        $fecha_vencimiento = mysqli_real_escape_string($this->DBLink, $fecha_vencimiento);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `pago` ( `fecha`,  `importe`, `estado`, `id_miembro`,`importe_restante`,`pagos` ,`precio_horas_extra`,`horas_extra`, `id_proveedor`, `numero_factura`, `fecha_vencimiento` )
																		VALUES ( '{$fecha}',   '{$importe}', 'Pendiente', NULL,  '{$importe}','{$pagos}',  NULL,  NULL, '{$id_proveedor}', '{$numero_factura}', '{$fecha_vencimiento}');");
        if ($sql) {
            echo "Records added successfully.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }
    public function EliminarDescuentoPago($id, $descuento, $pagos)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $importe_restante = $this->GetPago($id)["importe_restante"];
        $importe = $this->GetPago($id)["importe"];
        $estado = $this->GetPago($id)["estado"];
        $descuento = mysqli_real_escape_string($this->DBLink, $descuento);
        $total = $importe_restante + $descuento;
        if ($total == $importe) {
            $sql = mysqli_query($this->DBLink, "UPDATE `pago` SET `estado` = 'Pendiente' , `importe_restante` =  '{$total}', `pagos` = '{$pagos}' WHERE (`id_pago` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        } else {
            $sql = mysqli_query($this->DBLink, "UPDATE `pago` SET `estado` = 'Pago parcial' , `importe_restante` = '{$total}', `pagos` = '{$pagos}' WHERE (`id_pago` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }

    }
    public function GetPago($PresupuestoID)
    {
        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `pago` WHERE id_pago = {$PresupuestoID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }
    public function DescontarPago($id, $descuento, $pagos)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $importe_restante = $this->GetPago($id)["importe_restante"];
        $descuento = mysqli_real_escape_string($this->DBLink, $descuento);
        $total = $importe_restante - $descuento;
        if ($total <= 0) {
            $sql = mysqli_query($this->DBLink, "UPDATE `pago` SET `estado` = 'Pagado' , `importe_restante` = 0 , `pagos` = '{$pagos}' WHERE (`id_pago` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        } else {
            $sql = mysqli_query($this->DBLink, "UPDATE `pago` SET `estado` = 'Pago parcial' , `importe_restante` = '{$total}', `pagos` = '{$pagos}' WHERE (`id_pago` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }

    }

    public function DeleteFactura($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `facturas` WHERE (`id_factura` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function AceptarFactura($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `facturas` SET `estado` = 'Aceptado' WHERE (`id_factura` = '{$id}');");

        if ($sql) {
            echo "Apartado ac correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function CreateMetodo($nombre)
    {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `metodos_pago` (`nombre`) VALUES ('{$nombre}');");
        if ($sql) {
            echo "Records added successfully.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }

    public function CreateProveedor($nombre, $direccion, $telefono, $cp, $cif, $email)
    {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);

        $direccion = mysqli_real_escape_string($this->DBLink, $direccion);
        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);
        $cp = mysqli_real_escape_string($this->DBLink, $cp);
        $cif = mysqli_real_escape_string($this->DBLink, $cif);
        $email = mysqli_real_escape_string($this->DBLink, $email);

        $direccion = !empty($direccion) ? "'$direccion'" : "NULL";
        $telefono = !empty($telefono) ? "'$telefono'" : "NULL";
        $cp = !empty($cp) ? "'$cp'" : "NULL";
        $cif = !empty($cif) ? "'$cif'" : "NULL";

        $sql = mysqli_query($this->DBLink, "INSERT INTO `proveedores` (`nombre`, `direccion`, `telefono`, `cp`, `cif`, `email`) VALUES ('{$nombre}', $direccion,  $telefono, $cp, $cif, '{$email}');");
        if ($sql) {
            echo "Records added successfully.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }

    public function DeleteMetodo($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `metodos_pago` WHERE (`id_metodo` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function CreateBanco($nombre)
    {

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `bancos` (`nombre`) VALUES ('{$nombre}');");
        if ($sql) {
            echo "Records added successfully.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }

    public function DeleteBanco($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `bancos` WHERE (`id_banco` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function DeletePago($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `pago` WHERE (`id_pago` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function DeleteProveedor($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `proveedores` WHERE (`id_proveedor` = '{$id}');");

        if ($sql) {
            echo "Presupuesto eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function PagarFactura($id, $pagos)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $sql = mysqli_query($this->DBLink, "UPDATE `facturas` SET `estado` = 'Pagado' , `importe_restante` = 0 , `pagos` = '{$pagos}' WHERE (`id_factura` = '{$id}');");

        if ($sql) {
            echo "Apartado ac correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function PagarSueldo($id, $pagos)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $sql = mysqli_query($this->DBLink, "UPDATE `pago` SET `estado` = 'Pagado' , `importe_restante` = 0 , `pagos` = '{$pagos}' WHERE (`id_pago` = '{$id}');");

        if ($sql) {
            echo "Apartado ac correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function DescontarFactura($id, $descuento, $pagos)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $importe_restante = $this->GetFactura($id)["importe_restante"];
        $descuento = mysqli_real_escape_string($this->DBLink, $descuento);
        $total = $importe_restante - $descuento;
        if ($total <= 0) {
            $sql = mysqli_query($this->DBLink, "UPDATE `facturas` SET `estado` = 'Pagado' , `importe_restante` = 0 , `pagos` = '{$pagos}' WHERE (`id_factura` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        } else {
            $sql = mysqli_query($this->DBLink, "UPDATE `facturas` SET `estado` = 'Pago parcial' , `importe_restante` = '{$total}', `pagos` = '{$pagos}' WHERE (`id_factura` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }

    }

    public function EliminarDescuento($id, $descuento, $pagos)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $pagos = mysqli_real_escape_string($this->DBLink, $pagos);

        $importe_restante = $this->GetFactura($id)["importe_restante"];
        $importe = $this->GetFactura($id)["importe_s"];
        $estado = $this->GetFactura($id)["estado"];
        $descuento = mysqli_real_escape_string($this->DBLink, $descuento);
        $total = $importe_restante + $descuento;
        if ($total == $importe) {
            $sql = mysqli_query($this->DBLink, "UPDATE `facturas` SET `estado` = 'Pendiente' , `importe_restante` =  '{$total}', `pagos` = '{$pagos}' WHERE (`id_factura` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        } else {
            $sql = mysqli_query($this->DBLink, "UPDATE `facturas` SET `estado` = 'Pago parcial' , `importe_restante` = '{$total}', `pagos` = '{$pagos}' WHERE (`id_factura` = '{$id}');");

            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }

    }
    public function EnviarFactura($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $fecha = date("Y-m-d");

        $sql = mysqli_query($this->DBLink, "UPDATE `facturas` SET `estado` = 'Pendiente',`fecha_envio` = '{$fecha}' WHERE (`id_factura` = '{$id}');");

        if ($sql) {
            echo "Apartado ac correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function AgregarHorasExtra($id, $horas_extra, $precio_horas_extra)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $horas_extra = mysqli_real_escape_string($this->DBLink, $precio_horas_extra);
        $precio_horas_extra = mysqli_real_escape_string($this->DBLink, $precio_horas_extra);
        $pago = $this->GetPago($id);
        $actual = $pago["importe"] - $pago["horas_extra"] * $pago["precio_horas_extra"];
        $importe = $actual + $horas_extra * $precio_horas_extra;

        $sql = mysqli_query($this->DBLink, "UPDATE `pago` SET `importe` = '{$importe}',`importe_restante` = '{$importe}',`horas_extra` = '{$horas_extra}',`precio_horas_extra` = '{$precio_horas_extra}' WHERE (`id_pago` = '{$id}');");

        if ($sql) {
            echo "Apartado ac correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function GetListMetodos()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `metodos_pago`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListProveedores()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `proveedores`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListPagos()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `pago`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListPagosPendientes()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `pago` WHERE estado = 'Pendiente';")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListFacturas($FechaInicio = 0, $FechaFinal = 0)
    {
        if ($FechaInicio != 0 && $FechaFinal != 0) {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `facturas` where (fecha BETWEEN '{$FechaInicio}' AND '{$FechaFinal}');")) {
                $Clientes = array();

                //Loop around the Referrals
                while ($Result = mysqli_fetch_assoc($Query)) {
                    $Clientes[] = $Result;
                }

                return $Clientes;
            }

        } else {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `facturas`;")) {
                $Clientes = array();

                //Loop around the Referrals
                while ($Result = mysqli_fetch_assoc($Query)) {
                    $Clientes[] = $Result;
                }

                return $Clientes;
            }
        }

    }
    public function GetPresupuestoFactura($ClienteID)
    {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `facturas` WHERE id_cliente = {$ClienteID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders;
        }
    }

    public function GetFactura($PresupuestoID)
    {
        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `facturas` WHERE id_factura = {$PresupuestoID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }

    public function GetProveedor($PresupuestoID)
    {
        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `proveedores` WHERE id_proveedor = {$PresupuestoID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }
    public function GetMetodo($PresupuestoID)
    {
        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `metodos_pago` WHERE id_metodo = {$PresupuestoID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }

    public function GetFacturasCount()
    {
        //Count the Users on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`id_factura`) AS `total` FROM `facturas`;")) {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total'])) {
                return $Result['total'];
            } else {
                return -1;
            }
            //DataBase Query Error
        } else {
            return -2;
        }
    }

    public function RenameFile($FileID, $FileName)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        $FileName = mysqli_real_escape_string($this->DBLink, $FileName);

        $File = $this->GetFileID($FileID);
        $Adress = "./folders" . $File['file_address'] . $File['file_name'] . '.' . $File['file_extension'];
        $Rename = "./folders" . $File['file_address'] . $FileName . '.' . $File['file_extension'];
        rename($Adress, $Rename);

        //Update the file name
        if (!mysqli_query($this->DBLink, "UPDATE `files` SET `file_name` = '{$FileName}' WHERE (`file_id` = '{$FileID}');")) {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -1;
        }

        return true;
    }

}
