<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__'))
    {
    exit();
    }

class _FacturaManualModel
    {
    private $DBLink;
    private $Presupuestos;
    public function __construct(&$DBLink)
        {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
            {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
            } else
            {
            trigger_error('No MySQL connection!', E_USER_ERROR);
            }

        $Users = new _UsersModel($this->DBLink);
        $this->Presupuestos = new _PresupuestosModel($this->DBLink);
        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false)
            {
            $Users->_Logout();

            header('Location: ./login');
            exit();
            }
        }







        public function GetListProgramadasPendientes($fecha)
        {
            $fecha = mysqli_real_escape_string($this->DBLink, $fecha);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_manual` WHERE `programado` IS NOT NULL AND `programado` >= '{$fecha}';"))
            {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Clientes[] = $Result;
                }

            return $Clientes;
            }
        }


        public function EnviarFactura($id)
        {
            $id = mysqli_real_escape_string($this->DBLink, $id);
            $fecha = date("Y-m-d");
    
            $sql = mysqli_query($this->DBLink, "UPDATE `factura_manual` SET `estado` = 'Pendiente',`fecha_envio` = '{$fecha}' WHERE (`id_factura_manual` = '{$id}');");
    
            if ($sql) {
                echo "Apartado ac correctamente";
            } else {
                echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
    
        }

    public function EnviarFacturaManual($id)
        {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $date = new DateTime();
        $fecha = $date->format('Y-m-d H:i:s');

        $sql = mysqli_query($this->DBLink, "UPDATE `factura_manual` SET `estado` = 'Enviada',`fecha_envio` = '{$fecha}' WHERE (`id_factura_manual` = '{$id}');");

        if ($sql)
            {
            echo "Enviada.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }



        public function GetBancosFactura($ClienteID)
        {
            $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
    
            $query = "SELECT * FROM `factura_manual` WHERE id_factura_manual = {$ClienteID}";
            if ($result = mysqli_query($this->DBLink, $query)) {
                $detalles = array();
    
                // Obtener el primer y único resultado
                if ($facturaManual = mysqli_fetch_assoc($result)) {
                    $detalles['banco_1'] = $this->obtenerBanco($facturaManual['id_banco']);
                    $detalles['banco_2'] = $this->obtenerBanco($facturaManual['id_banco_2']);
                    $detalles['banco_3'] = $this->obtenerBanco($facturaManual['id_banco_3']);
                } else {
                    // No se encontró la factura manual
                    $detalles['banco_1'] = null;
                    $detalles['banco_2'] = null;
                    $detalles['banco_3'] = null;
                }
    
                return $detalles;
            } else {
                // Manejar error de la consulta
                return null;
            }
        }
    
        // Función para obtener un banco por ID
        private function obtenerBanco($idBanco)
        {
            if ($idBanco === null) {
                return null;
            }
    
            $idBanco = mysqli_real_escape_string($this->DBLink, $idBanco);
            $query = "SELECT * FROM `bancos` WHERE id_banco = {$idBanco}";
    
            if ($result = mysqli_query($this->DBLink, $query)) {
                return mysqli_fetch_assoc($result);
            } else {
                // Manejar error de la consulta del banco
                return null;
            }
        }




    public function GetDetallado($ClienteID)
        {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `apartado_factura_manual` WHERE id_factura_manual = {$ClienteID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders;
            }
        }
    public function GetFacturaManual($PresupuestoID)
        {
        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_manual` WHERE id_factura_manual = {$PresupuestoID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders[0];
            }
        }
    public function GetApartadosFacturaManual($PresupuestoID)
        {
        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `apartado_factura_manual` WHERE id_factura_manual = {$PresupuestoID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders;
            }
        }
    public function GetFacturasManualesCliente($PresupuestoID)
        {
        $PresupuestoID = mysqli_real_escape_string($this->DBLink, $PresupuestoID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_manual` WHERE client_id = {$PresupuestoID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders;
            }
        }
    public function GetFacturasManuales()
        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_manual`;"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders;
            }
        }

    public function GetFacturasManualesSegunEstado()
        {


        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `factura_manual`"))
            {
            $facturasPendientes = array();
            $facturasNoEnviadas = array();
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                if ($Result['estado'] === 'Pendiente')
                    {
                    $facturasPendientes[] = $Result;
                    } elseif ($Result['estado'] === 'No enviada')
                    {
                    $facturasNoEnviadas[] = $Result;
                    }
                }
            // Create and return an object with both arrays
            $resultObject = new stdClass();
            $resultObject->pendientes = $facturasPendientes;
            $resultObject->no_enviadas = $facturasNoEnviadas;
            return $resultObject;
            }
        }






    }