<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__')) exit();

	class _FacebookModel {
		private $DBLink;
		private $FBLink;
		private $FBHelper;
		
		public function __construct(&$DBLink) {
			//Continue if DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			//Start the Session
			if (!isset($_SESSION)) {
				session_start();
			}
			
			//Load the Facebook PHP SDK
			require_once(__LIBRARIES__.'/facebook/autoload.php');
			
			//Declare the Facebook SDK Class
			$this->FBLink = new Facebook\Facebook([
				'app_id' => FB_APP_ID,
				'app_secret' => FB_APP_SECRET,
				'default_graph_version' => 'v2.4'
			]);
			
			//Load the FB Login Helper
			$this->FBHelper = $this->FBLink->getRedirectLoginHelper();
		}
		
		public function _IsLogged() {
			if (isset($_SESSION['fb_access_token'])) {
				//Set the Default Facebook Access Token
				$this->FBLink->setDefaultAccessToken($_SESSION['fb_access_token']);
				
				//Try to Validate the Facebook Session
				try {
					//Get the Facebook User Information
					$FBResponse = $this->FBLink->get('/me?fields=id,first_name,last_name,email,picture');
					
					return true;
				} catch (Facebook\Exceptions\FacebookResponseException $e) {
					return false;
				} catch (Facebook\Exceptions\FacebookSDKException $e) {
					return false;
				}

				return true;
			}
			
			return false;
		}
	
		public function _LoginURL() {
			//This Page isn't Loaded by Facebook SDK Callback URL
			if (!isset($_GET['code']) && !isset($_GET['state'])) {
				//Expecify the FB Permissions
				$FBPermissions = array('public_profile', 'email');
				
				return $this->FBHelper->getLoginUrl(FB_REDIRECT_LINK, $FBPermissions);
			}
			
			return false;
		}
		
		
		#####################################################################
		##	Function Description:
		##		Add new Product Type to the Database.
		##	Parameters:
		##		@param $Name [String: The Product Name]
		##		@param $Limit [Integer: The Product Limit]
		##		@param $Price [Integer: The Product Price]
		##		@param $Duration [Integer: The Product Duration (On Days)]
		##	Return:
		##		true = Sucess
		##		-1 = Facebook Graph returned an Error
		##		-2 = Facebook SDK returned an Error
		##		-3 = Facebook SDK don't return the Access Token
		##		-4 = Facebook Graph returned an Error
		##		-5 = Facebook SDK returned an Error
		#####################################################################
		public function _LoginCallback() {
			//Have a Previous Facebook Access Token
			if (isset($_SESSION['fb_access_token']) && !empty($_SESSION['fb_access_token'])) {
				$accessToken = $_SESSION['fb_access_token'];
			//This Page is Loaded by Facebook SDK Callback URL
			} else if (isset($_GET['code']) && isset($_GET['state'])) {
				try {
					$accessToken = $this->FBHelper->getAccessToken();
				} catch(Facebook\Exceptions\FacebookResponseException $e) {
					echo 'Facebook Graph returned an error: ' . $e->getMessage(); 
					return -1;
				} catch(Facebook\Exceptions\FacebookSDKException $e) {
					echo 'Facebook SDK returned an error: ' . $e->getMessage(); 
					return -2;
				}
			}
			
			//Don't have any Facebook Access Token
			if (!isset($accessToken)) {
				return -3;
			}
			
			//Already have the Facebook Access Token
			if (isset($_SESSION['fb_access_token']) && !empty($_SESSION['fb_access_token'])) {
				//Set the Default Facebook Access Token
				$this->FBLink->setDefaultAccessToken($accessToken);
			//Don't have the Facebook Access Token
			} else {
				//The OAuth 2.0 client handler helps us manage access tokens
				$oAuth2Client = $this->FBLink->getOAuth2Client();

				//Is a Short Lived Token
				if (!$accessToken->isLongLived()) {
					//Exchanges a short-lived access token for a long-lived one
					try {
						$accessToken = $oAuth2Client->getLongLivedAccessToken($accessToken);
					} catch (Facebook\Exceptions\FacebookSDKException $e) {
						//echo "<p>Error getting long-lived access token: " . $this->FBHelper->getMessage() . "</p>\n\n";
					}
				}
				
				//Save the Facebook Access Token to Session
				$_SESSION['fb_access_token'] = (string)$accessToken;
				
				//Set the Default Facebook Access Token
				$this->FBLink->setDefaultAccessToken($_SESSION['fb_access_token']);
			}
			
			try {
				//Get the Facebook User Information
				$response = $this->FBLink->get('/me?fields=id,first_name,last_name,email,picture');
			} catch(Facebook\Exceptions\FacebookResponseException $e) {
				return -4;
			} catch(Facebook\Exceptions\FacebookSDKException $e) {
				return -5;
			}

			return $response->getDecodedBody();
		}
		
		public function _Logout() {
			session_destroy();
			
			return true;
		}
	}
?>