<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__'))

    {

    exit();

    }



//Include the Image Upload Library

require_once __LIBRARIES__ . 'image_upload.php';

require_once __MODELS__ . 'users.model.php';

class _ClientesModel

    {

    private $DBLink;

    private $Upload;

    public function __construct(&$DBLink)

        {

        //Continue if DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)

            {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

            } else

            {

            trigger_error('No MySQL connection!', E_USER_ERROR);

            }



        $Users = new _UsersModel($this->DBLink);



        //Logout Function or Invalid Session

        if (isset($_GET['logout']) || $Users->_IsLogged() == false)

            {

            $Users->_Logout();



            header('Location: ./login');

            exit();

            }

        }
        public function GetClienteEmail($client_id)
        {
            // Validamos que el parámetro client_id sea seguro
            $client_id = mysqli_real_escape_string($this->DBLink, $client_id);
    
            // Ejecutamos la consulta para obtener el email del cliente
            if ($Query = mysqli_query($this->DBLink, "SELECT `email` FROM `clientes` WHERE `client_id` = '$client_id' LIMIT 1;")) {
                // Obtenemos el resultado de la consulta
                if ($Result = mysqli_fetch_assoc($Query)) {
                    return $Result['email']; // Devolvemos el email
                } else {
                    return null; // Si no se encuentra el cliente
                }
            } else {
                return null; // Si hubo un error en la consulta
            }
        }
    
    public function Set_Client_Mailer($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `email_marketing` = 1 WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Cliente agregado al lista de email marketing";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function SetClientTags($id, $tags)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $tags = mysqli_real_escape_string($this->DBLink, $tags);

        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `tags` = '{$tags}' WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Cliente agregado al lista de email marketing";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function HabilitarSMS($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `sms_habilitado` = 1 WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Cliente agregado al lista de email marketing";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function SetClienteFelicitado($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `felicitado` = 1 WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Cliente agregado al lista de email marketing";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }



    public function SetEnviadoSMS($id, $fecha_enviado)

        {

        $fecha_enviado = mysqli_real_escape_string($this->DBLink, $fecha_enviado);



        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `sms` SET `estado` = 'Enviado',`fecha_envio` = '{$fecha_enviado}' WHERE (`id_sms` = '{$id}');");



        if ($sql)

            {

            echo "Cliente agregado al lista de email marketing";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function DeshabilitarSMS($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `sms_habilitado` = 0 WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Cliente agregado al lista de email marketing";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function Unset_Client_Mailer($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `email_marketing` = 0 WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Cliente agregado al lista de email marketing";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function CreateNota($cuerpo, $id_cliente)

        {



        $cuerpo = mysqli_real_escape_string($this->DBLink, $cuerpo);



        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);



        $fecha = date('Y-m-d H:i:s');

        $user_id = $_SESSION['id'];

        $sql = mysqli_query($this->DBLink, "INSERT INTO `notas` (`cuerpo`, `fecha`, `id_cliente`) VALUES ('{$cuerpo}', '{$fecha}',  '{$id_cliente}');");

        if ($sql)

            {

            echo $fecha;

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CreateFase($nombre, $id_cliente)

        {



        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);



        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `fases` (`nombre`, `id_cliente`) VALUES ('{$nombre}', '{$id_cliente}');");

        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }



    public function CreateSector($nombre, $id_cliente)

        {



        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);



        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `sectores` (`nombre`, `id_cliente`) VALUES ('{$nombre}', '{$id_cliente}');");

        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CreateTipoDePelo($nombre)

        {



        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `tipo_pelo` (`nombre`) VALUES ('{$nombre}');");

        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CreateObra($nombre, $id_cliente)

        {



        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);



        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `obras` (`nombre`, `id_cliente`) VALUES ('{$nombre}', '{$id_cliente}');");

        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CreateZona($nombre, $id_cliente)

        {



        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);



        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `zonas` (`nombre`, `id_cliente`) VALUES ('{$nombre}', '{$id_cliente}');");

        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CrearSMS($client_id, $estado, $cuerpo, $fecha_programado, $tag = null, $fecha_envio = null)

        {

        $fecha_programado = mysqli_real_escape_string($this->DBLink, $fecha_programado);

        $tag = mysqli_real_escape_string($this->DBLink, $tag);

        $tag = !empty($tag) ? "'$tag'" : "NULL";

        $fecha_programado = !empty($fecha_programado) ? "'$fecha_programado'" : "NULL";

        $cuerpo = mysqli_real_escape_string($this->DBLink, $cuerpo);

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        if ($fecha_envio == null)

            {

            $sql = mysqli_query($this->DBLink, "INSERT INTO `sms` (`client_id`, `fecha_programado`, `fecha_envio`, `estado`, `cuerpo`, `id_tag`) VALUES ('{$client_id}', {$fecha_programado}, NULL, '{$estado}', '{$cuerpo}', {$tag});");

            } else

            {

            $fecha_envio = mysqli_real_escape_string($this->DBLink, $fecha_envio);

            $sql = mysqli_query($this->DBLink, "INSERT INTO `sms` (`client_id`, `fecha_programado`, `fecha_envio`, `estado`, `cuerpo`, `id_tag`) VALUES ('{$client_id}', {$fecha_programado}, '{$fecha_envio}', '{$estado}', '{$cuerpo}', {$tag});");

            }



        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CreateEstadoSubvencion($nombre)

        {



        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `estado_subvencion` (`nombre`) VALUES ('{$nombre}');");

        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function DeleteEstadoSubvencion($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `estado_subvencion` WHERE (`id_estado_subvencion`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function DeleteObra($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `obras` WHERE (`id_obra`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function DeleteZona($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `zonas` WHERE (`id_zona`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }



    public function DeleteSector($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `sectores` WHERE (`id_sector`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function DeleteTipoDePelo($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `tipo_pelo` WHERE (`id_tipo_pelo`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function DeleteFase($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `fases` WHERE (`id_fase`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function EditCliente($id_cliente_editar, $nombre, $direccion, $telefono, $cp, $cif, $email, $fecha_nacimiento)

        {

        $fecha_nacimiento = mysqli_real_escape_string($this->DBLink, $fecha_nacimiento);

        $id_cliente_editar = mysqli_real_escape_string($this->DBLink, $id_cliente_editar);

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);

        $direccion = mysqli_real_escape_string($this->DBLink, $direccion);

        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);

        $cp = mysqli_real_escape_string($this->DBLink, $cp);

        $cif = mysqli_real_escape_string($this->DBLink, $cif);

        $email = mysqli_real_escape_string($this->DBLink, $email);



        $direccion = !empty($direccion) ? "'$direccion'" : "NULL";

        $telefono = !empty($telefono) ? "'$telefono'" : "NULL";

        $cp = !empty($cp) ? "'$cp'" : "NULL";

        $cif = !empty($cif) ? "'$cif'" : "NULL";

        $sql = mysqli_query($this->DBLink, "UPDATE `clientes`



			SET `nombre` = '{$nombre}',

			`direccion` = $direccion,

			`telefono` = $telefono,

			`cp` = $cp,

			`cif` = $cif,

			`fecha_nacimiento` = '{$fecha_nacimiento}',

			`email` = '{$email}'

			WHERE (`client_id` = '{$id_cliente_editar}');");



        if ($sql)

            {

            echo "Cliente editado correctamente.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CreateCliente($nombre, $direccion, $telefono, $cp, $cif, $email, $fecha_nacimiento, $peluqueria = "No")

        {

        $peluqueria = mysqli_real_escape_string($this->DBLink, $peluqueria);

        $fecha_nacimiento = mysqli_real_escape_string($this->DBLink, $fecha_nacimiento);

        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);

        $direccion = mysqli_real_escape_string($this->DBLink, $direccion);

        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);

        $cp = mysqli_real_escape_string($this->DBLink, $cp);

        $cif = mysqli_real_escape_string($this->DBLink, $cif);

        $email = mysqli_real_escape_string($this->DBLink, $email);

        $fecha = date('Y-m-d');

        $user_id = $_SESSION['id'];



        $direccion = !empty($direccion) ? "'$direccion'" : "NULL";

        $telefono = !empty($telefono) ? "'$telefono'" : "NULL";

        $cp = !empty($cp) ? "'$cp'" : "NULL";

        $cif = !empty($cif) ? "'$cif'" : "NULL";



        $sql = mysqli_query($this->DBLink, "INSERT INTO `clientes` (`nombre`, `direccion`, `telefono`, `cp`, `cif`, `email`,`fecha`,`user_id`,`estado`,`fecha_nacimiento`,`peluqueria`) VALUES ('{$nombre}', $direccion,  $telefono, $cp, $cif, '{$email}', '{$fecha}', '{$user_id}', 'Potencial', '{$fecha_nacimiento}', '{$peluqueria}');");



        if ($sql)

            {

            echo ("New record2");

            return mysqli_insert_id($this->DBLink);



            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);



            }

        }



    public function AddFotosCliente($client_id, $fotos)

        {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        $fotos = mysqli_real_escape_string($this->DBLink, $fotos);



        $sql = mysqli_query($this->DBLink, "UPDATE `datos_cliente_peluqueria` SET `fotos` = '{$fotos}' WHERE (`client_id` = '{$client_id}');");



        if ($sql)

            {

            echo "Apartado editado correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function GetFotosCliente($client_id)

        {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        //Search this User Logins on the DataBase



        $Query = mysqli_query($this->DBLink, "SELECT * FROM `datos_cliente_peluqueria` WHERE (`client_id` = '{$client_id}');");



        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1)

            {

            $Result = array();



            while ($Login = mysqli_fetch_assoc($Query))

                {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

                }



            return $Result;

            }



        //Can't Get the Users List

        return -2;

        }



        public function GetVentasCliente($client_id)

        {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        //Search this User Logins on the DataBase



        $Query = mysqli_query($this->DBLink, "SELECT e.*, 

        COALESCE(m.nombre, 'Ninguno') AS nombre_modelo, 

        COALESCE(ma.nombre, 'Ninguna') AS nombre_marca, 

        COALESCE(f.nombre, 'Ninguna') AS nombre_financiera, 

        COALESCE(r.nombre, 'Ninguna') AS nombre_metodo, 

        COALESCE(a.nombre, 'Ninguno') AS nombre_cliente,

        COALESCE(v.fecha_matriculacion, 'Ninguna') AS fecha_matriculacion,

        CASE 

            WHEN e.id_financiera IS NULL THEN NULL

            WHEN DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) < NOW() THEN TRUE

            ELSE FALSE

        END AS financiacion_vencida,

        DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) AS fecha_vencimiento

 FROM `ventas` e

 LEFT JOIN `vehiculos` v ON e.id_vehiculo = v.id_vehiculo

 LEFT JOIN `modelos` m ON v.id_modelo = m.id_modelo

 LEFT JOIN `marcas` ma ON v.id_marca = ma.id_marca

 LEFT JOIN `clientes` a ON e.client_id = a.client_id

 LEFT JOIN `metodos_pago` r ON e.id_metodo = r.id_metodo

 LEFT JOIN `financieras` f ON e.id_financiera = f.id_financiera

        WHERE (`client_id` = '{$client_id}');");



        //Sucessfull Query

        if ($Query && mysqli_num_rows($Query) >= 1)

            {

            $Result = array();



            while ($Login = mysqli_fetch_assoc($Query))

                {

                $Result[] = $Login;

                //$Result['login_id']

                //$Result['login_user']

                //$Result['login_ip']

                //$Result['login_agent']

                //$Result['login_success']

                //$Result['login_date']

                }



            return $Result;

            }



        //Can't Get the Users List

        return -2;

        }

    public function CreateDatosClientePeluqeria($client_id, $user_id, $id_sector, $id_tipo_pelo, $id_fase)

        {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);



        $id_sector = !empty($id_sector) ? "'$id_sector'" : "NULL";

        $id_tipo_pelo = !empty($id_tipo_pelo) ? "'$id_tipo_pelo'" : "NULL";

        $id_fase = !empty($id_fase) ? "'$id_fase'" : "NULL";



        $sql = mysqli_query($this->DBLink, "INSERT INTO `datos_cliente_peluqueria` (`client_id`, `user_id`, `id_sector`, `id_tipo_pelo`, `id_fase`)

		VALUES ({$client_id}, {$user_id},  {$id_sector}, {$id_tipo_pelo},{$id_fase});");



        if ($sql)

            {

            echo ("New record2");



            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);



            }

        }

    public function EditDatosClientePeluqeria($id, $client_id, $user_id, $id_sector, $id_tipo_pelo, $id_fase)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);



        $id_sector = !empty($id_sector) ? "'$id_sector'" : "NULL";

        $id_tipo_pelo = !empty($id_tipo_pelo) ? "'$id_tipo_pelo'" : "NULL";

        $id_fase = !empty($id_fase) ? "'$id_fase'" : "NULL";



        $sql = mysqli_query($this->DBLink, "UPDATE `datos_cliente_peluqueria` SET

		`client_id`={$client_id},

		`user_id`={$user_id},

		`id_sector`={$id_sector},

		`id_tipo_pelo`={$id_tipo_pelo},

		`id_fase`={$id_fase}

		WHERE (`id_datos_cliente_peluqueria` = '{$id}');");



        if ($sql)

            {

            echo ("New record2");



            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);



            }

        }



    public function CreateSubvencion($titulo, $estado, $descripcion, $email_marketing, $url_generico, $url_autonomo, $url_sociedad)

        {



        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);

        $email_marketing = mysqli_real_escape_string($this->DBLink, $email_marketing);



        $url_generico = mysqli_real_escape_string($this->DBLink, $url_generico);

        $url_autonomo = mysqli_real_escape_string($this->DBLink, $url_autonomo);

        $url_sociedad = mysqli_real_escape_string($this->DBLink, $url_sociedad);

        $url_generico = !empty($url_generico) ? "'$url_generico'" : "NULL";

        $url_autonomo = !empty($url_autonomo) ? "'$url_autonomo'" : "NULL";

        $url_sociedad = !empty($url_sociedad) ? "'$url_sociedad'" : "NULL";



        $sql = mysqli_query($this->DBLink, "INSERT INTO `subvenciones` (`titulo`, `estado`, `descripcion`, `email_marketing`, `url_generico`,`url_autonomo`,`url_sociedad`)

														VALUES ('{$titulo}',  '{$estado}',  '{$descripcion}', '{$email_marketing}', {$url_generico}, {$url_autonomo}, {$url_sociedad});");



        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }



    public function EditSubvencion($id, $titulo, $estado, $descripcion, $email_marketing, $url_generico, $url_autonomo, $url_sociedad)

        {



        $id = mysqli_real_escape_string($this->DBLink, $id);

        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);

        $email_marketing = mysqli_real_escape_string($this->DBLink, $email_marketing);

        $url_generico = mysqli_real_escape_string($this->DBLink, $url_generico);

        $url_autonomo = mysqli_real_escape_string($this->DBLink, $url_autonomo);

        $url_sociedad = mysqli_real_escape_string($this->DBLink, $url_sociedad);

        $url_generico = !empty($url_generico) ? "'$url_generico'" : "NULL";

        $url_autonomo = !empty($url_autonomo) ? "'$url_autonomo'" : "NULL";

        $url_sociedad = !empty($url_sociedad) ? "'$url_sociedad'" : "NULL";



        $sql = mysqli_query($this->DBLink, "UPDATE `subvenciones` SET

			`titulo`='{$titulo}',

`estado`='{$estado}',

`descripcion`='{$descripcion}',

`email_marketing`='{$email_marketing}',

`url_generico`={$url_generico},

`url_autonomo`={$url_autonomo},

`url_sociedad`={$url_sociedad}

WHERE (`id_subvencion` = '{$id}');");



        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function EliminarClienteSubvencion($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `cliente_subvencion` WHERE (`id_cliente_subvencion`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function EliminarSMS($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `sms` WHERE (`id_sms`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function CreateClienteSubvencion($id_cliente, $id_subvencion, $fecha_envio = null)

        {



        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);

        $id_subvencion = mysqli_real_escape_string($this->DBLink, $id_subvencion);



        $fecha_envio = mysqli_real_escape_string($this->DBLink, $fecha_envio);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `cliente_subvencion` (`id_cliente`, `id_subvencion`,`fecha_envio`)

															VALUES ('{$id_cliente}', '{$id_subvencion}', '{$fecha_envio}');");

        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }



    public function EnviarSubvencion($id, $fecha_envio)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $fecha_envio = mysqli_real_escape_string($this->DBLink, $fecha_envio);



        $sql = mysqli_query($this->DBLink, "UPDATE `subvenciones` SET `fecha_envio` = '{$fecha_envio}' , `estado` = 'Aceptado' WHERE (`id_subvencion` = '{$id}');");



        if ($sql)

            {

            echo "Apartado ac correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function EnviarSMS($id, $fecha_envio)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $fecha_envio = mysqli_real_escape_string($this->DBLink, $fecha_envio);



        $sql = mysqli_query($this->DBLink, "UPDATE `sms` SET `estado` = 'Enviado' , `fecha_envio` = '{$fecha_envio}' WHERE (`id_sms` = '{$id}');");



        if ($sql)

            {

            echo "Apartado ac correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }



    public function ContratarCliente($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `estado` = 'Contratado' WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Apartado editado correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function SetEstadoCliente($id, $estado)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        $sql = mysqli_query($this->DBLink, "UPDATE `clientes` SET `subvencionado` = '{$estado}' WHERE (`client_id` = '{$id}');");



        if ($sql)

            {

            echo "Apartado editado correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function SetEstadoClienteSubvencion($id, $estado)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        $sql = mysqli_query($this->DBLink, "UPDATE `cliente_subvencion` SET `estado` = '{$estado}' WHERE (`id_cliente_subvencion` = '{$id}');");



        if ($sql)

            {

            echo "Apartado editado correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function SetEstadoClienteSubvencion2($id, $estado)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);

        $sql = mysqli_query($this->DBLink, "UPDATE `cliente_subvencion` SET `id_estado_subvencion` = '{$estado}' WHERE (`id_cliente_subvencion` = '{$id}');");



        if ($sql)

            {

            echo "Apartado editado correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }



    public function CambiarImagen($Avatar, $id)

        {



        $id = mysqli_real_escape_string($this->DBLink, $id);

        //Declare the Image Upload Library

        if (!($this->Upload instanceof _ImageUpload))

            {

            $this->Upload = new _ImageUpload($this->DBLink);

            }



        $Avatar = $this->Upload->_SaveImage($Avatar);



        $Avatar = mysqli_real_escape_string($this->DBLink, WEBSITE_URL . 'image.php?id=' . $Avatar);



        //Update this User Avatar

        if (!mysqli_query($this->DBLink, "UPDATE `clientes` SET `imagen` = '{$Avatar}' WHERE (`client_id` = '{$id}');"))

            {

            //DataBase Query Error

            return -6;

            }

        return true;

        }



    public function SubirImagen($image)

        {



        //Declare the Image Upload Library

        if (!($this->Upload instanceof _ImageUpload))

            {

            $this->Upload = new _ImageUpload($this->DBLink);

            }



        $Avatar = $this->Upload->_SaveImage($image);



        $res = mysqli_real_escape_string($this->DBLink, WEBSITE_URL . 'image.php?id=' . $Avatar["url"]);



        return $res;

        }



    public function CreateFolder($FolderName, $PulledApart, $Folder, $Tags)

        {

        $FolderName = mysqli_real_escape_string($this->DBLink, $FolderName);

        $PulledApart = mysqli_real_escape_string($this->DBLink, $PulledApart);

        $Folder = mysqli_real_escape_string($this->DBLink, $Folder);

        $Tags = mysqli_real_escape_string($this->DBLink, $Tags);

        $Time = time();



        //Verificar que exista la carpeta

        if ($Folder != 0)

            {

            $Query = mysqli_query($this->DBLink, "SELECT `folder_id` FROM `folders` WHERE (`folder_id` = '{$Folder}' AND `folder_section` = '{$PulledApart}');");



            //Sucessfull Search

            if (!($Query && mysqli_num_rows($Query) > 0))

                {



                return -1;

                }

            }



        if ($Folder != 0)

            {



            $Address = $this->GetAddressFolder($Folder);

            } else

            {

            $Address = '/';

            }



        if (!mysqli_query($this->DBLink, "INSERT INTO `folders` (`folder_user`, `folder_name`, `folder_section`, `folder_folder`, `folder_address`, `folder_tag`, `folder_data`) VALUES ('{$_SESSION['id']}', '{$FolderName}',  '{$PulledApart}', '{$Folder}', '{$Address}', '{$Tags}', '{$Time}');"))

            {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);



            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);



            return -3;

            }



        $FolderID = mysqli_insert_id($this->DBLink);



        //Crear carpeta en el servidor

        $estructura = './folders' . $Address . $FolderID;

        if (!mkdir($estructura, 0777, true))

            {

            return -4;

            }



        return true;



        }

    public function UpdateNota($id, $cuerpo)

        {

        $cuerpo = mysqli_real_escape_string($this->DBLink, $cuerpo);

        $id = mysqli_real_escape_string($this->DBLink, $id);



        $sql = mysqli_query($this->DBLink, "UPDATE `notas` SET `cuerpo` = '{$cuerpo}' WHERE (`id_nota` = '{$id}');");



        if ($sql)

            {

            echo "Nota editada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }



    public function CreateFavorite($TypeID, $Type)

        {

        $TypeID = mysqli_real_escape_string($this->DBLink, $TypeID);

        $Type = mysqli_real_escape_string($this->DBLink, $Type);



        $Time = time();



        //Si ya se ha a帽adido a favorito, elimina el favorito

        if (is_array($this->GetFavoriteTypeID($_SESSION['id'], $TypeID)))

            {



            $DataFavorite = $this->GetFavoriteTypeID($_SESSION['id'], $TypeID);

            //Delete favorite

            if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_id` = '{$DataFavorite['favorite_id']}');"))

                {

                //Revert the DataBase Queries

                mysqli_rollback($this->DBLink);



                //Start the DataBase Auto-Commit

                mysqli_autocommit($this->DBLink, true);



                return -10;

                }



            return -1;

            }



        if (!is_array($this->GetFileID($TypeID)) && !is_array($this->GetFolderID($TypeID)))

            {

            return -2;

            }



        if (!mysqli_query($this->DBLink, "INSERT INTO `favorites` (`favorite_user`, `favorite_type`, `favorite_type_id`, `favorite_data`) VALUES ('{$_SESSION['id']}', '{$Type}',  '{$TypeID}', '{$Time}');"))

            {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);



            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);



            return -2;

            }

        return true;



        }

    public function DeleteNota($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `notas` WHERE (`id_nota`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }



    public function DeleteCliente($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `clientes` WHERE (`client_id`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function DeleteSubvencion($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `subvenciones` WHERE (`id_subvencion`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }



    public function DeleteFolder($FolderID)

        {

        $FolderID = mysqli_real_escape_string($this->DBLink, $FolderID);

        $Address = $this->GetAddressFolder($FolderID);



        if ($QueryCountFolder = mysqli_query($this->DBLink, "SELECT folder_id FROM `folders` WHERE folder_id = {$FolderID}"))

            {

            //Check for valid Search

            if ($QueryCountFolder && mysqli_num_rows($QueryCountFolder) == 0)

                {



                return -6;

                }



            }



        $estructura = './folders' . $Address;

        //Eliminar carpeta y todo lo que haya dentro

        $this->deleteDirectory($estructura);



        //Eliminar carpetas dentro de la carpeta en la BBDD

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `folders`"))

            {

            $Folders = array();



            //Loop around the folders

            while ($Result = mysqli_fetch_assoc($Query))

                {



                $array = explode("/", $Result['folder_address']);

                $CountArray = count($array);

                //Comprobar si coincide la ruta

                for ($i = 0; $i <= $CountArray - 1; $i++)

                    {

                    //Si coincida la ruta

                    if ($array[$i] == $FolderID)

                        {



                        if (!mysqli_query($this->DBLink, "DELETE FROM `folders` WHERE (`folder_id` = '{$Result['folder_id']}');"))

                            {

                            //Can't Delete this User

                            return -1;

                            }



                        if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$Result['folder_id']}' AND `favorite_type` = '');"))

                            {

                            //Revert the DataBase Queries

                            mysqli_rollback($this->DBLink);



                            //Start the DataBase Auto-Commit

                            mysqli_autocommit($this->DBLink, true);



                            return -2;

                            }



                        }



                    }

                }



            }



        //Eliminar archivos dentro de la carpeta

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `files`"))

            {

            $Files = array();



            //Loop around the files

            while ($Result = mysqli_fetch_assoc($Query))

                {



                $array = explode("/", $Result['file_address']);

                $CountArray = count($array);

                //Comprobar si coincide la ruta

                for ($i = 0; $i <= $CountArray - 1; $i++)

                    {

                    //Si coincida la ruta

                    if ($array[$i] == $FolderID)

                        {

                        //Eliminar archivos de la BD

                        if (!mysqli_query($this->DBLink, "DELETE FROM `files` WHERE (`file_id` = '{$Result['file_id']}');"))

                            {

                            //Can't Delete this User

                            return -1;

                            }



                        if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$Result['file_id']}' AND `favorite_type` != '');"))

                            {

                            //Revert the DataBase Queries

                            mysqli_rollback($this->DBLink);



                            //Start the DataBase Auto-Commit

                            mysqli_autocommit($this->DBLink, true);



                            return -2;

                            }



                        }



                    }

                }



            }

        //Eliminar carpeta

        if (!mysqli_query($this->DBLink, "DELETE FROM `folders` WHERE (`folder_id` = '{$FolderID}');"))

            {

            //Can't Delete this User

            return -1;

            }



        //eliminar favorito

        if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$FolderID}' AND `favorite_type` = '');"))

            {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);



            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);



            return -2;

            }

        return true;

        }



    public function DeleteFiles($FileID)

        {

        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);



        if ($Query = mysqli_query($this->DBLink, "SELECT file_id, file_name, file_extension, file_address FROM `files` WHERE file_id = '$FileID'"))

            {

            $Result = mysqli_fetch_assoc($Query);



            $estructura = './folders' . $Result['file_address'] . $Result['file_name'] . '.' . $Result['file_extension'];



            @unlink($estructura);



            if (!mysqli_query($this->DBLink, "DELETE FROM `favorites` WHERE (`favorite_type_id` = '{$Result['file_id']}' AND `favorite_type` != '');"))

                {

                //Revert the DataBase Queries

                mysqli_rollback($this->DBLink);



                //Start the DataBase Auto-Commit

                mysqli_autocommit($this->DBLink, true);



                return -2;

                }



            }



        //Eliminar archivo

        if (!mysqli_query($this->DBLink, "DELETE FROM `files` WHERE (`file_id` = '{$FileID}');"))

            {

            //Can't Delete this User

            return -1;

            }



        return true;

        }



    public function GetListClientes()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `clientes`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListGrupos()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `grupos`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListSMS($FechaInicio = 0, $FechaFinal = 0)

        {

        if ($FechaInicio != 0 && $FechaFinal != 0)

            {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `sms` where (fecha_envio BETWEEN '{$FechaInicio}' AND '{$FechaFinal}');"))

                {

                $Clientes = array();



                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query))

                    {

                    $Clientes[] = $Result;

                    }



                return $Clientes;

                }



            } else

            {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `sms`;"))

                {

                $Clientes = array();



                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query))

                    {

                    $Clientes[] = $Result;

                    }



                return $Clientes;

                }

            }

        }

    public function GetListClientesSMS()

        {



        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `clientes` WHERE `sms_habilitado` = 1 ;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListSubvenciones($FechaInicio = 0, $FechaFinal = 0)

        {

        if ($FechaInicio != 0 && $FechaFinal != 0)

            {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `subvenciones`where (fecha BETWEEN '{$FechaInicio}' AND '{$FechaFinal}');"))

                {

                $Clientes = array();



                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query))

                    {

                    $Clientes[] = $Result;

                    }



                return $Clientes;

                }

            } else

            {

            if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `subvenciones`;"))

                {

                $Clientes = array();



                //Loop around the Referrals

                while ($Result = mysqli_fetch_assoc($Query))

                    {

                    $Clientes[] = $Result;

                    }



                return $Clientes;

                }

            }

        }

    public function GetListObras()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `obras`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListSectores()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `sectores`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListTiposDePelo()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tipo_pelo`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListSubvencionesEnviadas()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `cliente_subvencion`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListSubvencionesEnviadasCliente($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `cliente_subvencion` WHERE id_cliente = {$ClienteID};"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }



    public function GetNotasCliente($id)

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `notas`WHERE (`id_cliente` = '{$id}');"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetClientesEnviarMail()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `clientes`WHERE (`email_marketing` = 1);"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }



    public function GetUltimoEnvio($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM sms WHERE fecha_envio = (SELECT MAX(fecha_envio) FROM sms) AND client_id = {$ClienteID};"))

            {



            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }

            if (empty($Folders))

                {

                return null;

                } else

                {

                return $Folders[0];



                }

            }



        }

    public function GetEnviosTag($Tag)

        {



        $Tag = mysqli_real_escape_string($this->DBLink, $Tag);



        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM sms WHERE fecha_envio = (SELECT MAX(fecha_envio) FROM sms) AND tag = '{$Tag}';"))

            {



            $Array = array();

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Array[] = $Result;

                }

            if (empty($Array))

                {

                return null;

                } else

                {

                return $Array[0]['fecha_envio'];



                }



            }



        }



    public function ClientesTags()

        {



        if ($Query = mysqli_query($this->DBLink, "SELECT client_id , tags FROM `clientes`"))

            {



            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }

            if (empty($Folders))

                {

                return null;

                } else

                {

                return $Folders;

                }

            }

        }



    public function GetCliente($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `clientes` WHERE client_id = {$ClienteID}"))

            {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }



            return $Folders[0];

            }

        }

    public function GetSector($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `sectores` WHERE id_sector = {$ClienteID}"))

            {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }



            return $Folders[0];

            }

        }

    public function GetFase($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fases` WHERE id_fase = {$ClienteID}"))

            {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }



            return $Folders[0];

            }

        }

    public function GetTipoPelo($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tipo_pelo` WHERE id_tipo_pelo = {$ClienteID}"))

            {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }



            return $Folders[0];

            }

        }

    public function GetDatosClientePeluqueria($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `datos_cliente_peluqueria` WHERE client_id = {$ClienteID}"))

            {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }



            return $Folders[0];

            }

        }



    public function GetEstadoSubvencion($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `estado_subvencion` WHERE id_estado_subvencion = {$ClienteID}"))

            {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }



            return $Folders[0];

            }

        }

    public function GetSubvencion($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `subvenciones` WHERE id_subvencion = {$ClienteID}"))

            {

            $Folders = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Folders[] = $Result;

                }



            return $Folders[0];

            }

        }



    public function GetClientesCount()

        {

        //Count the Users on the DataBase

        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`client_id`) AS `total` FROM `clientes`;"))

            {

            $Result = mysqli_fetch_assoc($Query);



            //If the Count Exists

            if (isset($Result['total']))

                {

                return $Result['total'];

                } else

                {

                return -1;

                }

            //DataBase Query Error

            } else

            {

            return -2;

            }

        }



    public function RenameFile($FileID, $FileName)

        {

        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);

        $FileName = mysqli_real_escape_string($this->DBLink, $FileName);



        $File = $this->GetFileID($FileID);

        $Adress = "./folders" . $File['file_address'] . $File['file_name'] . '.' . $File['file_extension'];

        $Rename = "./folders" . $File['file_address'] . $FileName . '.' . $File['file_extension'];

        rename($Adress, $Rename);



        //Update the file name

        if (!mysqli_query($this->DBLink, "UPDATE `files` SET `file_name` = '{$FileName}' WHERE (`file_id` = '{$FileID}');"))

            {

            //Revert the DataBase Queries

            mysqli_rollback($this->DBLink);



            //Start the DataBase Auto-Commit

            mysqli_autocommit($this->DBLink, true);



            return -1;

            }



        return true;

        }



    public function EditDatosCliente($id, $cif, $cp, $telefono, $email, $nombre_comercial, $id_sector, $id_fase, $id_zona, $tipo, $numero_empleados, $importe, $tipo_enlace, $user_id, $domicilio, $titulo)

        {



        $id = mysqli_real_escape_string($this->DBLink, $id);

        $cif = mysqli_real_escape_string($this->DBLink, $cif);

        $cp = mysqli_real_escape_string($this->DBLink, $cp);

        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);

        $email = mysqli_real_escape_string($this->DBLink, $email);

        $nombre_comercial = mysqli_real_escape_string($this->DBLink, $nombre_comercial);

        $id_sector = !empty($id_sector) ? "'$id_sector'" : "NULL";

        $id_fase = !empty($id_fase) ? "'$id_fase'" : "NULL";

        $id_zona = !empty($id_zona) ? "'$id_zona'" : "NULL";

        $tipo = mysqli_real_escape_string($this->DBLink, $tipo);

        $numero_empleados = mysqli_real_escape_string($this->DBLink, $numero_empleados);

        $importe = mysqli_real_escape_string($this->DBLink, $importe);

        $tipo_enlace = mysqli_real_escape_string($this->DBLink, $tipo_enlace);

        $user_id = mysqli_real_escape_string($this->DBLink, $user_id);

        $domicilio = mysqli_real_escape_string($this->DBLink, $domicilio);

        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);

        $sql = mysqli_query($this->DBLink, "UPDATE `datos_cliente`



			SET

			`cif` = '{$cif}',

			`cp` = '{$cp}',

			`telefono` = '{$telefono}',

			`email` = '{$email}',

			`nombre_comercial` = '{$nombre_comercial}',

			`id_sector` = {$id_sector},

			`id_fase` = {$id_fase},

			`id_zona` = {$id_zona},

			`tipo` = '{$tipo}',

			`numero_empleados` = '{$numero_empleados}',

			`importe` = '{$importe}',

			`tipo_enlace` = '{$tipo_enlace}',

			`user_id` = '{$user_id}',

			`domicilio` = '{$domicilio}',

			`titulo` = '{$titulo}'

			WHERE (`id_datos_cliente` = '{$id}');");



        if ($sql)

            {

            echo "DAtos editado correctamente.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function setFechaClienteSubvencion($id_cliente_subvencion, $fecha_envio)

        {

        $fecha_envio = mysqli_real_escape_string($this->DBLink, $fecha_envio);

        $id_cliente_subvencion = mysqli_real_escape_string($this->DBLink, $id_cliente_subvencion);

        $sql = mysqli_query($this->DBLink, "UPDATE `cliente_subvencion`

		SET

			`fecha_envio` = '{$fecha_envio}'



			WHERE (`id_cliente_subvencion` = '{$id_cliente_subvencion}');");



        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function setTagClienteSubvencion($id_cliente_subvencion, $tag)

        {

        $tag = mysqli_real_escape_string($this->DBLink, $tag);

        $id_cliente_subvencion = mysqli_real_escape_string($this->DBLink, $id_cliente_subvencion);

        $sql = mysqli_query($this->DBLink, "UPDATE `cliente_subvencion`

		SET

			`tag` = '{$tag}'



			WHERE (`id_cliente_subvencion` = '{$id_cliente_subvencion}');");



        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function EditClienteSubvencion($id, $id_cliente, $email_marketing, $url_portada, $condiciones)

        {



        $id = mysqli_real_escape_string($this->DBLink, $id);

        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);

        $url_portada = mysqli_real_escape_string($this->DBLink, $url_portada);

        $condiciones = mysqli_real_escape_string($this->DBLink, $condiciones);

        $email_marketing = mysqli_real_escape_string($this->DBLink, $email_marketing);



        $sql = mysqli_query($this->DBLink, "UPDATE `cliente_subvencion`

		SET

			`id_cliente` = '{$id_cliente}',

			`url_portada` = '{$url_portada}',

			`condiciones` = '{$condiciones}',

			`email_marketing` = '{$email_marketing}',

			`fecha_envio` = NULL,

			`estado` = 'No enviado'

			WHERE (`id_cliente_subvencion` = '{$id}');");



        if ($sql)

            {

            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function CreateTag($nombre)

        {



        $nombre = mysqli_real_escape_string($this->DBLink, $nombre);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `tag` ( `nombre`) VALUES ( '{$nombre}');");

        if ($sql)

            {



            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }



    public function DeleteTag($id)

        {



        $sql = mysqli_query($this->DBLink, "DELETE FROM `tag` WHERE (`id_tag`='{$id}')");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function GetTag($ClienteID)

        {

        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tag` WHERE id_tag = {$ClienteID};"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }

            if (!empty($Clientes))

                {

                return $Clientes[0];

                } else

                {

                return null;

                }



            }

        }

    public function GetTagList()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tag`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function CreateTagCliente($id_tag, $client_id)

        {



        $id_tag = mysqli_real_escape_string($this->DBLink, $id_tag);



        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);



        $sql = mysqli_query($this->DBLink, "INSERT INTO `tag_cliente` (`id_tag`, `client_id`) VALUES ('{$id_tag}', '{$client_id}');");

        if ($sql)

            {



            echo "Records added successfully.";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }

        }

    public function GetTagClienteList()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tag_cliente`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetListUploads()

        {

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `uploads`;"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetTagsCliente($client_id)

        {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tag_cliente` WHERE client_id = '{$client_id}';"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetTagsClienteByIdTag($client_id)

        {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tag_cliente` WHERE id_tag = '{$client_id}';"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function GetTagsClienteById($client_id)

        {

        $client_id = mysqli_real_escape_string($this->DBLink, $client_id);

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `tag_cliente` WHERE client_id = '{$client_id}';"))

            {

            $Clientes = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query))

                {

                $Clientes[] = $Result;

                }



            return $Clientes;

            }

        }

    public function DeleteTagCliente($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "DELETE FROM `tag_cliente` WHERE (`id_tag_cliente`='{$id}');");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }

    public function DeleteTagClienteByClientId($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "DELETE FROM `tag_cliente` WHERE (`client_id`='{$id}');");



        if ($sql)

            {

            echo "Nota eliminada correctamente";

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }







    public function GetEstadoCliente($id)

        {

        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "SELECT COUNT(*) AS cantidad_presupuestos

        FROM presupuestos

        WHERE id_cliente = $id AND estado = 'Aceptado'");

        if ($sql)

            {

            $Result = mysqli_fetch_assoc($sql);



            $cantidadPresupuestos = $Result['cantidad_presupuestos'];

            if ($cantidadPresupuestos > 0)

                {

                return "Aceptado";

                } else

                {

                return "Potencial";

                }

            } else

            {

            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);

            }



        }





    }