<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__'))
    {
    exit();
    }

class _ApartadoModel
    {
    private $DBLink;

    public function __construct(&$DBLink)
        {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
            {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
            } else
            {
            trigger_error('No MySQL connection!', E_USER_ERROR);
            }

        $Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false)
            {
            $Users->_Logout();

            header('Location: ./login');
            exit();
            }
        }

    public function CreateApartado($titulo, $descripcion, $cantidad, $precio_unitario)
        {

        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);
        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);
        $cantidad = mysqli_real_escape_string($this->DBLink, $cantidad);
        $precio_unitario = mysqli_real_escape_string($this->DBLink, $precio_unitario);

        $fecha = date('Y-m-d H:i:s');

        $sql = mysqli_query($this->DBLink, "INSERT INTO `apartados` (`titulo`, `descripcion`, `cantidad`, `precio_unitario`,`fecha`) VALUES ('{$titulo}', '{$descripcion}',  '{$cantidad}', '{$precio_unitario}', '{$fecha}');");
        if ($sql)
            {
            echo "Records added successfully.";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }
        }





    public function GetListMedidas()
        {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `medidas`;"))
            {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Clientes[] = $Result;
                }

            return $Clientes;
            }
        }

    public function GetListApartados()
        {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `apartados`;"))
            {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Clientes[] = $Result;
                }

            return $Clientes;
            }
        }
    public function GetCliente($ClienteID)
        {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `clientes` WHERE client_id = {$ClienteID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders;
            }
        }
    public function GetMedidaByName($ClienteID)
        {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `medidas` WHERE nombre = {$ClienteID}"))
            {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query))
                {
                $Folders[] = $Result;
                }

            return $Folders[0];
            }
        }

    public function DeleteApartado($id)
        {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `apartados` WHERE apartado_id={$id}");

        if ($sql)
            {
            echo "Apartado eliminado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }
    public function UpdateApartado($id, $titulo, $descripcion, $cantidad, $precio)
        {
        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);
        $descripcion = mysqli_real_escape_string($this->DBLink, $descripcion);
        $cantidad = mysqli_real_escape_string($this->DBLink, $cantidad);
        $precio = mysqli_real_escape_string($this->DBLink, $precio);

        $sql = mysqli_query($this->DBLink, "UPDATE `apartados` SET `titulo` = '{$titulo}', `descripcion` = '{$descripcion}',`cantidad` = '{$cantidad}',`precio_unitario` = '{$precio}' WHERE (`apartado_id` = '{$id}');");

        if ($sql)
            {
            echo "Apartado editado correctamente";
            } else
            {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
            }

        }

    public function GetApartadosCount()
        {
        //Count the Users on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`apartado_id`) AS `total` FROM `apartados`;"))
            {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total']))
                {
                return $Result['total'];
                } else
                {
                return -1;
                }
            //DataBase Query Error
            } else
            {
            return -2;
            }
        }



    }