<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) {
    exit();
}

class _AlbaranesModel
{
    private $DBLink;

    public function __construct(&$DBLink)
    {
        //Continue if DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $Users->_IsLogged() == false) {
            $Users->_Logout();

            header('Location: ./login');
            exit();
        }
    }

    public function CreateAlbaran($titulo, $id_cliente, $numero, $condiciones, $estado, $tipo, $detallado, $importe, $fecha, $id_fase, $id_sector, $id_obra, $domicilio, $telefono, $cp, $cif, $email, $usuario, $importe_final, $igic, $irpf, $id_tramitadora, $id_gestor, $id_contable)
    {

        $igic = mysqli_real_escape_string($this->DBLink, $igic);
        $irpf = mysqli_real_escape_string($this->DBLink, $irpf);
        $irpf = !empty($irpf) ? "'$irpf'" : "NULL";
        // $id_tramitadora = mysqli_real_escape_string($this->DBLink, $id_tramitadora);
        // $id_gestor = mysqli_real_escape_string($this->DBLink, $id_gestor);
        // $id_contable = mysqli_real_escape_string($this->DBLink, $id_contable);
        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);
        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);
        $numero = mysqli_real_escape_string($this->DBLink, $numero);
        $condiciones = mysqli_real_escape_string($this->DBLink, $condiciones);

        $estado = mysqli_real_escape_string($this->DBLink, $estado);
        $tipo = mysqli_real_escape_string($this->DBLink, $tipo);
        $detallado = mysqli_real_escape_string($this->DBLink, $detallado);
        $importe = mysqli_real_escape_string($this->DBLink, $importe);
        $importe_final = mysqli_real_escape_string($this->DBLink, $importe_final);

        $fecha = mysqli_real_escape_string($this->DBLink, $fecha);
        $id_fase = mysqli_real_escape_string($this->DBLink, $id_fase);
        $id_sector = mysqli_real_escape_string($this->DBLink, $id_sector);
        $id_obra = mysqli_real_escape_string($this->DBLink, $id_obra);

        $id_obra = !empty($id_obra) ? "'$id_obra'" : "NULL";
        $id_sector = !empty($id_sector) ? "'$id_sector'" : "NULL";
        $id_fase = !empty($id_fase) ? "'$id_fase'" : "NULL";
        $id_tramitadora = !empty($id_tramitadora) ? "'$id_tramitadora'" : "NULL";
        $id_gestor = !empty($id_gestor) ? "'$id_gestor'" : "NULL";
        $id_contable = !empty($id_contable) ? "'$id_contable'" : "NULL";

        $domicilio = mysqli_real_escape_string($this->DBLink, $domicilio);
        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);
        $cp = mysqli_real_escape_string($this->DBLink, $cp);
        $cif = mysqli_real_escape_string($this->DBLink, $cif);

        $email = mysqli_real_escape_string($this->DBLink, $email);
        $usuario = mysqli_real_escape_string($this->DBLink, $usuario);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `albaranes` (`importe_final`,`titulo`, `id_cliente`, `numero`, `condiciones`, `estado`, `tipo`,`fecha`,`detallado`,`importe`,`id_obra`,`id_sector`,`id_fase`, `domicilio`, `telefono`, `cp`, `cif`, `email`, `id_usuario`, `igic`, `irpf`, `id_tramitadora`, `id_gestor`,`id_contable` )
															VALUES ('{$importe_final}','{$titulo}', '{$id_cliente}','{$numero}','{$condiciones}', '{$estado}','{$tipo}','{$fecha}','{$detallado}', '{$importe}', $id_obra, $id_sector, $id_fase, '{$domicilio}',  '{$telefono}', '{$cp}', '{$cif}', '{$email}', '{$usuario}', {$igic}, {$irpf},{$id_tramitadora}, {$id_gestor}, {$id_contable});");
        if ($sql) {
            return mysqli_insert_id($this->DBLink);
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }

    public function EditAlbaran($id_albaran, $titulo, $id_cliente, $numero, $condiciones, $estado, $tipo, $detallado, $importe, $fecha, $id_fase, $id_sector, $id_obra, $domicilio, $telefono, $cp, $cif, $email, $usuario, $importe_final, $igic, $irpf)
    {
        $id_albaran = mysqli_real_escape_string($this->DBLink, $id_albaran);
        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);
        $id_cliente = mysqli_real_escape_string($this->DBLink, $id_cliente);
        $numero = mysqli_real_escape_string($this->DBLink, $numero);
        $condiciones = mysqli_real_escape_string($this->DBLink, $condiciones);
        $importe_final = mysqli_real_escape_string($this->DBLink, $importe_final);
        $estado = mysqli_real_escape_string($this->DBLink, $estado);
        $tipo = mysqli_real_escape_string($this->DBLink, $tipo);
        $detallado = mysqli_real_escape_string($this->DBLink, $detallado);
        $importe = mysqli_real_escape_string($this->DBLink, $importe);
        $igic = mysqli_real_escape_string($this->DBLink, $igic);
        $irpf = mysqli_real_escape_string($this->DBLink, $irpf);
        $irpf = !empty($irpf) ? "'$irpf'" : "NULL";

        /*
        $importe= number_format($importe,2,"."," ");
        $importe_final= $importe;
        $importe_final = $importe_final + number_format($importe * 0.07,2,"."," ");
        $importe_final = $importe_final + number_format($importe * 0.21,2,"."," ");

        if($tipo == "Empresa"){
        $importe_final = $importe_final - number_format($importe * 0.15 ,2,"."," ");

        }*/
        $fecha = mysqli_real_escape_string($this->DBLink, $fecha);
        $id_fase = mysqli_real_escape_string($this->DBLink, $id_fase);
        $id_sector = mysqli_real_escape_string($this->DBLink, $id_sector);
        $id_obra = mysqli_real_escape_string($this->DBLink, $id_obra);

        $id_obra = !empty($id_obra) ? "'$id_obra'" : "NULL";
        $id_sector = !empty($id_sector) ? "'$id_sector'" : "NULL";
        $id_fase = !empty($id_fase) ? "'$id_fase'" : "NULL";

        $domicilio = mysqli_real_escape_string($this->DBLink, $domicilio);
        $telefono = mysqli_real_escape_string($this->DBLink, $telefono);
        $cp = mysqli_real_escape_string($this->DBLink, $cp);
        $cif = mysqli_real_escape_string($this->DBLink, $cif);

        $email = mysqli_real_escape_string($this->DBLink, $email);
        $usuario = mysqli_real_escape_string($this->DBLink, $usuario);

        $sql = mysqli_query($this->DBLink, "UPDATE `albaranes`

		SET `titulo` = '{$titulo}',
		`id_cliente` = '{$id_cliente}',
		`numero` = '{$numero}',
		`condiciones` = '{$condiciones}',
		`estado` = '{$estado}',
		`tipo` = '{$tipo}',
		`fecha` = '{$fecha}',
		`detallado` = '{$detallado}',
		`importe` = '{$importe}',
		`id_obra` = $id_obra,
		`id_sector` = $id_sector,
		`id_fase` = $id_fase,
		`domicilio` = '{$domicilio}',
		`telefono` = '{$telefono}',
		`cp` = '{$cp}',
		`cif` = '{$cif}',
		`email` = '{$email}',
		`importe_final` = '{$importe_final}',
		`id_usuario` = '{$usuario}',
		`igic` = {$igic},
		`irpf` = {$irpf}
		WHERE (`id_albaran` = '{$id_albaran}');");

        if ($sql) {
            echo "Records added successfully.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }
    public function GetAlbaran($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `albaranes` WHERE (`id_albaran` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }
    public function GetSector($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `sectores` WHERE (`id_sector` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }
    public function GetFase($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fases` WHERE (`id_fase` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }
    public function GetObra($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `obras` WHERE (`id_obra` = '{$id}');")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders[0];
        }
    }

    public function ReenviarAlbaran($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `albaranes` SET `estado` = 'Pendiente' WHERE (`id_albaran` = '{$id}');");

        if ($sql) {
            echo "Albaran reenviado";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function EliminarAlbaran($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `albaranes` WHERE (`id_albaran` = '{$id}');");

        if ($sql) {
            echo "Albaran eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function EliminarCondicion($id)
    {

        $sql = mysqli_query($this->DBLink, "DELETE FROM `condiciones` WHERE (`id_condicion` = '{$id}');");

        if ($sql) {
            echo "Albaran eliminado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function UpdateCondicion($id, $condicion, $titulo)
    {
        $condicion = mysqli_real_escape_string($this->DBLink, $condicion);
        $id = mysqli_real_escape_string($this->DBLink, $id);
        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);

        $sql = mysqli_query($this->DBLink, "UPDATE `condiciones` SET `condicion` = '{$condicion}',`titulo` = '{$titulo}' WHERE (`id_condicion` = '{$id}');");

        if ($sql) {
            echo "Apartado editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function CreateCondicion($condicion, $titulo)
    {

        $condicion = mysqli_real_escape_string($this->DBLink, $condicion);
        $titulo = mysqli_real_escape_string($this->DBLink, $titulo);

        $sql = mysqli_query($this->DBLink, "INSERT INTO `condiciones` (`condicion`,`titulo`) VALUES ('{$condicion}','{$titulo}');");
        if ($sql) {
            echo "Records added successfully.";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }
    }
    public function GetListCondiciones()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `condiciones`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListImpuestos()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `impuestos`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListProgramados()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `albaran_programado`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListProgramadosPendientes($fecha)
    {
        $fecha = mysqli_real_escape_string($this->DBLink, $fecha);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `albaranes` WHERE `programado` IS NOT NULL AND `programado` >= '{$fecha}';")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }

    public function GetListProgramadasPendientes($fecha)
    {
        $fecha = mysqli_real_escape_string($this->DBLink, $fecha);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `facturas` WHERE `programado` IS NOT NULL AND `programado` >= '{$fecha}';")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function EnviarAlbaranProgramado($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `albaran_programado` SET `estado` = 'Enviado' WHERE (`id_albaran_programado` = '{$id}');");

        if ($sql) {
            echo "Enviado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }
    public function RechazarAlbaran($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `albaranes` SET `estado` = 'Rechazado' WHERE (`id_albaran` = '{$id}');");

        if ($sql) {
            echo "Apartado editado correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function AceptarAlbaran($id)
    {
        $id = mysqli_real_escape_string($this->DBLink, $id);

        $sql = mysqli_query($this->DBLink, "UPDATE `albaranes` SET `estado` = 'Aceptado' WHERE (`id_albaran` = '{$id}');");

        if ($sql) {
            echo "Apartado ac correctamente";
        } else {
            echo "ERROR: Could not able to execute $sql. " . mysqli_error($this->DBLink);
        }

    }

    public function GetListAlbaranes()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `albaranes`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetAlbaranesCliente($ClienteID)
    {
        $ClienteID = mysqli_real_escape_string($this->DBLink, $ClienteID);
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `albaranes` WHERE id_cliente = {$ClienteID}")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

            return $Folders;
        }
    }

    public function GetListObras()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `obras`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListSectores()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `sectores`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }
    public function GetListFases()
    {
        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `fases`;")) {
            $Clientes = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Clientes[] = $Result;
            }

            return $Clientes;
        }
    }

    public function GetAlbaranesCount()
    {
        //Count the Users on the DataBase
        if ($Query = mysqli_query($this->DBLink, "SELECT COUNT(`id_albaran`) AS `total` FROM `albaranes`;")) {
            $Result = mysqli_fetch_assoc($Query);

            //If the Count Exists
            if (isset($Result['total'])) {
                return $Result['total'];
            } else {
                return -1;
            }
            //DataBase Query Error
        } else {
            return -2;
        }
    }

    public function RenameFile($FileID, $FileName)
    {
        $FileID = mysqli_real_escape_string($this->DBLink, $FileID);
        $FileName = mysqli_real_escape_string($this->DBLink, $FileName);

        $File = $this->GetFileID($FileID);
        $Adress = "./folders" . $File['file_address'] . $File['file_name'] . '.' . $File['file_extension'];
        $Rename = "./folders" . $File['file_address'] . $FileName . '.' . $File['file_extension'];
        rename($Adress, $Rename);

        //Update the file name
        if (!mysqli_query($this->DBLink, "UPDATE `files` SET `file_name` = '{$FileName}' WHERE (`file_id` = '{$FileID}');")) {
            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -1;
        }

        return true;
    }

}