<?php
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	
	ini_set('memory_limit', '256M');
	ini_set('max_execution_time', 60);
	ini_set('upload_max_filesize', '12M');
	ini_set('post_max_size', '12M');

	class _ImageUpload {
		private $DBLink;

		private $UploadsPath	= './uploads';		//The Directory for Save the Uploaded Images
		private $MaximumSize	= 10000;			//The Maximun Size of the Uploaded Image (on KiloBytes)
		private $FileNameSize	= 25;				//The Image File Name Length (Minimum Length is 10 Characters and Maximum Length is 100)
		
		private $MimeType;
		private $Size;
		
		public function __construct(&$DBLink, $UploadPath = null, $MaximumSize = null, $FileNameSize = null) {
			//Continue if DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			if ($UploadPath !== null) {
				$this->UploadsPath = $UploadPath;
			}
			
			if ($MaximumSize !== null) {
				$this->MaximumSize = $MaximumSize;
			}
			
			if ($FileNameSize !== null) {
				$this->FileNameSize = $FileNameSize;
			}
			
			//Pass the Maximum Size from Bytes to KiloBytes
			$this->MaximumSize = $this->MaximumSize * 1000;
			
			//Check the Image File Name Length
			if ($this->FileNameSize < 10) {
				$this->FileNameSize = 10;
			}
		}
		
		//https://github.com/bjorno43/ImageSecure/blob/master/imgupload.class.php
		public function _SaveImage($ImageFile) {
			if (!$this->_CheckFunctions()) {
				return -1;
			}
			
			//Check for Image Upload Errors
			if (empty($ImageFile['tmp_name']) || $ImageFile['error'] !== 0) {
				return -2;
			}
			
			//Checks for Valid Image Mime Type
			if (!$this->_CheckMime($ImageFile['tmp_name'])) {
				return -3;
			}
			
			//Checks for Valid Image Size
			if (!$this->_CheckSize($ImageFile['tmp_name'])) {
				return -4;
			}
			
			//Creates a Random File in the Upload Directory
			$RandomFile = $this->_RandomFile($this->UploadsPath);
			
			//Move the Uploaded Image to the Random File
			if (move_uploaded_file($ImageFile['tmp_name'], $this->UploadsPath.'/'.$RandomFile)) {
				$Content = file_get_contents($this->UploadsPath.'/'.$RandomFile);
				
				//Check for Errors Reading the File
				if ($Content === false) {
					return -5;
				}
				
				//Generate the Encryption Password
				$Password = $this->_AESPassword();
				
				if ($Password === false) {
					return -6;
				}
				
				//Encrypt the File Content on AES-256 CBC Mode
				$Content = $this->_AESEncrypt($Content, $Password);
				
				if ($Content === false) {
					return -7;
				}
				
				//Write the Encrypted File on the Uploads folder
				if (file_put_contents($this->UploadsPath.'/'.$RandomFile, $Content) === false) {
					//Error Writing the File
					return -8;
				}
				
				$RandomFile			= mysqli_real_escape_string($this->DBLink, $RandomFile);
				$ImageFile['name']	= mysqli_real_escape_string($this->DBLink, $ImageFile['name']);
				$this->MimeType		= mysqli_real_escape_string($this->DBLink, $this->MimeType);
				$Password			= mysqli_real_escape_string($this->DBLink, $Password);
				
				//Get the Actual Time
				$Time = time();
				
				//Add this File to the DataBase
				if (!mysqli_query($this->DBLink, "INSERT INTO `uploads` (`upload_name`, `upload_original_name`, `upload_mime_type`,
				 `upload_size`, `upload_password`, `upload_date`) VALUES
				  ('{$RandomFile}', '{$ImageFile['name']}', '{$this->MimeType}', '{$this->Size}', '{$Password}', '{$Time}');")) {
					//Delete the Encrypted File
					unlink($this->UploadsPath.'/'.$RandomFile);
					
					return -9;
				}
				$object = (object) [
					'id' => mysqli_insert_id($this->DBLink),
					'url' => $RandomFile,
				  ];
				
				return $object;
			//Check for Errors
			} else {
				//Delete the Temporal Uploaded File
				unlink($ImageFile['tmp_name']);
				
				return -10;
			}
			
			return -11;
		}
		
		public function _ReadImage($ImageID) {
			$ImageID = mysqli_real_escape_string($this->DBLink, $ImageID);
			
			//Check for Invalid Image ID
			if (!is_string($ImageID) || strlen($ImageID) < 10 || strlen($ImageID) > 100) {
				return -1;
			}
			
			$Query = mysqli_query($this->DBLink, "SELECT * FROM `uploads` WHERE (`upload_name` = '{$ImageID}') LIMIT 1;");
			
			if ($Query && mysqli_num_rows($Query) == 1) {
				$File = mysqli_fetch_assoc($Query);
				//$File['upload_id']
				//$File['upload_name']
				//$File['upload_original_name']
				//$File['upload_mime_type']
				//$File['upload_size']
				//$File['upload_password']
				//$File['upload_date']
				
				$Content = file_get_contents($this->UploadsPath.'/'.$File['upload_name']);

				//Check for Errors Reading the File
				if ($Content === false) {
					return -2;
				}
				
				//Decrypt the File Content from AES-256 CBC Mode
				$Content = $this->_AESDecrypt($Content, $File['upload_password']);
				
				if ($Content === false) {
					return -3;
				}
				
				//Return the Decrypted Content
				return $Content;
			}
			
			return -4;
		}
		
		public function _ShowImage($ImageID) {
			$ImageID = mysqli_real_escape_string($this->DBLink, $ImageID);
			
			//Check for Invalid Image ID
			if (!is_string($ImageID) || strlen($ImageID) < 10 || strlen($ImageID) > 100) {
				return -1;
			}
			
			$Query = mysqli_query($this->DBLink, "SELECT * FROM `uploads` WHERE (`upload_name` = '{$ImageID}') LIMIT 1;");
			
			if ($Query && mysqli_num_rows($Query) == 1) {
				$File = mysqli_fetch_assoc($Query);
				//$File['upload_id']
				//$File['upload_name']
				//$File['upload_original_name']
				//$File['upload_mime_type']
				//$File['upload_size']
				//$File['upload_password']
				//$File['upload_date']
				
				$Content = file_get_contents($this->UploadsPath.'/'.$File['upload_name']);

				//Check for Errors Reading the File
				if ($Content === false) {
					return -2;
				}
				
				//Decrypt the File Content from AES-256 CBC Mode
				$Content = $this->_AESDecrypt($Content, $File['upload_password']);
				
				if ($Content === false) {
					return -3;
				}
				
				//Send the Correct Headers
				header('Content-Type: '.$File['upload_mime_type']);
				
				//Display the Decrypted File
				echo $Content;
				
				return true;
			}
			
			return -4;
		}
		
		public function _DownloadImage($ImageID) {
			$ImageID = mysqli_real_escape_string($this->DBLink, $ImageID);
			
			//Check for Invalid Image ID
			if (!is_string($ImageID) || strlen($ImageID) < 10 || strlen($ImageID) > 100) {
				return -1;
			}
			
			$Query = mysqli_query($this->DBLink, "SELECT * FROM `uploads` WHERE (`upload_name` = '{$ImageID}') LIMIT 1;");
			
			if ($Query && mysqli_num_rows($Query) == 1) {
				$File = mysqli_fetch_assoc($Query);
				//$File['upload_id']
				//$File['upload_name']
				//$File['upload_original_name']
				//$File['upload_mime_type']
				//$File['upload_size']
				//$File['upload_password']
				//$File['upload_date']
				
				$Content = file_get_contents($this->UploadsPath.'/'.$File['upload_name']);

				//Check for Errors Reading the File
				if ($Content === false) {
					return -2;
				}
				
				//Decrypt the File Content from AES-256 CBC Mode
				$Content = $this->_AESDecrypt($Content, $File['upload_password']);
				
				if ($Content === false) {
					return -3;
				}
				
				//Send the Correct Headers
				header('Content-Description: File Transfer');
				header('Content-Disposition: attachment; filename='.$File['upload_original_name']);
				header('Expires: 0');
				header('Cache-Control: must-revalidate');
				header('Pragma: public');
				header('Content-Length: '.$File['upload_size']);
				header('Content-Type: '.$File['upload_mime_type']);
				
				//Display the Decrypted File
				echo $Content;
				
				return true;
			}
			
			return -4;
		}
		
		public function _ImageInformation($ImageID) {
			$ImageID = mysqli_real_escape_string($this->DBLink, $ImageID);
			
			//Check for Invalid Image ID
			if (!is_string($ImageID) || strlen($ImageID) < 10 || strlen($ImageID) > 100) {
				return -1;
			}
			
			$Query = mysqli_query($this->DBLink, "SELECT `upload_name` AS `name`, `upload_original_name` AS `original_name`, `upload_mime_type` AS `mime_type`, `upload_size` AS `size`, `upload_date` AS `date` FROM `uploads` WHERE (`upload_name` = '{$ImageID}') LIMIT 1;");
			
			if ($Query && mysqli_num_rows($Query) == 1) {
				$File = mysqli_fetch_assoc($Query);
				//$File['name']
				//$File['original_name']
				//$File['mime_type']
				//$File['size']
				//$File['date']
				
				return $File;
			}
			
			return -2;
		}
		
		public function _DeleteImage($ImageID) {
			$ImageID = mysqli_real_escape_string($this->DBLink, $ImageID);
			
			//Check for Invalid Image ID
			if (!is_numeric($ImageID) || $ImageID <= 0 || $ImageID >= 10000000) {
				return -1;
			}
			
			$Query = mysqli_query($this->DBLink, "SELECT * FROM `uploads` WHERE (`upload_id` = '{$ImageID}') LIMIT 1;");
			
			if ($Query && mysqli_num_rows($Query)) {
				$File = mysqli_fetch_assoc($Query);
				//$File['upload_id']
				//$File['upload_name']
				//$File['upload_original_name']
				//$File['upload_mime_type']
				//$File['upload_size']
				//$File['upload_password']
				//$File['upload_date']
				//Check for DataBase Error
				
				if (!mysqli_query($this->DBLink, "DELETE FROM `uploads` WHERE (`upload_id` = '{$ImageID}') LIMIT 1;")) {
					return -2;
				}
				
				if (!unlink($File['upload_name'])) {
					return -3;
				}
				
				return true;
			}
			
			return -4;
		}
		
		private function _CheckFunctions() {
			//Check if the FileInfo and OpenSSL Extensions are loaded
			if (extension_loaded('fileinfo') && extension_loaded('openssl')) {
				return true;
			}
			
			return false;
		}
		
		//https://www.php.net/manual/es/function.finfo-open.php
		//https://www.php.net/manual/es/function.finfo-file.php
		private function _CheckMime($File){
			$FileInfo = finfo_open(FILEINFO_MIME_TYPE);
			$MimeType = finfo_file($FileInfo, $File);
			
			finfo_close($FileInfo);
			
			if (strpos($MimeType, 'image/') === 0 || strpos($MimeType, 'application/pdf') === 0) {
				$this->MimeType = $MimeType;
				
				return true;
			}
			
			return false;
		}
		
		//https://www.php.net/manual/es/function.finfo-open.php
		//https://www.php.net/manual/es/function.finfo-file.php
		private function _CheckSize($File) {
			if (filesize($File) <= $this->MaximumSize) {
				$this->Size = filesize($File);
				
				return true;
			}
			
			return false;
		}
		
		//Creates a File with a Random Name
		private function _RandomFile($Path) {
			while (true) {
				$Name = $this->_RandomString($this->FileNameSize);
				if (!file_exists($Path.'/'.$Name)) break;
			}
			
			return $Name;
		}
		
		//Creates a Random Alpha-Numeric String
		private function _RandomString($Length = 10, $Chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ') {
			$Result = '';
			
			for ($i = 0; $i < $Length; $i++) {
				$Result .= $Chars[mt_rand(0, strlen($Chars) - 1)];
			}
			
			return $Result;
		}
		
		//https://bhoover.com/using-php-openssl_encrypt-openssl_decrypt-encrypt-decrypt-data/
		//Generates a Random AES-256 CBC Password
		private function _AESPassword() {
			return base64_encode(openssl_random_pseudo_bytes(32));
		}
		
		//Encrypt any Data with AES-256 CBC
		private function _AESEncrypt($Data, $Password) {
			//Remove the Base64 encoding from the Password
			$Password = base64_decode($Password);
			
			if ($Password === false) {
				return false;
			}
			
			//Generate an initialization vector
			$IV = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
			
			if ($IV === false) {
				return false;
			}
			
			//Encrypt the data using AES 256 encryption in CBC mode using our encryption key and initialization vector.
			$Data = openssl_encrypt($Data, 'aes-256-cbc', $Password, 0, $IV);
			
			if ($Data === false) {
				return false;
			}
			
			//The $IV is just as important as the key for decrypting, so save it with our encrypted data using a unique separator (::)
			return base64_encode($Data.'::'.$IV);
		}
		
		//Decrypt any Data with AES-256 CBC
		private function _AESDecrypt($Data, $Password) {
			//Remove the Base64 encoding from the Password
			$Password = base64_decode($Password);
			
			if ($Password === false) {
				return false;
			}
			
			//To decrypt, split the encrypted data from our IV - our unique separator used was "::"
			list($Data, $IV) = explode('::', base64_decode($Data), 2);
			
			return openssl_decrypt($Data, 'aes-256-cbc', $Password, 0, $IV);
		}
	}
?>