<?php

require '/home/wfudjpum/intranet.emerload.com/vendor/autoload.php';
require_once '/home/wfudjpum/intranet.emerload.com/core/configuration.php';
require_once '/home/wfudjpum/intranet.emerload.com/models/mailer.model.php';
require_once '/home/wfudjpum/intranet.emerload.com/models/users.model.php';
require_once '/home/wfudjpum/intranet.emerload.com/models/clientes.model.php';

$Clientes = new _ClientesModel($DBLink);
$Usuario = new _UsersModel($DBLink);
$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);
$Clientes_list = $Clientes->GetListClientesSMS();
$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
date_default_timezone_set("Europe/Madrid");
if ($personalizacion['zona_oferta_cumpleanos'] == 'Europe/Madrid')
    {
    $Hoy = strtotime(date("Y-m-d H:i", time()));
    } else
    {
    $Hoy = strtotime(date("Y-m-d H:i", time())) - 3600;
    }

$Hoy = strtotime(date("Y-m-d H:i", time()));

$SMS = $Clientes->GetListSMS();

if (date("H:i", $Hoy) == $personalizacion['hora_oferta_cumpleanos'])
    {

    $cumpleañeros = [];
    foreach ($Clientes_list as $Cliente)
        {

        $fechin = date("m-d", $Hoy);
        $cumple = date("m-d", strtotime($Cliente['fecha_nacimiento']));
        if ($cumple == $fechin && $Cliente['sms_habilitado'] == 1)
            {

            array_push($cumpleañeros, $Cliente['telefono']);

            $Clientes->CrearSMS($Cliente['client_id'], "Enviado", htmlentities($personalizacion['mensaje_oferta_cumpleanos'], ENT_QUOTES), date("Y-m-d H:i:s", $Hoy), "", date("Y-m-d H:i:s", $Hoy));

            $Clientes->SetClienteFelicitado($Cliente['client_id']);
            }
        }

    $messagebird = new \MessageBird\Client('4ybAO6CrwJP422SqJ0ZGGO8cA');
    $Message = new \MessageBird\Objects\Message();
    $Message->originator = '+5492284728052';
    $Message->recipients = $cumpleañeros;
    $Message->body = htmlentities($personalizacion['mensaje_oferta_cumpleanos'], ENT_QUOTES);

    try
        {
        $response = $messagebird->messages->create($Message);
        echo var_dump($response);
        } catch (Exception $e)
        {
        echo $e->getMessage();
        }

    }

$destinatarios = [];
$messagebird = new \MessageBird\Client('4ybAO6CrwJP422SqJ0ZGGO8cA');
foreach ($SMS as $S)
    {
    if ($S["estado"] == "Programado" && $S["fecha_programado"] == date("Y-m-d H:i", $Hoy) . ":00")
        {
        $Cliente = $Clientes->GetCliente($S["client_id"]);
        if ($Cliente['sms_habilitado'] == 1)
            {
            $Clientes->SetEnviadoSMS($S["id_sms"], date("Y-m-d H:i:s", $Hoy));
            array_push($destinatarios, $Cliente['telefono']);
            $Message = new \MessageBird\Objects\Message();
            $Message->originator = '+5492284728052';
            $Message->recipients = $destinatarios;
            $Message->body = $S["cuerpo"];
            try
                {
                $response = $messagebird->messages->create($Message);
                echo var_dump($response);
                } catch (Exception $e)
                {
                echo $e->getMessage();
                }
            }

        }
    }

$Jornadas = $Usuario->GetListJornadas();

$Dia = date("w", $Hoy);
$Ahora = date("H:i", $Hoy);

//echo "<br/>";
//echo $Ahora . "<br/>";

switch ($Dia)
    {
    case '1':
        foreach ($Jornadas as $J)
            {
            $FichajeActivo = $Usuario->GetFichajeActivo($J["id_miembro"]);
            $Horario = date("H:i", strtotime($J["lunes_e"]) + 7200);
            if ($FichajeActivo == null)
                {

                if ($Ahora == $Horario)
                    {
                    $Usuario->CreateAnomalia(null, $J["id_miembro"], "2 horas pasadas del horario de entrada.");
                    }

                }
            }
        // do something
        break;
    case '2':
        foreach ($Jornadas as $J)
            {
            $FichajeActivo = $Usuario->GetFichajeActivo($J["id_miembro"]);
            $Horario = date("H:i", strtotime($J["martes_e"]) + 7200);
            if ($FichajeActivo == null)
                {

                if ($Ahora == $Horario)
                    {
                    $Usuario->CreateAnomalia("", $J["id_miembro"], "2 horas pasadas del horario de entrada.");
                    }

                }
            }
        // do something
        break;
    case '3':
        foreach ($Jornadas as $J)
            {
            $FichajeActivo = $Usuario->GetFichajeActivo($J["id_miembro"]);
            $Horario = date("H:i", strtotime($J["miercoles_e"]) + 7200);
            if ($FichajeActivo == null)
                {

                if ($Ahora == $Horario)
                    {
                    $Usuario->CreateAnomalia("", $J["id_miembro"], "2 horas pasadas del horario de entrada.");
                    }

                }
            }
        // do something
        break;
    case '4':
        foreach ($Jornadas as $J)
            {
            $FichajeActivo = $Usuario->GetFichajeActivo($J["id_miembro"]);
            $Horario = date("H:i", strtotime($J["jueves_e"]) + 7200);
            if ($FichajeActivo == null)
                {

                if ($Ahora == $Horario)
                    {
                    $Usuario->CreateAnomalia("", $J["id_miembro"], "2 horas pasadas del horario de entrada.");
                    }

                }
            }
        // do something
        break;

    case '5':
        foreach ($Jornadas as $J)
            {
            $FichajeActivo = $Usuario->GetFichajeActivo($J["id_miembro"]);
            $Horario = date("H:i", strtotime($J["viernes_e"]) + 7200);
            if ($FichajeActivo == null)
                {

                if ($Ahora == $Horario)
                    {
                    $Usuario->CreateAnomalia("", $J["id_miembro"], "2 horas pasadas del horario de entrada.");
                    }

                }
            }
        // do something
        break;
    case '6':
        foreach ($Jornadas as $J)
            {
            $FichajeActivo = $Usuario->GetFichajeActivo($J["id_miembro"]);
            $Horario = date("H:i", strtotime($J["sabado_e"]) + 7200);
            if ($FichajeActivo == null)
                {

                if ($Ahora == $Horario)
                    {
                    $Usuario->CreateAnomalia("", $J["id_miembro"], "2 horas pasadas del horario de entrada.");
                    }

                }
            }
        // do something
        break;
    }

if ($_SESSION['avatar'] == "1")
    {
    $Usuario->_Logout();
    }