<?php
	//Include the MVC Configuration
	require_once('./core/configuration.php');
	
	//Include the Users Model
	require_once(__MODELS__.'users.model.php');
	
	//Include the Mailer Model
	require_once(__MODELS__.'mailer.model.php');
	
	//Declare the Users Model
	$Users = new _UsersModel($DBLink);
	
	//Declare the Mailer Model
	$Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_RESTORE_USERNAME, EMAIL_RESTORE_PASSWORD);
	
	//Get the Newsletter Content
	$Newsletter = file_get_contents('./newsletter.html');
	
	//Check for Newsletter Reading Error
	if ($Newsletter == false) {
		echo 'Error Reading the Newsletter File!'.PHP_EOL;
		exit();
	}
	
	//Open the E-Mails File
	$File = fopen('emails.txt', 'r');
	
	//Check if the E-Mails File is Open
	if ($File) {
		//Loop until all file line by line
		while (($Line = fgets($File)) !== false) {
			//Register the User in the DataBase
			$UserID = $Users->_Register('Name', 'Surname', trim($Line), 'S@mPl3P4$$W0rD!', '', 1, 0, 0);
			
			echo $UserID;
			
			//Check for Error on Register
			if ($UserID < 0) {
				file_put_contents('emails_errors.txt' , trim($Line).PHP_EOL, FILE_APPEND);
				echo '-1'.PHP_EOL;
				continue;
			}
			
			//Get this User Information
			$User = $Users->_GetUserData($UserID);
			//$User['user_id']
			//$User['user_role']
			//$User['user_origin']
			//$User['user_referrer']
			//$User['user_referrals']
			//$User['user_email']
			//$User['user_password']
			//$User['user_full_name']
			//$User['user_purchases']
			//$User['user_tokens']
			//$User['user_blocked_tokens']
			//$User['user_bonus_tokens']
			//$User['user_bonus_blocked_tokens']
			//$User['user_oneups']
			//$User['user_bonuses']
			//$User['user_address']
			//$User['user_avatar']
			//$User['user_code']
			//$User['user_verification_status']
			//$User['user_last_seen']
			//$User['user_first_seen']
			
			//Check for Error getting the User Information
			if (!is_array($User) || $User < 0) {
				file_put_contents('emails_errors.txt' , trim($Line).PHP_EOL, FILE_APPEND);
				echo '-2'.PHP_EOL;
				continue;
			}
			
			//Get the Update Code for this User
			$Update = $Users->_GetUpdateCode($User['user_id']);
			
			//Check for Error getting the User Update Code
			if (!is_string($Update) || $Update < 0) {
				file_put_contents('emails_errors.txt' , trim($Line).PHP_EOL, FILE_APPEND);
				echo '-3'.PHP_EOL;
				continue;
			}
			
			$Newsletter = str_replace('{REFERRER_LINK}', 'https://panel.oneupsaves.io/'.'register?referrer='.urlencode($User['user_code']), $Newsletter);
			$Newsletter = str_replace('{REGISTRATION_LINK}', 'https://panel.oneupsaves.io/'.'update?email='.urlencode($User['user_email']).'&code='.urlencode($Update), $Newsletter);
			
			//Send the E-Mail to the User
			$EMail = $Mailer->_Mail(EMAIL_RESTORE_USERNAME, trim($Line), 'Activa tu Cuenta', $Newsletter, 'OneUP Saves');
			
			//Check for Valid E-Mail
			if ($EMail !== true) {
				echo $EMail;
				exit();
				file_put_contents('emails_errors.txt' , trim($Line).PHP_EOL, FILE_APPEND);
				echo '-4'.PHP_EOL;
				continue;
			}
			
			file_put_contents('emails_success.txt' , trim($Line).PHP_EOL, FILE_APPEND);
			
			echo trim($Line).PHP_EOL;
		}

		fclose($File);
	//Error Opening the E-Mails File
	} else {
		echo 'Error Opening the E-Mails File!'.PHP_EOL;
	}
?>