<?php
require __ROOT__ . '/vendor/autoload.php';
require_once __ROOT__ . '/core/configuration.php';
require_once __ROOT__ . '/models/mailer.model.php';
require_once __ROOT__ . '/models/users.model.php';
include __ROOT__ . ("/api/utils.php");

$dbConn = connect($db);
$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);
$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
$Usuario = new _UsersModel($DBLink);

$currentDateTime = new DateTime();
$currentDateTimeFormatted = $currentDateTime->format('Y-m-d');
$diasEnvioITV = $personalizacion["dias_envio_itv"];
$metodoEnvioITV = $personalizacion["metodo_envio_itv"];
$username = 'empiresystems';
$password = 'Greenwich.500';
echo "Fecha de hoy: " . $currentDateTimeFormatted . "</br>";
echo "Cantidad de días de plazo de vencimiento: " . $diasEnvioITV . "</br>";
$vendidos = getVendidos($dbConn);

echo "</br>";
foreach ($vendidos as $vendido) {
    $fechaVencimiento = new DateTime($vendido["proxima_itv"]);
    $hoy = new DateTime();

    if ($vendido["envio_vencimiento"] != "1") {
        echo "El cliente esta deshabilitado para los envios.</br>";
        continue;
    }

    if ($fechaVencimiento < $hoy) {
        echo "La fecha de vencimiento ha pasado.</br>";
        continue;
    } else {
        echo "La fecha de vencimiento aún no ha pasado.</br>";
    }
    $diferenciaDias = $hoy->diff($fechaVencimiento)->days;

    if ($diferenciaDias == $diasEnvioITV) {
        echo "La fecha de hoy tiene la misma cantidad (" . $diferenciaDias . ") de días de diferencia con la fecha de vencimiento (" . $vendido["proxima_itv"] . ") del vehiculo que los días especificados (" . $diasEnvioITV . ").</br>";
        if ($metodoEnvioITV == "email") {
            $texto = html_entity_decode($personalizacion["cuerpo_email_itv"]);
        }
        if ($metodoEnvioITV == "sms") {
            $texto = html_entity_decode($personalizacion["cuerpo_sms_itv"]);
        }
        if ($metodoEnvioITV == "emailsinosms") {
            $texto = html_entity_decode($personalizacion["cuerpo_email_itv"]);
        }


        $nombre = explode(' ', $vendido["nombre_cliente"])[0];
        $nombreyapellido = $vendido["nombre_cliente"];
        $fechadehoy = date('Y-m-d');
        $marca = $vendido["nombre_marca"];
        $modelo = $vendido["nombre_modelo"];
        $fechadevencimiento = $vendido["proxima_itv"];
        $matricula = $vendido["matricula"];
        $texto = str_replace('%nombre%', $nombre, $texto);
        $texto = str_replace('%matricula%', $matricula, $texto);
        $texto = str_replace('%nombreyapellido%', $nombreyapellido, $texto);
        $texto = str_replace('%fechadehoy%', $fechadehoy, $texto);
        $texto = str_replace('%marca%', $marca, $texto);
        $texto = str_replace('%modelo%', $modelo, $texto);
        $texto = str_replace('%fechadevencimiento%', $fechadevencimiento, $texto);
        $enviado = true;
        if ($metodoEnvioITV == "email") {
            if (
                $mailer->_Mail(
                    EMAIL_VALIDATE_USERNAME,
                    htmlentities($vendido["email"], ENT_QUOTES),
                    html_entity_decode($personalizacion["asunto_email_itv"]),
                    $texto,
                    htmlentities($personalizacion["nombre"], ENT_QUOTES),
                    htmlentities($vendido["nombre_cliente"], ENT_QUOTES),
                    null,
                    true,
                    false
                )
            ) {

                echo "email enviado a " . htmlentities($vendido["email"], ENT_QUOTES) . "</br>";
            } else {
                $enviado = false;
                echo "error al enviar el email.</br>";
            }
        }
        if ($metodoEnvioITV == "sms") {
            $messages = array(
                array('to' => $vendido["telefono"], 'body' => $texto)
            );
            $result = send_message(json_encode($messages), 'https://api.bulksms.com/v1/messages?auto-unicode=true&longMessageMaxParts=30', $username, $password);
            if ($result['http_status'] != 201) {
                print "Error sending: " . ($result['error'] ? $result['error'] : "HTTP status " . $result['http_status'] . "; Response was " . $result['server_response']);
                $enviado = false;
            } else {

                // Use json_decode($result['server_response']) to work with the response further
                $response = json_decode($result['server_response'], true);
                echo "</br>";
                if ($response[0]["type"] != "SENT") {
                    echo "Mensaje no se pudo enviar</br>";
                    $enviado = false;
                } else {
                    echo "Mensaje enviado</br>";
                }
            }
        }
        if ($metodoEnvioITV == "emailsinosms") {
        }
        if ($enviado) {
            $tipo = $metodoEnvioITV;
            $id_vehiculo = $vendido["id_vehiculo"];
            $fecha = $fechadehoy;
            $numero_email = $vendido["email"];
            $sql = "INSERT INTO envios_itv(motivo,tipo, id_vehiculo, fecha, numero_email) 
        VALUES (:motivo,:tipo,:id_vehiculo,:fecha,:numero_email)";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':tipo', $tipo);
            $statement->bindValue(':id_vehiculo', $id_vehiculo);
            $statement->bindValue(':fecha', $fecha);
            $statement->bindValue(':numero_email', $numero_email);
            $statement->bindValue(':motivo', "ITV");
            $statement->execute();
        }
    } else {
        echo "La fecha de hoy NO tiene la misma cantidad (" . $diferenciaDias . ") de días de diferencia con la fecha de vencimiento (" . $vendido["proxima_itv"] . ") del vehiculo que los días especificados (" . $diasEnvioITV . ").</br>";
    }
}














echo "Vencimientos financiacion</br>";
$ventas = getVentas($dbConn);
$diasEnvioFinanciacion = $personalizacion["dias_envio_financiacion"];
$metodoEnvioFinanciacion = $personalizacion["metodo_envio_financiacion"];
if ($metodoEnvioFinanciacion == "email") {
    $texto = html_entity_decode($personalizacion["cuerpo_email_financiacion"]);
}
if ($metodoEnvioFinanciacion == "sms") {
    $texto = html_entity_decode($personalizacion["cuerpo_sms_financiacion"]);
}
if ($metodoEnvioFinanciacion == "emailsinosms") {
    $texto = html_entity_decode($personalizacion["cuerpo_email_financiacion"]);
}
foreach ($ventas as $venta) {

    if ($venta["envio_vencimiento"] != "1") {
        echo "El cliente esta deshabilitado para los envios.</br>";
        continue;
    }
    $fechaVencimiento = new DateTime($venta["fecha_vencimiento"]);
    $hoy = new DateTime();

    if ($fechaVencimiento < $hoy) {
        echo "La fecha de vencimiento ha pasado.</br>";
        continue;
    } else {
        echo "La fecha de vencimiento aún no ha pasado.</br>";
    }
    $diferenciaDias = $hoy->diff($fechaVencimiento)->days;

    if ($diferenciaDias == $diasEnvioFinanciacion) {
        echo "La fecha de hoy tiene la misma cantidad (" . $diferenciaDias . ") de días de diferencia con la fecha de vencimiento (" . $venta["fecha_vencimiento"] . ") del vehiculo que los días especificados (" . $diasEnvioFinanciacion . ").</br>";


        $nombre = explode(' ', $venta["nombre_cliente"])[0];
        $nombreyapellido = $venta["nombre_cliente"];
        $fechadehoy = date('d/m/Y');
        $marca = $venta["nombre_marca"];
        $modelo = $venta["nombre_modelo"];
        $fechadevencimiento = $venta["fecha_vencimiento"];
        $matricula = $venta["numero_matricula"];
        $texto = str_replace('%nombreyapellido%', $nombreyapellido, $texto);
        $texto = str_replace('%fechadehoy%', $currentDateTimeFormatted, $texto);
        $texto = str_replace('%marca%', $marca, $texto);
        $texto = str_replace('%modelo%', $modelo, $texto);
        $texto = str_replace('%fechadevencimiento%', $fechadevencimiento, $texto);
        $enviado = true;
        if ($metodoEnvioFinanciacion == "email") {
            if (
                $mailer->_Mail(
                    EMAIL_VALIDATE_USERNAME,
                    htmlentities($venta["email"], ENT_QUOTES),
                    html_entity_decode($personalizacion["asunto_email_financiacion"]),
                    $texto,
                    htmlentities($personalizacion["nombre"], ENT_QUOTES),
                    htmlentities($venta["nombre_cliente"], ENT_QUOTES),
                    null,
                    true,
                    false
                )
            ) {
                echo "email enviado a " . htmlentities($venta["email"], ENT_QUOTES) . "</br>";
            } else {
                echo "error al enviar el email.</br>";
                echo "Mensaje no se pudo enviar</br>";
                $enviado = false;
            }
        }
        if ($metodoEnvioFinanciacion == "sms") {
            $messages = array(
                array('to' => $venta["telefono_cliente"], 'body' => $texto)
            );
            $result = send_message(json_encode($messages), 'https://api.bulksms.com/v1/messages?auto-unicode=true&longMessageMaxParts=30', $username, $password);
            if ($result['http_status'] != 201) {
                print "Error sending: " . ($result['error'] ? $result['error'] : "HTTP status " . $result['http_status'] . "; Response was " . $result['server_response']);
                $enviado = false;
            } else {

                // Use json_decode($result['server_response']) to work with the response further
                $response = json_decode($result['server_response'], true);
                echo "</br>";
                if ($response[0]["type"] != "SENT") {
                    echo "Mensaje no se pudo enviar</br>";
                    $enviado = false;
                } else {
                    echo "Mensaje enviado</br>";
                }
            }
        }
        if ($metodoEnvioFinanciacion == "emailsinosms") {
        }
        if ($enviado) {
            $tipo = $metodoEnvioFinanciacion;
            $id_vehiculo = $venta["id_vehiculo"];
            $fecha = $fechadehoy;
            $numero_email = $venta["email"];
            $sql = "INSERT INTO envios_itv(motivo,tipo, id_vehiculo, fecha, numero_email) 
        VALUES (:motivo,:tipo,:id_vehiculo,:fecha,:numero_email)";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':tipo', $tipo);
            $statement->bindValue(':id_vehiculo', $id_vehiculo);
            $statement->bindValue(':fecha', $currentDateTimeFormatted);
            $statement->bindValue(':numero_email', $numero_email);
            $statement->bindValue(':motivo', "Financiacion");
            $statement->execute();
        }
    } else {
        echo "La fecha de hoy NO tiene la misma cantidad (" . $diferenciaDias . ") de días de diferencia con la fecha de vencimiento (" . $venta["fecha_vencimiento"] . ") del vehiculo que los días especificados (" . $diasEnvioFinanciacion . ").</br>";
    }
}
// Verificar si la fecha y hora actual coincide exactamente con la fecha y hora objetivo

//$mailer->_Mail(EMAIL_VALIDATE_USERNAME, "fede.gundel@gmail.com", "Envío programado2", $personalizacion['cuerpo_email_presupuesto'], APP_NAME);
function getVendidos($dbConn)
{
    $sql = $dbConn->prepare("SELECT
    e.*,
    v.fecha,
    COALESCE(c.nombre, 'Ninguno') AS nombre_modelo,
    COALESCE(b.nombre, 'Ninguna') AS nombre_marca,
    COALESCE(a.nombre, 'Ninguno') AS nombre_combustible,
    COALESCE(cl.nombre, 'Ninguno') AS nombre_cliente,
    cl.telefono,
    cl.email
FROM
    vehiculos e
JOIN(
    SELECT DISTINCT
        id_vehiculo,
        client_id,
        fecha
    FROM
        ventas
) v
ON
    e.id_vehiculo = v.id_vehiculo
JOIN clientes cl ON
    v.client_id = cl.client_id
LEFT JOIN modelos c ON
    e.id_modelo = c.id_modelo
LEFT JOIN marcas b ON
    e.id_marca = b.id_marca
LEFT JOIN combustibles a ON
    e.id_combustible = a.id_combustible;

");


    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);


    return $sql->fetchAll();
}
function getVentas($dbConn)
{
    $sql = $dbConn->prepare("SELECT e.*, 
       COALESCE(m.nombre, 'Ninguno') AS nombre_modelo, 
       COALESCE(ma.nombre, 'Ninguna') AS nombre_marca, 
       COALESCE(f.nombre, 'Ninguna') AS nombre_financiera, 
       COALESCE(r.nombre, 'Ninguna') AS nombre_metodo, 
       COALESCE(a.nombre, 'Ninguno') AS nombre_cliente,
       COALESCE(a.telefono, 'Ninguno') AS telefono_cliente,
       COALESCE(v.fecha_matriculacion, 'Ninguna') AS fecha_matriculacion,
       COALESCE(v.matricula, 'Ninguna') AS numero_matricula,
       v.envio_vencimiento,
       v.id_vehiculo,
       a.email,
       CASE 
           WHEN e.id_financiera IS NULL THEN NULL
           WHEN DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) < NOW() THEN TRUE
           ELSE FALSE
       END AS financiacion_vencida,
       DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) AS fecha_vencimiento,
    a.email
FROM ventas e
LEFT JOIN vehiculos v ON e.id_vehiculo = v.id_vehiculo
LEFT JOIN modelos m ON v.id_modelo = m.id_modelo
LEFT JOIN marcas ma ON v.id_marca = ma.id_marca
LEFT JOIN clientes a ON e.client_id = a.client_id
LEFT JOIN metodos_pago r ON e.id_metodo = r.id_metodo
LEFT JOIN financieras f ON e.id_financiera = f.id_financiera;

");


    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);


    return $sql->fetchAll();
}













function send_message($post_body, $url, $username, $password)
{
    $ch = curl_init();
    $headers = array(
        'Content-Type:application/json',
        'Authorization:Basic ' . base64_encode("$username:$password")
    );
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_body);
    // Allow cUrl functions 20 seconds to execute
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    // Wait 10 seconds while trying to connect
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    $output = array();
    $output['server_response'] = curl_exec($ch);
    $curl_info = curl_getinfo($ch);
    $output['http_status'] = $curl_info['http_code'];
    $output['error'] = curl_error($ch);
    curl_close($ch);
    return $output;
}

//

if ($_SESSION['avatar'] == "1") {
    $Usuario->_Logout();
}