<?php


require __ROOT__ . '/vendor/autoload.php';
require_once __ROOT__ . '/core/configuration.php';
require_once __ROOT__ . '/models/mailer.model.php';
require_once __ROOT__ . '/models/users.model.php';
require_once __ROOT__ . '/models/clientes.model.php';
require_once __ROOT__ . '/models/presupuestos.model.php';
require_once __ROOT__ . '/models/facturas.model.php';
require_once __ROOT__ . '/libraries/dompdf/autoload.inc.php';
require_once __ROOT__ . "/api/utils.php";
use Dompdf\Dompdf;
use Dompdf\Options;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;



$dbConn = connect($db);
date_default_timezone_set('America/Argentina/Buenos_Aires');

$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);
date_default_timezone_set(htmlentities($personalizacion["zona_horaria"], ENT_QUOTES));


$facturas = new _FacturasModel($DBLink);
$presupuestos = new _PresupuestosModel($DBLink);
$clientes = new _ClientesModel($DBLink);
$Usuario = new _UsersModel($DBLink);
$todasLasFacturas = $facturas->GetListFacturas();
$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
//$mailer->_Mail("panelpruebas@academiadeltoro.com", "fede.gundel@gmail.com", "Prueba", "Probando Mailer");
// Fecha y hora objetivo


// Fecha y hora actual sin segundos
$currentDateTime = new DateTime();
$currentDateTimeFormatted = $currentDateTime->format('Y-m-d H:i');
echo "fecha hoy: " . $currentDateTimeFormatted . "</br>";
foreach ($todasLasFacturas as $factura)
    {
    $fechaVencimiento = new DateTime($factura["fecha_vencimiento"]);
    $fechaVencimiento = $fechaVencimiento->sub(new DateInterval('P' . strval($factura['dias_vencimiento']) . 'D'));
    $fechaVencimientoFormatted = $fechaVencimiento->format('Y-m-d H:i');
    echo "fecha de vencimiento: " . $fechaVencimientoFormatted . "</br>";

    if ($factura["estado"] != "Pagada" && $currentDateTimeFormatted == $fechaVencimientoFormatted)
        {

        $emails = json_decode($factura['emails_vencimiento']);
        echo "Estás en la fecha y hora exacta.</br>";

        foreach ($emails as $email)
            {



            if ($mailer->_Mail(EMAIL_VALIDATE_USERNAME, htmlentities($email, ENT_QUOTES), "Alerta de vencimiento.", "Le enviamos en aviso de proximidad de vencimiento de factura, correspondiente a la factura número " . $factura["numero"] . ", con vencimiento " . $factura["fecha_vencimiento"] . "."))
                {
                echo "email enviado a " . htmlentities($email, ENT_QUOTES) . "</br>";

                } else
                {
                echo "error al enviar el email.</br>";

                }



            }
        } else
        {
        echo "No estas en la fecha.</br>";



        }
    }


// Verificar si la fecha y hora actual coincide exactamente con la fecha y hora objetivo

//$mailer->_Mail(EMAIL_VALIDATE_USERNAME, "fede.gundel@gmail.com", "Envío programado2", $personalizacion['cuerpo_email_presupuesto'], APP_NAME);



//

if ($_SESSION['avatar'] == "1")
    {
    $Usuario->_Logout();
    }
function GetFacturasXSLX($dbConn)
    {

    $sql = "SELECT f.*, c.nombre AS nombre_cliente , c.cif AS cif_cliente , p.igic AS igic, p.irpf AS irpf
        FROM facturas f
        JOIN presupuestos p ON f.id_presupuesto = p.id_presupuesto
        JOIN clientes c ON p.id_cliente = c.client_id";
    $statement = $dbConn->prepare($sql);
    $statement->execute();
    $facturas = $statement->fetchAll(PDO::FETCH_OBJ);

    $claves = array_keys(get_object_vars($facturas[0]));

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $tabla = "nombre_de_la_tabla";
    $columnas = $claves;
    $filaActual = 1;
    $columnaActual = 'A';
    foreach ($columnas as $columna)
        {
        if (($columna != "id_presupuesto") && ($columna != "fecha_vencimiento") && ($columna != "fecha_envio") && ($columna != "pagos") && ($columna != "importe_restante") && ($columna != "metodo_pago"))
            {
            if ($columna == "nombre_cliente")
                {
                $columna = "Cliente";
                }
            if ($columna == "id_factura")
                {
                $columna = "ID";
                }
            if ($columna == "numero")
                {
                $columna = "Número";
                }
            if ($columna == "estado")
                {
                $columna = "Estado";
                }
            if ($columna == "fecha")
                {
                $columna = "Fecha";
                }
            if ($columna == "email")
                {
                $columna = "Email";
                }
            if ($columna == "domicilio")
                {
                $columna = "Domicilio";
                }
            if ($columna == "importe")
                {
                $columna = "Importe";
                }
            if ($columna == "importe_s")
                {
                $columna = "Importe final";
                }
            if ($columna == "cif_cliente")
                {
                $columna = "CIF";
                }
            if ($columna == "igic")
                {
                $columna = "IGIC";
                }
            if ($columna == "irpf")
                {
                $columna = "IRPF";
                }
            $sheet->setCellValue($columnaActual . $filaActual, $columna);
            $columnaActual++;
            }

        }
    $filaActual++;
    foreach ($facturas as $fila)
        {
        $columnaActual = 'A';
        foreach ($fila as $clave => $valor)
            {
            if (($clave != "id_presupuesto") && ($clave != "fecha_vencimiento") && ($clave != "fecha_envio") && ($clave != "pagos") && ($clave != "importe_restante") && ($clave != "metodo_pago"))
                {
                if ($clave == "igic")
                    {
                    $valor = $valor . "%";
                    }
                if ($clave == "irpf")
                    {
                    $valor = ($valor != null) ? $valor . "%" : "0.00%";
                    }
                if ($clave == "importe")
                    {
                    $valor = $valor . "€";
                    }
                if ($clave == "importe_s")
                    {
                    $valor = $valor . "€";
                    }
                $sheet->setCellValue($columnaActual . $filaActual, $valor);
                $columnaActual++;
                }
            }
        $filaActual++;
        }
    // Configurar el encabezado del archivo XLSX

    // Guardar el archivo XLSX en la salida (output)
    $writer = IOFactory::createWriter($spreadsheet, 'Xls');

    $rutaCarpetaGuardar = __ROOT__ . '/copias/';
    $nombreArchivoXLSX = 'copia.xlsx';
    if (file_exists($rutaCarpetaGuardar . $nombreArchivoXLSX))
        {
        unlink($rutaCarpetaGuardar . $nombreArchivoXLSX);
        }
    $writer->save($rutaCarpetaGuardar . $nombreArchivoXLSX);
    $contenidoXLSX = file_get_contents($rutaCarpetaGuardar . $nombreArchivoXLSX);

    return $contenidoXLSX;
    }