<?php


require __ROOT__ . '/vendor/autoload.php';
require_once __ROOT__ . '/core/configuration.php';
require_once __ROOT__ . '/models/mailer.model.php';
require_once __ROOT__ . '/models/users.model.php';
require_once __ROOT__ . "/api/utils.php";

$dbConn = connect($db);
//date_default_timezone_set('America/Argentina/Buenos_Aires');

$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);
date_default_timezone_set(htmlentities($personalizacion["zona_horaria"], ENT_QUOTES));
$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
$Usuario = new _UsersModel($DBLink);
$currentDateTime = new DateTime();
$currentDateTimeFormatted = $currentDateTime->format('Y-m-d H:i');
echo "fecha hoy: " . $currentDateTime->format('d/m/Y H:i') . "</br>";


$hora_cumple = htmlentities($personalizacion["hora_oferta_cumpleanos"], ENT_QUOTES);
echo "hora cumple: " . $hora_cumple . "</br>";
$cumpleaneros = GetClientesCumpleaneros($dbConn);

$username = htmlentities($personalizacion["username_bulk"], ENT_QUOTES);
$password = htmlentities($personalizacion["password_bulk"], ENT_QUOTES);
$metodoEnvioCumple = htmlentities($personalizacion["metodo_oferta_cumpleanos"], ENT_QUOTES);

$recordatorios_camiones = GetRecordatoriosCamionesHoy($dbConn);
//$mensaje_decodificado = json_decode('"' . $mensaje_cumple . '"');
$camiones = GetCamionesItvEnXDias($dbConn, $personalizacion["username_bulk"]);
$usuarios = GetUsuariosNotificados($dbConn);
echo "Camiones: </br>";
foreach ($camiones as $camion) {
    echo "Camión: {$camion['matricula']} - ITV: {$camion['itv']}<br>";

    // Verifica si la hora actual coincide con la hora de envío configurada
    if (date('H:i') === $personalizacion["hora_envio_itv_camiones"]) {
        // Ejecutar el código deseado (por ejemplo, enviar notificación)
        $texto = html_entity_decode($personalizacion["cuerpo_email_itv_camiones"]);
        $matricula = $camion["matricula"];
        $texto = str_replace('%matricula%', $matricula, $texto);
        $texto = str_replace('%fecha_vencimiento%', $camion['itv'], $texto);
        $texto = str_replace('%fechadehoy%', date("d/m/Y"), $texto);
        foreach ($usuarios as $u) {
             if (
                $mailer->_Mail(
                    EMAIL_VALIDATE_USERNAME,
                    htmlentities($u["user_email"], ENT_QUOTES),
                    html_entity_decode($personalizacion["asunto_email_itv_camiones"]),
                    $texto,
                    htmlentities($personalizacion["nombre"], ENT_QUOTES),
                    htmlentities($u["user_full_name"], ENT_QUOTES),
                    null,
                    true,
                    false
                )
            ) {

                echo "email enviado a " . htmlentities($u["user_email"], ENT_QUOTES) . "</br>";
            } else {
                $enviado = false;
                echo "error al enviar el email.</br>";
            }
        }

        // Aquí va tu código...
    }
}





echo "Recordatorios: </br>";
foreach ($recordatorios_camiones as $r) {
    echo "Recordatorio: {$r['id_recordatorio']}<br>";
 echo date('H:i', strtotime($r["hora"]));
    // Verifica si la hora actual coincide con la hora de envío configurada
   if (date('H:i') === date('H:i', strtotime($r["hora"]))) {

        // Ejecutar el código deseado (por ejemplo, enviar notificación)
        $texto = html_entity_decode($r["cuerpo"]);
        $matricula = $r["matricula"];
         $asunto = $r["asunto"];
        $texto = str_replace('%matricula%', $matricula, $texto);
      
        $texto = str_replace('%fechadehoy%', date("d/m/Y"), $texto);
        foreach ($usuarios as $u) {
             if (
                $mailer->_Mail(
                    EMAIL_VALIDATE_USERNAME,
                    htmlentities($u["user_email"], ENT_QUOTES),
                    htmlentities($asunto, ENT_QUOTES),
                    $texto,
                    htmlentities($personalizacion["nombre"], ENT_QUOTES),
                    htmlentities($u["user_full_name"], ENT_QUOTES),
                    null,
                    true,
                    false
                )
            ) {

                echo "email enviado a " . htmlentities($u["user_email"], ENT_QUOTES) . "</br>";
            } else {
                $enviado = false;
                echo "error al enviar el email.</br>";
            }
        }

        // Aquí va tu código...
    }
}


$citas = GetCitasHoyConTiempo($dbConn);

echo "Citas: </br>";
foreach ($citas as $cita) {
    echo "{$cita['fecha_aviso']}<br>";
    $ahora = date('Y-m-d H:i'); // Fecha actual sin segundos
    $fechaAviso = $cita['fecha_aviso'];
    $texto3 = html_entity_decode($personalizacion["mensaje_cita_sms"]);

    $nombre = explode(' ', $cita["nombre"])[0];
    $nombreyapellido = $cita["nombre"];
    $fechaHoy = (new DateTime())->format('d/m/Y');
    $fechaInicio = new DateTime($cita['fecha_i']);
    $fechaFin = new DateTime($cita['fecha_f']);
    $horaInicio = $fechaInicio->format('H:i');
    $horaFin = $fechaFin->format('H:i');
    $fechaInicioFormato = $fechaInicio->format('d/m/Y');
    $fechaFinFormato = $fechaFin->format('d/m/Y');

    // Reemplazos
    $texto3 = str_replace('%nombre%', $nombre, $texto3);
    $texto3 = str_replace('%nombreyapellido%', $nombreyapellido, $texto3);
    $texto3 = str_replace('%fechadehoy%', $fechaHoy, $texto3);
    $texto3 = str_replace('%fechainicio%', $fechaInicioFormato, $texto3);
    $texto3 = str_replace('%fechafin%', $fechaFinFormato, $texto3);
    $texto3 = str_replace('%horainicio%', $horaInicio, $texto3);
    $texto3 = str_replace('%horafin%', $horaFin, $texto3);
    if ($ahora === $fechaAviso) {
        echo "En hora de aviso: Cita para cliente con móvil {$cita['movil']}<br>";
        $messages = array(
            array('deliveryReports' => "ERRORS", 'to' => $cita["movil"], 'body' => $texto3)
        );

        $result = send_message(json_encode($messages), 'https://api.bulksms.com/v1/messages?auto-unicode=true&longMessageMaxParts=30', $username, $password);
        if ($result['http_status'] != 201) {
            print "Error sending: " . ($result['error'] ? $result['error'] : "HTTP status " . $result['http_status'] . "; Response was " . $result['server_response']);
            $estado = "Error al enviar";
        } else {

            // Use json_decode($result['server_response']) to work with the response further
            $response = json_decode($result['server_response'], true);
            echo "</br>";

            if ($response[0]["type"] != "SENT") {
                echo "Mensaje no se pudo enviar</br>";
                $estado = "Error al enviar";
            } else {
                $estado = "Enviado";
            }
        }
        if ($cita["movil"] == null) {
            $estado = "Número de móvil faltante";
        }
    }
}

echo "</br>";
echo "</br>";

foreach ($cumpleaneros as $cumpleanero) {
    // Obtener la hora y minuto actuales
    if ($cumpleanero["terminos"] != 1 ||  $cumpleanero["sms_habilitado"] != 1) {

        continue;
    }


    $horaActual = $currentDateTime->format('H:i');
    echo "Cumpleaños:  ";

    if ($metodoEnvioCumple == "email") {
        $texto = html_entity_decode($personalizacion["mensaje_oferta_cumpleanos"]);
    }
    if ($metodoEnvioCumple == "sms") {
        $texto = html_entity_decode($personalizacion["mensaje_oferta_cumpleanos_sms"]);
    }
    if ($metodoEnvioCumple == "emailsinosms") {
        $texto = html_entity_decode($personalizacion["mensaje_oferta_cumpleanos"]);
    }

    if ($horaActual === $hora_cumple) {


        $nombre = explode(' ', $cumpleanero["nombre"])[0];
        $nombreyapellido = $cumpleanero["nombre"];
        $fechadehoy = date('d-m-Y');

        $texto = str_replace('%nombre%', $nombre, $texto);

        $texto = str_replace('%nombreyapellido%', $nombreyapellido, $texto);
        $texto = str_replace('%fechadehoy%', date("d/m/Y"), $texto);
        $texto = str_replace('%url%', WEBSITE_URL, $texto);
        $texto = str_replace('%client_id%', $cumpleanero['client_id'], $texto);





        if ($metodoEnvioCumple == "email") {

            if (
                $mailer->_Mail(
                    EMAIL_VALIDATE_USERNAME,
                    htmlentities($cumpleanero["email"], ENT_QUOTES),
                    html_entity_decode($personalizacion["asunto_email_cumpleanos"]),
                    $texto,
                    htmlentities($personalizacion["nombre"], ENT_QUOTES),
                    htmlentities($cumpleanero["nombre"], ENT_QUOTES),
                    null,
                    true,
                    false
                )
            ) {
                if ($cumpleanero["email"] == null) {
                    $estado = "Correo electrónico faltante";
                } else {
                    $estado = "Enviado";
                }

                echo "email enviado a " . htmlentities($cumpleanero["email"], ENT_QUOTES) . "</br>";
            } else {
                $estado = "Error al enviar";
                echo "error al enviar el email.</br>";
            }
        }
        if ($metodoEnvioCumple == "sms") {
            $messages = array(
                array('deliveryReports' => "ERRORS", 'to' => $cumpleanero["movil"], 'body' => $texto)
            );

            $result = send_message(json_encode($messages), 'https://api.bulksms.com/v1/messages?auto-unicode=true&longMessageMaxParts=30', $username, $password);
            if ($result['http_status'] != 201) {
                print "Error sending: " . ($result['error'] ? $result['error'] : "HTTP status " . $result['http_status'] . "; Response was " . $result['server_response']);
                $estado = "Error al enviar";
            } else {

                // Use json_decode($result['server_response']) to work with the response further
                $response = json_decode($result['server_response'], true);
                echo "</br>";

                if ($response[0]["type"] != "SENT") {
                    echo "Mensaje no se pudo enviar</br>";
                    $estado = "Error al enviar";
                } else {
                    $estado = "Enviado";
                }
            }
            if ($cumpleanero["movil"] == null) {
                $estado = "Número de móvil faltante";
            }
        }
        if ($metodoEnvioCumple == "emailsinosms") {
        }

        $tipo = $metodoEnvioCumple;
        $client_id = $cumpleanero["client_id"];


        $sql = "INSERT INTO envios_cumple(tipo, client_id, fecha, estado) 
        VALUES (:tipo,:client_id,:fecha,:estado)";
        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':tipo', $tipo);
        $statement->bindValue(':client_id', $client_id);
        $statement->bindValue(':fecha', date('Y-m-d H:i:s'));
        $statement->bindValue(':estado', $estado);

        $statement->execute();


        echo "¡Es la hora exacta para enviar la oferta de cumpleaños a {$cumpleanero['nombre']}!</br>";

        // Aquí puedes agregar la lógica para enviar la oferta
    }
}



$sms = GetSMS($dbConn);


foreach ($sms as $mensaje) {
    // Convertir la fecha_programado a formato Y-m-d H:i (eliminando segundos)
    $fechaProgramada = DateTime::createFromFormat('Y-m-d H:i:s', $mensaje['fecha_programado']);

    if ($fechaProgramada) {
        $fechaProgramadaFormatted = $fechaProgramada->format('Y-m-d H:i');


        echo "fecha programada: " . $fechaProgramadaFormatted . "</br>";
        // Comparar solo hasta minutos
        if ($fechaProgramadaFormatted === $currentDateTimeFormatted) {


            $cliente = GetCliente($dbConn, $mensaje['client_id']);

            $nombre = explode(' ', $cliente["nombre"])[0];
            $nombreyapellido = $cliente["nombre"];
            $fechadehoy = date('d-m-Y');

            $mensaje = str_replace('%nombre%', $nombre, $mensaje);

            $mensaje = str_replace('%nombreyapellido%', $nombreyapellido, $mensaje);
            $mensaje = str_replace('%fechadehoy%', date("d/m/Y"), $mensaje);











            $nuevoEstado;
            if (empty($mensaje['movil'])) {
                $nuevoEstado = "Número de móvil faltante";
            } else {
                $messages = array(
                    array('deliveryReports' => "ERRORS", 'to' => $mensaje["movil"], 'body' => $mensaje["cuerpo"])
                );

                $result = send_message(json_encode($messages), 'https://api.bulksms.com/v1/messages?auto-unicode=true&longMessageMaxParts=30', $username, $password);
                if ($result['http_status'] != 201) {
                    print "Error sending: " . ($result['error'] ? $result['error'] : "HTTP status " . $result['http_status'] . "; Response was " . $result['server_response']);
                    $nuevoEstado = "Error al enviar";
                } else {

                    // Use json_decode($result['server_response']) to work with the response further
                    $response = json_decode($result['server_response'], true);
                    echo "</br>";

                    if ($response[0]["type"] != "SENT") {
                        echo "Mensaje no se pudo enviar</br>";
                        $nuevoEstado = "Error al enviar";
                    } else {
                        $nuevoEstado = "Enviado";
                    }
                }
                if ($mensaje["movil"] == null) {
                    $nuevoEstado = "Número de móvil faltante";
                }
            }

            ActualizarEstadoSMS($dbConn, $mensaje["id_sms"], $nuevoEstado);
        }
    }
}

if ($_SESSION['avatar'] == "1") {
    $Usuario->_Logout();
}
function GetSMS($dbConn)
{
    $sql = $dbConn->prepare("SELECT 
    sms.*, 
    clientes.nombre, 
    clientes.movil 
FROM sms  
JOIN clientes ON sms.client_id = clientes.client_id;
");
    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    return $sql->fetchAll();
}
function GetClientesCumpleaneros($dbConn)
{
    $sql = $dbConn->prepare("SELECT 
        * 
    FROM clientes
    WHERE DATE_FORMAT(fecha_nacimiento, '%m-%d') = DATE_FORMAT(CURDATE(), '%m-%d')");

    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    return $sql->fetchAll();
}
function GetCliente($dbConn, $client_id)
{
    // Preparar la consulta para obtener el id_vehiculo
    $sql = $dbConn->prepare("
        SELECT *
        FROM clientes
        WHERE client_id = :client_id
        LIMIT 1
    ");

    // Vincular el parámetro :client_id con el valor proporcionado
    $sql->bindParam(':client_id', $client_id, PDO::PARAM_INT);

    // Ejecutar la consulta
    $sql->execute();

    // Establecer el modo de recuperación a array asociativo
    $sql->setFetchMode(PDO::FETCH_ASSOC);

    // Obtener el primer resultado (si existe)
    $cliente = $sql->fetch();
    return $cliente;
}

function ActualizarEstadoSMS($dbConn, $smsId, $estado)
{
    if ($estado === "Enviado") {
        $sql = $dbConn->prepare("UPDATE sms SET estado = :estado, fecha_envio = NOW() WHERE id_sms = :smsId");
    } else {
        $sql = $dbConn->prepare("UPDATE sms SET estado = :estado WHERE id_sms = :smsId");
    }

    $sql->bindParam(':estado', $estado);
    $sql->bindParam(':smsId', $smsId);
    $sql->execute();
}

function send_message($post_body, $url, $username, $password)
{
    $ch = curl_init();
    $headers = array(
        'Content-Type:application/json',
        'Authorization:Basic ' . base64_encode("$username:$password")
    );
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_body);
    // Allow cUrl functions 20 seconds to execute
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    // Wait 10 seconds while trying to connect
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    $output = array();
    $output['server_response'] = curl_exec($ch);
    $curl_info = curl_getinfo($ch);
    $output['http_status'] = $curl_info['http_code'];
    $output['error'] = curl_error($ch);
    echo var_dump($output);
    curl_close($ch);
    return $output;
}


function GetCitasHoyConTiempo($dbConn)
{
    $sql = $dbConn->prepare("
        SELECT 
            citas.*, 
            clientes.movil,
             clientes.nombre,
            DATE_FORMAT(DATE_SUB(citas.fecha_i, INTERVAL citas.tiempo HOUR), '%Y-%m-%d %H:%i') AS fecha_aviso
        FROM citas
        INNER JOIN clientes ON clientes.client_id = citas.client_id
        WHERE citas.tiempo IS NOT NULL
          AND DATE(citas.fecha_i) = CURDATE()
    ");

    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    return $sql->fetchAll();
}

function GetCamionesItvEnXDias($dbConn, $dias)
{
    $sql = $dbConn->prepare("
        SELECT *
        FROM camiones
        WHERE itv IS NOT NULL
          AND itv BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL :dias DAY)
    ");

    $sql->bindParam(':dias', $dias, PDO::PARAM_INT);
    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);

    return $sql->fetchAll();
}

function GetRecordatoriosCamionesHoy($dbConn)
{
    $sql = $dbConn->prepare("
        SELECT 
            recordatorios_camiones.*, 
            camiones.matricula
        FROM recordatorios_camiones
        INNER JOIN camiones ON camiones.id_camion = recordatorios_camiones.id_camion
        WHERE DATE(recordatorios_camiones.fecha) = CURDATE()
    ");

    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    
    return $sql->fetchAll();
}


function GetUsuariosNotificados($dbConn)
{
    $sql = $dbConn->prepare("
        SELECT *
        FROM users
        WHERE notificado = 1
    ");

    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);

    return $sql->fetchAll();
}