<?php

define('__ROOT__', dirname(__DIR__));
session_start();
require_once dirname(__DIR__) . '/vendor/autoload.php';
require_once __ROOT__ . '/core/configuration.php';
require_once __ROOT__ . '/controllers/mailer.controller.php';
require_once dirname(__DIR__) . ("/api/utils.php");
$personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);
$dbConn = connect($db);

$presupuestos_programados = getPresupuestos($dbConn);
$facturas_programadas = getFacturas($dbConn);
$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
$_SESSION['logged'] = true;
$mailer_controller = new _mailer($DBLink);
$presupuestos = new _PresupuestosModel($DBLink);
$facturas = new _FacturaManualModel($DBLink);

foreach ($presupuestos_programados as $key => $value) {
    $fileatt = $mailer_controller->ArmarPDFPresupuesto($value["id_presupuesto"]);
    echo $mailer->_Mail(EMAIL_VALIDATE_USERNAME, $value["email"], "Envío programado", $personalizacion['cuerpo_email_presupuesto'], APP_NAME, "Cliente", $fileatt, true, true);
    $presupuestos->ReenviarPresupuesto($value["id_presupuesto"]);
}


foreach ($facturas_programadas as $key => $value) {
    $fileatt = $mailer_controller->ArmarPDFFacturaManual($value["id_factura_manual"]);
    echo $mailer->_Mail(EMAIL_VALIDATE_USERNAME, $value["email"], "Envío programado", $personalizacion['cuerpo_email_factura'], APP_NAME, "Cliente", $fileatt, true, true);
    $facturas->EnviarFacturaManual($value["id_factura_manual"]);
}

function getPresupuestos($dbConn)
{
    $sql = $dbConn->prepare("SELECT *
    FROM presupuestos
    WHERE programado IS NOT NULL
    AND estado='No enviado'
    AND DATE(programado) = CURDATE();
    ");

    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    return $sql->fetchAll();
}

function getFacturas($dbConn)
{
    $sql = $dbConn->prepare("SELECT *
    FROM factura_manual
    WHERE programado IS NOT NULL
    AND estado='No enviada'
    AND DATE(programado) = CURDATE();
    ");


    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    return $sql->fetchAll();
}
