<?php


if (!defined('__ROOT__')) {
    define('__ROOT__', dirname(__DIR__));
}

session_start();
$_SESSION['logged'] = true;


require __ROOT__ . '/vendor/autoload.php';

require_once __ROOT__ . '/core/configuration.php';

require_once __ROOT__ . '/models/mailer.model.php';

require_once __ROOT__ . '/controllers/mailer.controller.php';

require_once __ROOT__ . '/models/users.model.php';

require_once __ROOT__ . '/models/presupuestos.model.php';

require_once __ROOT__ . '/models/facturamanual.model.php';

include __ROOT__ . ("/api/utils.php");



$dbConn = connect($db);

$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);

$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

$mailer_controller = new _mailer($DBLink);

$Usuario = new _UsersModel($DBLink);

$presupuestos = new _PresupuestosModel($DBLink);

$facturas = new _FacturaManualModel($DBLink);

$currentDateTime = new DateTime();

$currentDateTimeFormatted = $currentDateTime->format('Y-m-d');



$programados = getPresupuestos($dbConn);

$programadas = getFacturas($dbConn);

echo "</br>";



foreach ($programados as $presupuesto) {

    $fileatt = $mailer_controller->ArmarPDFPresupuesto($presupuesto["id_presupuesto"]);



    echo $mailer->_Mail(EMAIL_VALIDATE_USERNAME, $presupuesto["email"], "Envío programado", $personalizacion['cuerpo_email_presupuesto'], APP_NAME, "Cliente", $fileatt, true, true);

    $presupuestos->ReenviarPresupuesto($presupuesto["id_presupuesto"]);





}

foreach ($programadas as $factura) {

    $fileatt = $mailer_controller->ArmarPDFFacturaManual($factura["id_factura_manual"]);



    echo $mailer->_Mail(EMAIL_VALIDATE_USERNAME, $factura["email"], "Envío programado", $personalizacion['cuerpo_email_factura'], APP_NAME, "Cliente", $fileatt, true, true);

    $facturas->EnviarFacturaManual($factura["id_factura_manual"]);





}



function getPresupuestos($dbConn)

{

    $sql = $dbConn->prepare("SELECT *

FROM presupuestos

WHERE programado IS NOT NULL

  AND DATE(programado) = CURDATE();

");





    $sql->execute();

    $sql->setFetchMode(PDO::FETCH_ASSOC);





    return $sql->fetchAll();

}

function getFacturas($dbConn)

{

    $sql = $dbConn->prepare("SELECT *

FROM factura_manual

WHERE programado IS NOT NULL

  AND DATE(programado) = CURDATE();

");





    $sql->execute();

    $sql->setFetchMode(PDO::FETCH_ASSOC);





    return $sql->fetchAll();

}







//



if ($_SESSION['avatar'] == "1") {

    $Usuario->_Logout();

}