<?php

define('__ROOT__', dirname(__DIR__));
require __ROOT__ . '/vendor/autoload.php';
require_once __ROOT__ . '/core/configuration.php';
require_once __ROOT__ . '/models/mailer.model.php';
require_once __ROOT__ . '/models/users.model.php';
require_once __ROOT__ . '/models/clientes.model.php';
require_once __ROOT__ . '/models/presupuestos.model.php';
require_once __ROOT__ . '/libraries/dompdf/autoload.inc.php';
require_once __ROOT__ . "/api/utils.php";
use Dompdf\Dompdf;
use Dompdf\Options;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;


$dbConn = connect($db);


$personalizacion = json_decode(file_get_contents(__ROOT__ .'/personalizacion.json'), true);
date_default_timezone_set(htmlentities($personalizacion["zona_horaria"], ENT_QUOTES));


if (!$personalizacion["activo_copia"])
    {
    exit();
    }

$Usuario = new _UsersModel($DBLink);

$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
//$mailer->_Mail("panelpruebas@academiadeltoro.com", "fede.gundel@gmail.com", "Prueba", "Probando Mailer");
// Fecha y hora objetivo


// Fecha y hora actual sin segundos
$currentDateTime = new DateTime();
$currentDateTimeFormatted = $currentDateTime->format('Y-m-d H:i');


// Verificar si la fecha y hora actual coincide exactamente con la fecha y hora objetivo
$fechaEnvio = new DateTime($personalizacion["fecha_inicio_copia"]);
$fechaEnvio = $fechaEnvio->add(new DateInterval('P' . strval($personalizacion['dias_copia']) . 'D'));
$fechaEnvioFormatted = $fechaEnvio->format('Y-m-d H:i');
//$mailer->_Mail(EMAIL_VALIDATE_USERNAME, "fede.gundel@gmail.com", "Envío programado2", $personalizacion['cuerpo_email_presupuesto'], APP_NAME);
echo $currentDateTimeFormatted;
echo $fechaEnvioFormatted;
if (true)
    {



    echo "Estás en la fecha y hora exacta.</br>";
    echo "fecha de envio: " . $currentDateTimeFormatted . "</br>";
    $sql = "INSERT INTO copia_seguridad (fecha) VALUES (:fecha)";
    $statement = $dbConn->prepare($sql);
    $statement->bindValue(':fecha', $fechaEnvioFormatted);
    if ($statement->execute())
        {
        $postId = $dbConn->lastInsertId();
        $emails = $personalizacion['emails_copia'];
        foreach ($emails as $email)
            {
            $sql = "INSERT INTO user_copia (email,id_copia_seguridad) VALUES (:email,:id_copia_seguridad)";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':email', htmlentities($email, ENT_QUOTES));
            $statement->bindValue(':id_copia_seguridad', $postId);
            if ($statement->execute())
                {
                $fileatt = GetFacturasXSLX($dbConn);

                if ($mailer->_Mail(EMAIL_VALIDATE_USERNAME, htmlentities($email, ENT_QUOTES), "Envío de copia de seguridad", "Le enviamos la copia programada de seguridad correspondiente a las facturas.", APP_NAME, "Cliente", $fileatt, true, true, "Copia de seguridad facturas", ".xlsx"))
                    {
                    echo "email enviado a " . htmlentities($email, ENT_QUOTES) . "</br>";

                    } else
                    {
                    echo "error al enviar el email.</br>";

                    }

                } else
                {
                echo "error al crear el envio al usuario.</br>";
                }
                $personalizacion["fecha_inicio_copia"] = $currentDateTimeFormatted;
                $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);
                file_put_contents(__ROOT__ .'/personalizacion.json', $personalizacionEncoded);
            }
        } else
        {
        echo "No se pudo crear la copia.</br>";
        }
    } else
    {
    echo "No estas en la fecha.</br>";
    echo $currentDateTimeFormatted . "</br>";
    echo $fechaEnvioFormatted;

    }

//


    function GetFacturasXSLX($dbConn)
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $tabla = "facturas";
      
       
    
        $columnaActual = 'A';
    $filaActual = 1;
    // Agregar una fila extra para el título "Facturas manuales"
    $sheet->setCellValue('A' . $filaActual, 'Facturas');
    $sheet->mergeCells('A' . $filaActual . ':' . $columnaActual . $filaActual);
    
    $sql_factura_manual = "SELECT * FROM factura_manual";
    $statement_factura_manual = $dbConn->prepare($sql_factura_manual);
    $statement_factura_manual->execute();
    $facturas_manuales = $statement_factura_manual->fetchAll(PDO::FETCH_OBJ);
 
    $claves_manual = array_keys(get_object_vars($facturas_manuales[0]));
    $columnas_manual = $claves_manual;
    
    foreach ($columnas_manual as $columna)
    {
    if (($columna != "programado") && ($columna != "id_contable") && ($columna != "id_tramitadora") && ($columna !=
    "id_gestor") && ($columna != "client_id") && ($columna != "fecha_envio") && ($columna != "titulo") && ($columna !=
    "telefono") && ($columna != "cp") && ($columna != "tipo"))
    {
    if ($columna == "nombre")
    {
    $columna = "Cliente";
    }
    if ($columna == "id_factura_manual")
    {
    $columna = "ID";
    }
    if ($columna == "numero")
    {
    $columna = "Número";
    }
    if ($columna == "estado")
    {
    $columna = "Estado";
    }
    if ($columna == "fecha")
    {
    $columna = "Fecha";
    }
    if ($columna == "fecha_vencimiento")
    {
    $columna = "Fecha de vencimiento";
    }
    if ($columna == "email")
    {
    $columna = "Email";
    }
    if ($columna == "direccion")
    {
    $columna = "Domicilio";
    }
    if ($columna == "importe")
    {
    $columna = "Importe";
    }
    if ($columna == "imagen")
    {
    $columna = "Importe final";
    }
    if ($columna == "cif")
    {
    $columna = "CIF";
    }
    if ($columna == "igic")
    {
    $columna = "IGIC";
    }
    if ($columna == "irpf")
    {
    $columna = "IRPF";
    }
    $sheet->setCellValue($columnaActual . $filaActual, $columna);
    $columnaActual++;
    }
    
    }
    $filaActual++;
    foreach ($facturas_manuales as $fila)
    {
    $columnaActual = 'A';
    foreach ($fila as $clave => $valor)
    {
    if (($clave != "id_tramitadora") && ($clave != "id_gestor") && ($clave != "id_contable") && ($clave != "tipo") && ($clave != "client_id") && ($clave != "fecha_envio") && ($clave != "titulo") && ($clave != "telefono") && ($clave !=
    "cp"))
    {
    if ($clave == "igic")
    {
    $valor = $valor . "%";
    }
    if ($clave == "irpf")
    {
    $valor = ($valor != null) ? $valor . "%" : "0.00%";
    }
    if ($clave == "importe")
    {
    $valor = $valor . "€";
    }
    if ($clave == "imagen")
    {
    $importe = str_replace("€", "", $fila->importe);
    $igic_porcentaje = str_replace("%", "", $fila->igic);
    $irpf_porcentaje = ($fila->irpf != null) ? str_replace("%", "", $fila->irpf) : 0.00;
    
    // Calcular el valor para "imagen"
    $importe_num = (float) str_replace("€", "", $importe);
    $igic_num = (float) str_replace("%", "", $igic_porcentaje);
    $irpf_num = (float) str_replace("%", "", $irpf_porcentaje);
    
    $valor_imagen = $importe_num + ($importe_num * $igic_num / 100) - ($importe_num * $irpf_num / 100);
    $valor = number_format($valor_imagen, 2) . "€";
    }
    $sheet->setCellValue($columnaActual . $filaActual, $valor);
    $columnaActual++;
    }
    }
    $filaActual++;
    }
    
    
    // Configurar el encabezado del archivo XLSX
    // Guardar el archivo XLSX en la salida (output)
    $writer = IOFactory::createWriter($spreadsheet, 'Xls');
    
    $rutaCarpetaGuardar = __ROOT__ . '/copias/';
    $nombreArchivoXLSX = 'copia.xlsx';
    if (file_exists($rutaCarpetaGuardar . $nombreArchivoXLSX))
    {
    unlink($rutaCarpetaGuardar . $nombreArchivoXLSX);
    }
    $writer->save($rutaCarpetaGuardar . $nombreArchivoXLSX);
    $contenidoXLSX = file_get_contents($rutaCarpetaGuardar . $nombreArchivoXLSX);
    
    
    
    // Leer el archivo y enviarlo al navegador
    return $contenidoXLSX;
    }