<?php
	//Include the MVC Configuration
	require_once('../core/configuration.php');
	
	//Include the Users Model
	require_once(__MODELS__.'users.model.php');
	
	//Include the Mailer Model
	require_once(__MODELS__.'mailer.model.php');
	
	//The E-Mail used for send the Passwords reset links
	define('EMAIL_RESTORE_SERVER', 'mail.inqueueapp.io');
	define('EMAIL_RESTORE_PORT', 587);
	define('EMAIL_RESTORE_SENDER', 'OneUP Saves');
	define('EMAIL_RESTORE_TITLE', 'Por favor, activa tu cuenta');
	
	//Declare the Users Model
	$Users = new _UsersModel($DBLink);
	
	//Declare the Mailer Model
	$Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
	
	//Get the Newsletter Content
	$Newsletter = file_get_contents('./newsletter.html');
	
	//Check for Newsletter Reading Error
	if ($Newsletter == false) {
		echo 'Error Reading the Newsletter File!'.PHP_EOL;
		exit();
	}
	
	//Open the E-Mails File
	$File = fopen('emails.txt', 'r');
	
	//Check if the E-Mails File is Open
	if ($File) {
		//Loop until all file line by line
		while (($Email = fgets($File)) !== false) {
			$Email = trim($Email);
			
			//Get this User Information
			$User = $Users->_GetUserData($Email);
			//$User['user_id']
			//$User['user_role']
			//$User['user_origin']
			//$User['user_referrer']
			//$User['user_referrals']
			//$User['user_email']
			//$User['user_password']
			//$User['user_full_name']
			//$User['user_purchases']
			//$User['user_tokens']
			//$User['user_blocked_tokens']
			//$User['user_bonus_tokens']
			//$User['user_bonus_blocked_tokens']
			//$User['user_oneups']
			//$User['user_bonuses']
			//$User['user_address']
			//$User['user_avatar']
			//$User['user_code']
			//$User['user_verification_status']
			//$User['user_last_seen']
			//$User['user_first_seen']
			
			//Check for Error getting the User Information
			if (!is_array($User) || $User < 0) {
				file_put_contents('emails_errors.txt' , $Email.PHP_EOL, FILE_APPEND);
				
				echo 'Error Retrieving User Data "'.$Email.'"'.PHP_EOL;
				continue;
			}
			
			//Get the Update Code for this User
			$Update = $Users->_GetUpdateCode($User['user_id']);
			
			//Check for Error getting the User Update Code
			if (!is_string($Update) || $Update < 0) {
				file_put_contents('emails_errors.txt' , $User['user_email'].PHP_EOL, FILE_APPEND);
				
				continue;
			}
			
			$Keywords = array();
			
			$Keywords[] = array('%registration_link%', htmlentities('https://panel.oneupsaves.io/'.'update?email='.urlencode($User['user_email']).'&code='.urlencode($Update), ENT_QUOTES));
			$Keywords[] = array('%referrer_link%', htmlentities('https://panel.oneupsaves.io/'.'register?referrer='.urlencode($User['user_code']), ENT_QUOTES));
			
			//Set the Message Keywords
			$Mailer->_SetKeywords($Keywords);
			
			//Send the E-Mail to the User
			$Email = $Mailer->_Mail(EMAIL_RESTORE_USERNAME, $User['user_email'], EMAIL_RESTORE_TITLE, $Newsletter, EMAIL_RESTORE_SENDER);
			
			//Check for Valid E-Mail
			if ($Email !== true) {
				file_put_contents('emails_errors.txt' , $User['user_email'].PHP_EOL, FILE_APPEND);
				
				echo 'Error Code "'.$Email.'" Sending Email "'.$User['user_email'].'"'.PHP_EOL;
				continue;
			}
			
			file_put_contents('emails_success.txt' , $User['user_email'].PHP_EOL, FILE_APPEND);
			
			echo 'E-Mail Sended Sucessfull: '.$User['user_email'].PHP_EOL;
		}

		fclose($File);
	//Error Opening the E-Mails File
	} else {
		echo 'Error Opening the E-Mails File!'.PHP_EOL;
	}
	
	echo 'Process Finished!'.PHP_EOL;
?>