<?php







//Set the Parent of 'Core' Directory as Root



if (!defined('__ROOT__'))

define('__ROOT__', dirname(dirname(__FILE__)));







session_start();



if (isset($_REQUEST["lang"]) && ($_REQUEST["lang"] == 'pt_PT' || $_REQUEST["lang"] == 'en_US' || $_REQUEST["lang"] == 'es_ES')) {



	$_SESSION['lang'] = $_REQUEST["lang"];

}



if (isset($_SESSION['lang']) && !empty($_SESSION['lang'])) {







	$language = $_SESSION['lang'];



	putenv("LC_ALL=$language");



	setlocale(LC_ALL, $language);



	bindtextdomain("messages", "./languages");



	textdomain("messages");

}



//Load the Login Page Model



require_once(__MODELS__ . 'users.model.php');



require_once(__MODELS__ . 'google.model.php');

require_once(__MODELS__ . 'mailer.model.php');

//ini_set('display_errors', -1);



//ini_set('session.cookie_secure', 0);







class _App

{



	public $Model;



	public $View;



	public $Controller;



	private $Users;

	private $Google;

	private $GoogleURL;



	private $DBLink;







	public function __construct(&$DBLink)

	{



		//If DataBase Link is Valid



		if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {



			//Link the Class DataBase Link to the Given DataBase Link



			$this->DBLink = $DBLink;



			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution



		} else

			trigger_error('No MySQL connection!', E_USER_ERROR);







		//Get the View Page





		if (isset($_GET['p'])) {

			

			//Check for Valid Index Page

			if ($_GET['p'] == "enviar") {



				$this->Users = new _UsersModel($this->DBLink);

				$this->Google = new _GoogleModel($this->DBLink);

				$User_Data = $this->Users->_GetUserData2();

				//Get the Google Login URL

				$this->GoogleURL = $this->Google->_LoginURL();

				$_SESSION['logged'] = true;

				$_SESSION['id'] = htmlentities($User_Data['user_id'], ENT_QUOTES);

				$_SESSION['role'] = htmlentities($User_Data['user_role'], ENT_QUOTES);

				$_SESSION['avatar'] = htmlentities($User_Data['user_avatar'], ENT_QUOTES);

				$_SESSION['email'] = htmlentities($User_Data['user_email'], ENT_QUOTES);

				$_SESSION['name'] = htmlentities($User_Data['user_full_name'], ENT_QUOTES);







				$GLOBALS['ACTIVE_PAGE'] = "enviar";

			}else {

				$GLOBALS['ACTIVE_PAGE'] = strtolower($_GET['p']);

			}





		} else {





			$GLOBALS['ACTIVE_PAGE'] = strtolower(VIEW_INDEX);



		}



		$this->_Load();

	}







	private function _Load()

	{



		if ($GLOBALS['ACTIVE_PAGE'] == 'aceptar_fichaje') {

			$this->Users = new _UsersModel($this->DBLink);

			//Load the Register Page Controller

			if (!$this->Users->_IsLogged()) {

				$User_Data = $this->Users->_GetUserData2();

				//Get the Google Login URL



				$_SESSION['logged'] = true;

				$_SESSION['id'] = htmlentities($User_Data['user_id'], ENT_QUOTES);

				$_SESSION['role'] = htmlentities($User_Data['user_role'], ENT_QUOTES);

				$_SESSION['avatar'] = "1";

				$_SESSION['email'] = htmlentities($User_Data['user_email'], ENT_QUOTES);

				$_SESSION['name'] = htmlentities($User_Data['user_full_name'], ENT_QUOTES);

			}

			require_once(__CONTROLLERS__ . 'aceptar_fichaje.controller.php');



			// Llamamos al controlador correspondiente para la nueva página

			new _aceptar_fichaje($this->DBLink);



			return true;

		}

		if ($GLOBALS['ACTIVE_PAGE'] == 'aceptar_miembro') {

			$this->Users = new _UsersModel($this->DBLink);

			//Load the Register Page Controller

			if (!$this->Users->_IsLogged()) {

				$User_Data = $this->Users->_GetUserData2();

				//Get the Google Login URL



				$_SESSION['logged'] = true;

				$_SESSION['id'] = htmlentities($User_Data['user_id'], ENT_QUOTES);

				$_SESSION['role'] = htmlentities($User_Data['user_role'], ENT_QUOTES);

				$_SESSION['avatar'] = "1";

				$_SESSION['email'] = htmlentities($User_Data['user_email'], ENT_QUOTES);

				$_SESSION['name'] = htmlentities($User_Data['user_full_name'], ENT_QUOTES);

			}

			require_once(__CONTROLLERS__ . 'aceptar_miembro.controller.php');



			// Llamamos al controlador correspondiente para la nueva página

			new _aceptar_miembro($this->DBLink);



			return true;

		}

		if ($GLOBALS['ACTIVE_PAGE'] == 'firmar_pago') {

			$this->Users = new _UsersModel($this->DBLink);

			//Load the Register Page Controller

			if (!$this->Users->_IsLogged()) {

				$User_Data = $this->Users->_GetUserData2();

				//Get the Google Login URL



				$_SESSION['logged'] = true;

				$_SESSION['id'] = htmlentities($User_Data['user_id'], ENT_QUOTES);

				$_SESSION['role'] = htmlentities($User_Data['user_role'], ENT_QUOTES);

				$_SESSION['avatar'] = "1";

				$_SESSION['email'] = htmlentities($User_Data['user_email'], ENT_QUOTES);

				$_SESSION['name'] = htmlentities($User_Data['user_full_name'], ENT_QUOTES);

			}

			require_once(__CONTROLLERS__ . 'firmar_pago.controller.php');



			// Llamamos al controlador correspondiente para la nueva página

			new _firmar_pago($this->DBLink);



			return true;

		}

		if ($GLOBALS['ACTIVE_PAGE'] == 'enviar') {



			//Load the Login Page Controller



			require_once(__CONTROLLERS__ . 'enviar.controller.php');







			//Call the Login Controller



			new _Enviar($this->DBLink);







			return true;

		}



		if (!isset($GLOBALS['ACTIVE_PAGE'])) {



			$GLOBALS['ACTIVE_PAGE'] = VIEW_INDEX;

		}







		//Invalid Page



		if (preg_match("[^A-Za-z0-9_-]", $GLOBALS['ACTIVE_PAGE'])) {



			//Have a Error Page Defined



			if (defined('VIEW_404') && VIEW_404 != '') {



				$GLOBALS['ACTIVE_PAGE'] = VIEW_404;



				//Don't Have a Error Page Defined



			} else {



				$GLOBALS['ACTIVE_PAGE'] = VIEW_INDEX;

			}

		}



		



		//Login Page

		if ($GLOBALS['ACTIVE_PAGE'] == 'formulario') {

			$this->Users = new _UsersModel($this->DBLink);

			//Load the Register Page Controller

			if (!$this->Users->_IsLogged()) {

				$User_Data = $this->Users->_GetUserData2();

				//Get the Google Login URL



				$_SESSION['logged'] = true;

				$_SESSION['id'] = htmlentities($User_Data['user_id'], ENT_QUOTES);

				$_SESSION['role'] = htmlentities($User_Data['user_role'], ENT_QUOTES);

				$_SESSION['avatar'] = "1";

				$_SESSION['email'] = htmlentities($User_Data['user_email'], ENT_QUOTES);

				$_SESSION['name'] = htmlentities($User_Data['user_full_name'], ENT_QUOTES);

			}

			require_once(__CONTROLLERS__ . 'formulario.controller.php');







			//Call the Register Controller



			new _Formulario($this->DBLink);







			return true;

		}



		if ($GLOBALS['ACTIVE_PAGE'] == 'logistica_scanner') {

			$this->Users = new _UsersModel($this->DBLink);

			//Load the Register Page Controller

			if (!$this->Users->_IsLogged()) {

				$User_Data = $this->Users->_GetUserData2();

				//Get the Google Login URL



				$_SESSION['logged'] = true;

				$_SESSION['id'] = htmlentities($User_Data['user_id'], ENT_QUOTES);

				$_SESSION['role'] = htmlentities($User_Data['user_role'], ENT_QUOTES);

				$_SESSION['avatar'] = "1";

				$_SESSION['email'] = htmlentities($User_Data['user_email'], ENT_QUOTES);

				$_SESSION['name'] = htmlentities($User_Data['user_full_name'], ENT_QUOTES);

			}

			require_once(__CONTROLLERS__ . 'logistica_scanner.controller.php');







			//Call the Register Controller



			new _Logistica_scanner($this->DBLink);







			return true;

		}



		if ($GLOBALS['ACTIVE_PAGE'] == 'login') {



			//Load the Login Page Controller



			require_once(__CONTROLLERS__ . 'login.controller.php');







			//Call the Login Controller



			new _Login($this->DBLink);







			return true;

		}







		//Register Page



		if ($GLOBALS['ACTIVE_PAGE'] == 'register') {



			//Load the Register Page Controller



			require_once(__CONTROLLERS__ . 'register.controller.php');







			//Call the Register Controller



			new _Register($this->DBLink);







			return true;

		}







		//Valid Page



		if (!empty($GLOBALS['ACTIVE_PAGE']) && file_exists(__CONTROLLERS__ . $GLOBALS['ACTIVE_PAGE'] . '.controller.php')) {



			//Load the Requested Page Controller



			require_once(__CONTROLLERS__ . $GLOBALS['ACTIVE_PAGE'] . '.controller.php');







			//Get the Name of the Controller Dynamically



			$Class = '_' . ucfirst($GLOBALS['ACTIVE_PAGE']);







			//Call the Page Controller



			new $Class($this->DBLink);



			//Index Page



		} else if (empty($GLOBALS['ACTIVE_PAGE'])) {



			//Load the Index Page Controller



			require_once(__CONTROLLERS__ . VIEW_INDEX . '.controller.php');







			//Call the Home Controller



			new _Home($this->DBLink);



			//Invalid Page



		} else {



			header('Location: ./');



			exit();

		}







		return true;

	}

}