<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__'))

	exit();


require __ROOT__ . '/vendor/autoload.php';

require_once __ROOT__ . '/core/configuration.php';

require_once __ROOT__ . '/models/mailer.model.php';

require_once __ROOT__ . '/controllers/mailer.controller.php';

require_once __ROOT__ . '/models/users.model.php';

require_once __ROOT__ . '/models/presupuestos.model.php';

require_once __ROOT__ . '/models/facturamanual.model.php';

include __ROOT__ . ("/api/utils.php");
require_once(__LIBRARIES__ . 'anti_csrf.class.php');

 

$_SESSION['logged'] = true;





class _verifactu

{

	private $DBLink;



	public function __construct(&$DBLink)

	{
$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);

$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

$mailer_controller = new _mailer($DBLink);

		$id_factura = $_GET['id'] ?? null;
		$id_factura_manual_materiales = $_GET['id_factura_materiales'] ?? null;
		$hash = $_GET['hash'];



		if ($id_factura === null && $id_factura_manual_materiales === null) {

			header("HTTP/1.1 400 Bad Request");

			exit;
		} else {
			if ($id_factura !== null) {
				$sql = $DBLink->prepare("SELECT 

		f.*, 

		ROUND(COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0), 2) AS igic_sumado,

		ROUND(

			COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) + 

			f.importe - 

			COALESCE(f.importe * (f.irpf / 100), 0), 

			2

		) AS importe_calculado,

		c.nombre AS nombre_cliente,

		c.client_id,

		c.codigo AS codigo_cliente

	FROM 

		factura_manual f

	JOIN 

		clientes c ON f.client_id = c.client_id

	LEFT JOIN 

		apartado_factura_manual a ON f.id_factura_manual = a.id_factura_manual

	WHERE f.id_factura_manual = ?

	GROUP BY f.id_factura_manual;");

				if ($sql === false) {

					header("HTTP/1.1 400 Bad Request");

					exit;
				}



				$sql->bind_param("i", $id_factura);

				if (!$sql->execute()) {

					header("HTTP/1.1 400 Bad Request");

					exit;
				}



				$result = $sql->get_result();

				$Factura = $result->fetch_assoc();

				if ($Factura === null) {

					header("HTTP/1.1 404 Not Found");

					exit;
				}



				$qrCodeContent = $Factura['id_factura_manual'] . '_' . $Factura['numero'];

				$hash_for_verify = hash('sha256', $qrCodeContent);



				if ($hash != $hash_for_verify) {

					header("HTTP/1.1 404 Not Found");

					exit;
				}



				require_once(__VIEWS__ . 'verifactu.template.php');
			}
			if ($id_factura_manual_materiales !== null) {


				
				$sql = $DBLink->prepare("SELECT 
    f.*,

    -- IGIC total sumado sobre el precio con descuentos aplicados
    ROUND(COALESCE(SUM(
        a.dias * a.cantidad * a.precio_unitario 
        * (1 - IFNULL(a.descuento, 0) / 100)
        * (1 - IFNULL(f.descuento, 0) / 100)
        * (IFNULL(a.igic, 0) / 100)
    ), 0), 2) AS igic_sumado,

    -- Subtotal neto con descuentos aplicados (sin IGIC, sin IRPF)
    ROUND(COALESCE(SUM(
        a.dias * a.cantidad * a.precio_unitario 
        * (1 - IFNULL(a.descuento, 0) / 100)
        * (1 - IFNULL(f.descuento, 0) / 100)
    ), 0), 2) AS subtotal,

    -- IRPF aplicado sobre la base (descuentos incluidos)
    ROUND(COALESCE(SUM(
        a.dias * a.cantidad * a.precio_unitario 
        * (1 - IFNULL(a.descuento, 0) / 100)
        * (1 - IFNULL(f.descuento, 0) / 100)
        * (IFNULL(f.irpf, 0) / 100)
    ), 0), 2) AS irpf_retenido,

    -- Total final = Subtotal + IGIC - IRPF
    ROUND(
        COALESCE(SUM(
            a.dias * a.cantidad * a.precio_unitario 
            * (1 - IFNULL(a.descuento, 0) / 100)
            * (1 - IFNULL(f.descuento, 0) / 100)
        ), 0) +
        COALESCE(SUM(
            a.dias * a.cantidad * a.precio_unitario 
            * (1 - IFNULL(a.descuento, 0) / 100)
            * (1 - IFNULL(f.descuento, 0) / 100)
            * (IFNULL(a.igic, 0) / 100)
        ), 0) -
        COALESCE(SUM(
            a.dias * a.cantidad * a.precio_unitario 
            * (1 - IFNULL(a.descuento, 0) / 100)
            * (1 - IFNULL(f.descuento, 0) / 100)
            * (IFNULL(f.irpf, 0) / 100)
        ), 0),
    2) AS importe_calculado,

    c.nombre AS nombre_cliente,
    c.client_id 

FROM factura_manual_materiales f
JOIN clientes c ON f.client_id = c.client_id
LEFT JOIN apartado_factura_manual_materiales a 
    ON f.id_factura_manual_materiales = a.id_factura_manual_materiales
WHERE f.id_factura_manual_materiales = ? 
GROUP BY f.id_factura_manual_materiales;");

				if ($sql === false) {

					header("HTTP/1.1 400 Bad Request");

					exit;
				}



				$sql->bind_param("i", $id_factura_manual_materiales);

				if (!$sql->execute()) {

					header("HTTP/1.1 400 Bad Request");

					exit;
				}



				$result = $sql->get_result();

				$factura_manual = $result->fetch_assoc();

				if ($factura_manual === null) {

					header("HTTP/1.1 404 Not Found");

					exit;
				}

				// Obtener los elementos de apartado_factura_manual
				$factura_manual['subtotal'] = floatval($factura_manual['subtotal']);
				$factura_manual['igic_sumado'] = floatval($factura_manual['igic_sumado']);
				$factura_manual['importe_calculado'] = floatval($factura_manual['importe_calculado']);

				$sql = $DBLink->prepare("SELECT *

                        FROM apartado_factura_manual_materiales

                        WHERE id_factura_manual_materiales = ?");
				$sql->bind_param("i", $_GET['id_factura_materiales']);

				$sql->execute();
				$result = $sql->get_result();
				$apartados = $result->fetch_assoc();

				// Añadir los apartados al objeto de factura_manual

				$factura_manual['apartados'] = $apartados;



				if (!empty($factura_manual['id_banco'])) {

					$sql = $DBLink->prepare("SELECT * FROM bancos WHERE id_banco = ?");

					$sql->bind_param('i', $factura_manual['id_banco']);

					$sql->execute();
					$result = $sql->get_result();
					$banco = $result->fetch_assoc();
				}
				// Añadir los bancos al objeto de factura_manual

				$factura_manual['banco'] = $banco;



				$suma_irpf = ($factura_manual["irpf"] != null) ? ($factura_manual["irpf"] / 100) : 0;

				// Iterar sobre los apartados de cada factura


				$factura_manual["importe_calculado"] = floatval($factura_manual["importe_calculado"]);


				$qrCodeContent = $factura_manual['id_factura_manual_materiales'] . '_' . $factura_manual['numero'];

				$hash_for_verify = hash('sha256', $qrCodeContent);



				if ($hash != $hash_for_verify) {

					header("HTTP/1.1 404 Not Found");

					exit;
				}



				require_once(__VIEWS__ . 'verifactu2.template.php');
 $_SESSION = [];
session_destroy();

exit;
			}
		}
	}
}