<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__')) exit();
	
	//require_once(__LIBRARIES__.'anti_csrf.class.php');
	
	class _Update {
		private $DBLink;
		private $Users;
		
		public function __construct(&$DBLink) {
			//If DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			
			//User Already Loged
			if ($this->Users->_IsLogged() === true) {
				header('Location: ./');
				exit();
			}
			
			//Check for Pre-Assigned E-Mail
			if (isset($_GET['email']) && !empty($_GET['email']) && filter_var($_GET['email'], FILTER_VALIDATE_EMAIL)) {
				$Email = $_GET['email'];
			}
			
			//Check for Pre-Assigned Name
			if (isset($_GET['name']) && !empty($_GET['name'])) {
				$Name = $_GET['name'];
			}
			
			//Check for Pre-Assigned Surnames
			if (isset($_GET['surnames']) && !empty($_GET['surnames'])) {
				$Surnames = $_GET['surnames'];
			}
			
			//Update Request
			if ((isset($_GET['code']) && !empty($_GET['code']) && ctype_alnum($_GET['code'])) && isset($_POST['name']) && isset($_POST['surnames']) && 
			isset($_POST['password1']) && isset($_POST['password2'])) {
				//Do Update
				$Update = $this->Users->_UpdateUser($_GET['code'], $_POST['name'], $_POST['surnames'], $_POST['password1'], $_POST['password2']);
				
				//Sucessfull Update
				if ($Update === true) {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&success');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&success');
					}
					exit();
				//Invalid or Expired Update Code
				} else if ($Update == -1 || $Update == -4 || $Update == -12) {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&error=-1');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&error=-1');
					}
					exit();
				//Invalid Name
				} else if ($Update == -2) {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&error=-2');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&error=-2');
					}
					exit();
				//Invalid Surnames
				} else if ($Update == -3) {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&error=-3');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&error=-3');
					}
					exit();
				//Invalid User Origin
				} else if ($Update == -6) {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&error=-4');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&error=-4');
					}
					exit();
				//The New Password is Invalid
				} else if ($Update == -7) {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&error=-5');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&error=-5');
					}
					exit();
				//The Two Passwords aren't the same
				} else if ($Update == -8) {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&error=-6');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&error=-6');
					}
					exit();
				//Unknown Error
				} else {
					if (isset($Email)) {
						header('Location: ./update?email='.$Email.'&code='.$_GET['code'].'&error=-7');
					} else {
						header('Location: ./update?code='.$_GET['code'].'&error=-7');
					}
					exit();
				}
			//Don't Have any Update Code
			} else if (!isset($_GET['code']) || empty($_GET['code']) || !ctype_alnum($_GET['code'])) {
				header('Location: ./login');
				exit();
			}
			
			$csrf_token = '';
			
			//Load the Update Page Template
			require_once(__VIEWS__.'update.template.php');
		}
	}
?>