<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) exit();
	
	//Load the Tickets Page Model
	require_once(__MODELS__.'tickets.model.php');
	
	//Include the Sales Model
	require_once(__MODELS__.'sales.model.php');
	
	require_once(__LIBRARIES__.'anti_csrf.class.php');
	
	class _Tickets {
		private $DBLink;
		private $Users;
		private $Sales;
		private $Tickets;
		
		public function __construct(&$DBLink) {
			//If DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			
			//Logout Function or Invalid Session
			if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
				$this->Users->_Logout();
				
				header('Location: ./login');
				exit();
			}
			
			//Get this User Information
			$User_Data = $this->Users->_GetUserData();
			//$User_Data['user_id']
			//$User_Data['user_role']
			//$User_Data['user_origin']
			//$User_Data['user_referrer']
			//$User_Data['user_email']
			//$User_Data['user_password']
			//$User_Data['user_purchases']
			//$User_Data['user_bonuses']
			//$User_Data['user_referrals']
			//$User_Data['user_tokens']
			//$User_Data['user_oneups']
			//$User_Data['user_address']
			//$User_Data['user_avatar']
			//$User_Data['user_code']
			//$User_Data['user_last_seen']
			//$User_Data['user_first_seen']
			
			//Check the User Permissions
			if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {
				//Check the User Index Page
				if (is_array($User_Data) && isset($User_Data['user_role'])) {
					//Get the User Index Page
					$Index = _RoleHome($User_Data['user_role']);
					
					//Check for Valid Index Page
					if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {
						header('Location: ./'.$Index);
						exit();
					} else if ($Index !== false) {
						header('Location: ./'.$Index);
						exit();
					}
				}
				
				header('Location: ./login');
				exit();
			}
			
			$this->Sales = new _SalesModel($this->DBLink);
			
			//Get the Packets List
			$Packets = $this->Sales->_ListPackets();
			//$Packets[0]['packet_id']
            //$Packets[0]['packet_name']
            //$Packets[0]['packet_tokens']
            //$Packets[0]['packet_bonus']
            //$Packets[0]['packet_oneups']
            //$Packets[0]['packet_sales']
            //$Packets[0]['packet_limit']
            //$Packets[0]['packet_price']
            //$Packets[0]['packet_creation']
			
			$this->Tickets = new _TicketsModel($this->DBLink);
			
			//New Ticket Creation
			if (isset($_POST['title']) && !empty($_POST['title']) && isset($_POST['text']) && !empty($_POST['text']) && NoCSRF::check('csrf_token', $_POST)) {
				$Ticket = $this->Tickets->_AddTicketByUser($_SESSION['id'], $_POST['title']);
				
				//Check if the Tickets was Created Correctly
				if ($Ticket > 0) {
					$this->Tickets->_AddMessageTicketByUser($_SESSION['id'], $Ticket, $_POST['text']);
					
					header('Location: ./tickets');
					exit();
				}
			}

			if(isset($_GET['archive'])){
				//AQUI FALTA COMPROBAR QUE EL USUARIO TENGA PERMISO CONTRA ESE TICKET, CUANDO HAYA ROLES
				//DE MOMENTO TODOS LOS USERS SON ADMIN
				$this->Tickets->_ChangeStatusTicket($_GET['archive'], 'Cerrado');
			}
			

			$listado = $this->Tickets->_GetTicketListByUser($_SESSION['id']);
			
			$csrf_token = NoCSRF::generate('csrf_token');
			
			//Load the Header Template
			require_once(__VIEWS__.'header.template.php');
			
			//Load the Tickets Page Template
			require_once(__VIEWS__.'tickets.template.php');
			
			//Load the Footer Template
			require_once(__VIEWS__.'footer.template.php');
		}

		public function _GetLastMsgDate($id){
			if (!($this->Tickets instanceof _TicketsModel)) {
				$this->Tickets = new _TicketsModel($this->DBLink);
			}
			
			//Get Last Ticket Message
			$lastMessage = $this->Tickets->_GetLastMsg($id);

			return $this->_FormateaFecha($lastMessage['message_date']);
		}

		public function _FormateaFecha($epoch){
			if($epoch != null){
				$dt = new DateTime("@$epoch");  
				return $dt->format('H:i:s d/m/Y');
			}else{
				return "En breve serás respondido.";
			}
		}
	}
?>
