<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))

	exit();



//Load the folders Page Model

require_once(__MODELS__ . 'folders.model.php');

//Include the Browser Detection Library

require_once(__LIBRARIES__ . 'browser.php');

//Include the GeoIP Library

require_once(__LIBRARIES__ . 'maxmind/autoload.php');

require_once(__LIBRARIES__ . 'anti_csrf.class.php');

require_once(__MODELS__ . 'personalizacion.model.php');

class _Profile

{

	private $DBLink;

	private $Profile;

	private $Users;

	private $Sales;

	private $Browser;

	private $Personalizacion;

	public function __construct(&$DBLink)

	{

		//If DataBase Link is Valid

		if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

			//Link the Class DataBase Link to the Given DataBase Link

			$this->DBLink = $DBLink;

			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

		} else

			trigger_error('No MySQL connection!', E_USER_ERROR);



		$this->Users = new _UsersModel($this->DBLink);

		$this->Personalizacion = new _PersonalizacionModel($this->DBLink);

		//Logout Function or Invalid Session

		if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

			$this->Users->_Logout();



			header('Location: ./login');

			exit();

		}



		//Get this User Information

		$User_Data = $this->Users->_GetUserData();

		$Roles = $this->Personalizacion->GetListRoles();



		$this->Folders = new _FoldersModel($this->DBLink);









		if (isset($_GET['delete']) && is_numeric($_GET['delete']) && $_GET['delete'] > 0 && NoCSRF::check('csrf_token', $_GET)) {



			$DeleteFiles = $this->Folders->DeleteFiles($_GET['delete']);

		}



















		if (isset($_POST['id_rol']) && isset($_GET['id'])) {

			if ($_POST['id_rol'] == "delete") {

				$DeleteUser = $this->Users->_DeleteUser($_GET['id']);

			} else {

				$AsignarRol = $this->Personalizacion->AsignarRol($_POST['id_rol'], $_GET['id']);

			}

		}

		//Get the User Information

		$permisos = [];

		//echo var_dump($_SESSION);

		if ($User_Data['id_rol'] != NULL) {

			$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);

			//echo var_dump($permisos);



		}

		if (!in_array('miembros', $permisos, true)) {

			$PermisoRol = false;

		} else {

			$PermisoRol = true;

		}





		$User = $this->Users->_GetUserData($_GET['id']);



		$Miembro = $this->Users->GetMiembroByIdUser($_GET['id']);



		//Check for Role Change



		if (isset($_POST['role']) && !empty($_POST['role']) /*&& NoCSRF::check('csrf_token', $_POST)*/) {



			if ($_POST['role'] == 'delete') {



				$DeleteUser = $this->Users->_DeleteUser($_GET['id']);

			} else {



				$RoleChange = $this->Users->_ChangeRole($_GET['id'], $_POST['role']);

				if ($RoleChange !== true) {

					echo 'Role Change: ' . $RoleChange;

					exit();

				}

			}

		}



		$csrf_token = NoCSRF::generate('csrf_token');

		$User_Logins = $this->Users->_LoginList($_GET['id']);





		$User_Logins = $this->Users->_LoginList($User['user_id']);

		$id_empleado = 0;

		if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `empleados` WHERE id_usuario=" . $_GET['id'])) {

			$Result = mysqli_fetch_assoc($Query);

			if(!is_null($Result)){

				$id_empleado = $Result['id_empleado'];

			}

		}



		$Vacaciones = [];

		if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `periodo_vacaciones` WHERE id_empleado=" . $id_empleado)) {

			while ($row = mysqli_fetch_assoc($Query)) {

				$Vacaciones[] = $row;

			}

		}



		error_reporting(0);

		ini_set('display_errors', 0);



		require_once(__VIEWS__ . 'header.template.php');



		//Load the Profile Page Template

		require_once(__VIEWS__ . 'profile.template.php');



		//Load the Footer Template

		require_once(__VIEWS__ . 'footer.template.php');

	}



	function _ParseBrowser($UserAgent)

	{

		if (!($this->Browser instanceof Browser)) {

			$this->Browser = new Browser($UserAgent);

		} else {

			$this->Browser->setUserAgent($UserAgent);

		}



		$Browser = $this->Browser->getBrowser();



		if ($Browser == false || $Browser == 'unknown') {

			return 'Desconocido';

		}



		$Version = $this->Browser->getVersion();



		if ($Version == false || $Version == 'unknown') {

			return 'Desconocido';

		}





		return $Browser . ' ' . $Version;

	}



	//https://stackoverflow.com/questions/1416697/converting-timestamp-to-time-ago-in-php-e-g-1-day-ago-2-days-ago

	function time_elapsed_string($datetime, $full = false)

	{

		$now = new DateTime;

		$ago = new DateTime($datetime);

		$diff = $now->diff($ago);



		$diff->w = floor($diff->d / 7);

		$diff->d -= $diff->w * 7;



		$string = array(

			'y' => _('año'),

			'm' => _('mes'),

			'w' => _('semana'),

			'd' => _('día'),

			'h' => _('hora'),

			'i' => _('minuto'),

			's' => _('segundo'),

		);

		foreach ($string as $k => &$v) {

			if ($diff->$k) {

				$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');

			} else {

				unset($string[$k]);

			}

		}



		if (!$full)

			$string = array_slice($string, 0, 1);

		return $string ? implode(', ', $string) . _(' atrás') : _('justo ahora');

	}

}