<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
    exit();


//Load the folders Page Model
require_once(__MODELS__ . 'folders.model.php');
require_once(__MODELS__ . 'apartado.model.php');
require_once(__LIBRARIES__ . 'anti_csrf.class.php');
require_once(__MODELS__ . 'presupuestos.model.php');
class _Presupuestos_programados
    {
    private $DBLink;
    private $Apartados;
    private $Presupuestos;
    public function __construct(&$DBLink)
        {
        //If DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
            {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
            } else
            trigger_error('No MySQL connection!', E_USER_ERROR);

        $this->Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false)
            {
            $this->Users->_Logout();

            header('Location: ./login');
            exit();
            }
        $this->Apartados = new _ApartadoModel($this->DBLink);
        $this->Presupuestos = new _PresupuestosModel($this->DBLink);
        /*CREATE APARTADO*/



        //Get this User Information
        $User_Data = $this->Users->_GetUserData();



        $this->Folders = new _FoldersModel($this->DBLink);




        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != NULL)
            {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

            }
        if (!in_array('presupuestosprogramados', $permisos, true))
            {
            header('Location: ./login');
            exit();
            }


        //mostrar datos de carpetas
        $Apartados = $this->Apartados->GetListApartados();
        $Apartados_Count = $this->Apartados->GetApartadosCount();

        $Programados = $this->Presupuestos->GetListProgramados();

        require_once(__VIEWS__ . 'header.template.php');

        //Load the Profile Page Template
        require_once(__VIEWS__ . 'presupuestos_programados.template.php');

        //Load the Footer Template
        require_once(__VIEWS__ . 'footer.template.php');


        }




    }

?>