<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

require_once __MODELS__ . 'presupuestos.model.php';
require_once __MODELS__ . 'facturas.model.php';
require_once __LIBRARIES__ . 'anti_csrf.class.php';
require_once __MODELS__ . 'pagos.model.php';
class _pago_a_proveedores
{
    private $DBLink;
    private $Profile;
    private $Users;
    private $Sales;
    private $Browser;

    private $Facturas;

    private $Pagos;
    public function __construct(&$DBLink)
    {
        //If DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }
        $this->Pagos = new _PagosModel($this->DBLink);
        $this->Facturas = new _FacturasModel($this->DBLink);
        $this->Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
            $this->Users->_Logout();

            header('Location: ./login');
            exit();
        }

        //Get this User Information
        $User_Data = $this->Users->_GetUserData();

        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != null) {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

        }
        if (!in_array('pagoaproveedores', $permisos, true)) {
            header('Location: ./login');
            exit();
        }

        $Proveedores = $this->Facturas->GetListProveedores();
        $Bancos = $this->Pagos->GetListBancos();
        $Pagos = $this->Pagos->GetListFacturasProveedor();
        $Pendientes = 0;
        $Pendiente_pago = 0;
        $Pagados = 0;
        foreach ($Pagos as $P) {
            $estado = $this->Pagos->GetEstadoFactura($P["id_factura_proveedor"], $P["importe"]);
            if ($estado == "Pendiente" || $estado == "Pago parcial") {
                $Pendientes += 1;
            } else {
                $Pagados += 1;
            }

        }
        foreach ($Pagos as $P) {
            $importe_restante = $this->Pagos->GetImporteRestante($P["id_factura_proveedor"], $P["importe"]);

            $Pendiente_pago += $importe_restante;

        }
        $Metodos = $this->Pagos->GetListMetodos();
        $Proveedores = $this->Pagos->GetListProveedores();        //

        $User_Count = $this->Users->_GetUsersCount();

        $User_List = $this->Users->_GetUsersList();

        require_once __VIEWS__ . 'header.template.php';

        //Load the Profile Page Template
        require_once __VIEWS__ . 'pago_a_proveedores.template.php';

        //Load the Footer Template
        require_once __VIEWS__ . 'footer.template.php';
    }

}