<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

require_once __LIBRARIES__ . 'anti_csrf.class.php';

require 'vendor/autoload.php';
//Include clientes Model

require_once __MODELS__ . 'clientes.model.php';

class _oferta_cumpleanos
{

    private $DBLink;

    private $Profile;

    private $Users;

    private $Sales;

    private $Browser;
    private $MessageBird;
    private $Clientes;

    public function __construct(&$DBLink, $FechaInicio = 0, $FechaFinal = 0)
    {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->Users = new _UsersModel($this->DBLink);

        $this->Clientes = new _ClientesModel($this->DBLink);

        //Logout Function or Invalid Session
        $personalizacion = json_decode(file_get_contents('personalizacion.json'), true);
        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

            $this->Users->_Logout();

            header('Location: ./login');

            exit();

        }
        if (isset($_POST['fecha_inicio']) && isset($_POST['fecha_final'])) {
            $FechaInicio = $_POST['fecha_inicio'];
            $FechaFinal = $_POST['fecha_final'];
        }

        $Clientes_Count = $this->Clientes->GetClientesCount();

        $Clientes_List = $this->Clientes->GetListClientes();

        $SMS_List = $this->Clientes->GetListSMS($FechaInicio, $FechaFinal);

        $Envios = 0;
        foreach ($SMS_List as $S) {
            if ($S["estado"] == "Cumple") {
                $Envios++;
            }
        }
        if (isset($_POST['id_sms_eliminar'])) {

            $EliminarSMS = $this->Clientes->EliminarSMS($_POST['id_sms_eliminar']);

        }
        if (isset($_POST['id_cliente_tags']) && isset($_POST['tags'])) {

            $SetClientTags = $this->Clientes->SetClientTags($_POST['id_cliente_tags'], $_POST['tags']);

        }
        if (isset($_POST['id_cliente_habilitar'])) {

            $HabilitarSMS = $this->Clientes->HabilitarSMS($_POST['id_cliente_habilitar']);

        }
        if (isset($_POST['id_cliente_deshabilitar'])) {

            $DeshabilitarSMS = $this->Clientes->DeshabilitarSMS($_POST['id_cliente_deshabilitar']);

        }
        if (isset($_POST['accion'])) {
            if ($_POST['accion'] == "activar") {
                foreach ($Clientes_List as $Cliente) {
                    $this->Clientes->HabilitarSMS($Cliente['client_id']);
                }
            } else {
                foreach ($Clientes_List as $Cliente) {
                    $this->Clientes->DeshabilitarSMS($Cliente['client_id']);
                }
            }

        }

        if (isset($_POST['hora_oferta_cumpleanos'])) {
            $personalizacion['hora_oferta_cumpleanos'] = $_POST['hora_oferta_cumpleanos'];
            $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);
            file_put_contents('personalizacion.json', $personalizacionEncoded);
        }
        if (isset($_POST['zona_oferta_cumpleanos'])) {
            $personalizacion['zona_oferta_cumpleanos'] = $_POST['zona_oferta_cumpleanos'];
            $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);
            file_put_contents('personalizacion.json', $personalizacionEncoded);
        }
        if (isset($_POST['mensaje_oferta_cumpleanos'])) {
            $personalizacion['mensaje_oferta_cumpleanos'] = $_POST['mensaje_oferta_cumpleanos'];
            $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);
            file_put_contents('personalizacion.json', $personalizacionEncoded);
        }
        //Get this User Information

        $User_Data = $this->Users->_GetUserData();

        //$User_Data['user_id']

        //$User_Data['user_role']

        //$User_Data['user_origin']

        //$User_Data['user_referrer']

        //$User_Data['user_email']

        //$User_Data['user_password']

        //$User_Data['user_purchases']

        //$User_Data['user_bonuses']

        //$User_Data['user_referrals']

        //$User_Data['user_tokens']

        //$User_Data['user_oneups']

        //$User_Data['user_address']

        //$User_Data['user_avatar']

        //$User_Data['user_code']

        //$User_Data['user_last_seen']

        //$User_Data['user_first_seen']

        //Check the User Permissions

        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != null) {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

        }
        if (!in_array('ofertacumpleanos', $permisos, true)) {
            header('Location: ./login');
            exit();
        }

        require_once __VIEWS__ . 'header.template.php';

        //Load the Profile Page Template

        require_once __VIEWS__ . 'oferta_cumpleanos.template.php';

        //Load the Footer Template

        require_once __VIEWS__ . 'footer.template.php';

    }

}