<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {

    

    exit();
}

require_once __LIBRARIES__ . 'anti_csrf.class.php';

require_once __MODELS__ . 'presupuestos.model.php';

require_once __MODELS__ . 'albaranes.model.php';

require_once __MODELS__ . 'mailer.model.php';

require_once __MODELS__ . 'pdf.model.php';

require_once __LIBRARIES__ . 'dompdf/autoload.inc.php';

require_once __MODELS__ . 'clientes.model.php';

require_once __MODELS__ . 'facturas.model.php';

require_once __MODELS__ . 'pagos.model.php';

require_once __MODELS__ . 'facturamanual.model.php';

require_once __MODELS__ . 'productosyservicios.model.php';

require_once __ROOT__  . '/vendor/autoload.php';

use chillerlan\QRCode\QRCode;

use chillerlan\QRCode\QROptions;

use Dompdf\Dompdf;

use Dompdf\Options;

class _mailer

{

    private $DBLink;

    private $Profile;

    private $Facturas;

    private $Users;

    private $Pagos;

    private $Sales;

    private $Browser;

    private $Pdf;

    private $Clientes;

    private $Presupuestos;

    private $Albaranes;

    private $Mailer;

    private $FacturaManual;

    private $PyS;

    public function __construct(&$DBLink)

    {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {

            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->FacturaManual = new _FacturaManualModel($this->DBLink);

        $this->Users = new _UsersModel($this->DBLink);

        $this->Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

        $this->Pagos = new _PagosModel($this->DBLink);

        $this->Clientes = new _ClientesModel($this->DBLink);

        $this->Presupuestos = new _PresupuestosModel($this->DBLink);

        $this->Albaranes = new _AlbaranesModel($this->DBLink);

        //Logout Function or Invalid Session

        $this->Facturas = new _FacturasModel($this->DBLink);

        $this->PyS = new _ProductosyserviciosModel($this->DBLink);

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        if (isset($_POST['mensaje_2']) && isset($_POST['client_id_2']) && isset($_POST['asunto_2'])) {
            $email = $this->Clientes->GetClienteEmail($_POST['client_id_2']);
            $cliente = $this->Clientes->GetCliente($_POST['client_id_2']);
            $clie = $_POST['client_id_2'];
            if ($email != null) {
                $mensaje = $_POST['mensaje_2'];

                $nombre = explode(' ', $cliente["nombre"])[0];
                $nombreyapellido = $cliente["nombre"];
                $fechadehoy = date('d/m/Y');

                $mensaje = str_replace('%nombre%', $nombre, $mensaje);

                $mensaje = str_replace('%nombreyapellido%', $nombreyapellido, $mensaje);
                $mensaje = str_replace('%fechadehoy%', $fechadehoy, $mensaje);
                $mensaje = str_replace('%client_id%', $clie, $mensaje);
                $mensaje = str_replace('%url%', WEBSITE_URL, $mensaje);

                if (isset($_FILES['archivos'])) {
                    $archivos = $_FILES['archivos'];

                    $EnviarEmail = $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $email, $_POST['asunto_2'], $mensaje, APP_NAME, "Cliente", $archivos, true, true);
                } else {

                    $EnviarEmail = $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $email, $_POST['asunto_2'], $mensaje, APP_NAME, "Cliente");
                }

                // $this->Clientes->CreateEnvioEmail($_POST['client_id_2'], "Enviado");
                header("HTTP/1.1 200 OK");

                echo json_encode($EnviarEmail);
                exit();
            }
            //  $this->Clientes->CreateEnvioEmail($_POST['client_id_2'], "Email faltante");
            header("HTTP/1.1 200 OK");
            echo json_encode("No");
            exit();
        }

        //EMAIL MARKETING

        if (isset($_POST['mensaje']) && isset($_POST['mail']) && isset($_POST['asunto'])) {

            if (isset($_FILES['archivos'])) {

                $archivos = $_FILES['archivos'];

                $EnviarEmail = $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $_POST['mail'], $_POST['asunto'], $_POST['mensaje'], APP_NAME, "Cliente", $archivos, true, true);
            } else {

                $EnviarEmail = $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $_POST['mail'], $_POST['asunto'], $_POST['mensaje'], APP_NAME, "Cliente");
            }

            header("HTTP/1.1 200 OK");

            echo json_encode($EnviarEmail);

            exit();
        }

        if (isset($_POST['subvencion']) && isset($_POST['email'])) {

            $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $_POST['email'], "Asunto", $_POST['subvencion']);

            if (isset($_POST['id_cliente'])) {

                $this->Clientes->SetEstadoCliente($_POST['id_cliente'], 'Potencial');
            }

            if (isset($_POST['id_cliente_subvencion']) && isset($_POST['fecha_envio'])) {

                $this->Users->SetEstadoSubvencionEnviada($_POST['id_cliente_subvencion'], 'Enviado');

                $this->Clientes->setFechaClienteSubvencion($_POST['id_cliente_subvencion'], $_POST['fecha_envio']);
            }
        }

        if (isset($_POST['id_presupuesto_enviar'])) {

            $Presupuesto = $this->Presupuestos->GetPresupuesto($_POST['id_presupuesto_enviar']);

            $fileatt = $this->ArmarPDFPresupuesto($_POST['id_presupuesto_enviar']);

            $nombre = "Presupuesto";

            echo $nombre;

            echo $this->Mailer->_Mail(

                EMAIL_VALIDATE_USERNAME,

                $Presupuesto["email"],

                $personalizacion['cabecera_email_presupuesto'],

                $personalizacion['cuerpo_email_presupuesto'],

                APP_NAME,

                "Cliente",

                $fileatt,

                true,

                true,

                $nombre,

                ".pdf"

            );

            $this->Presupuestos->ReenviarPresupuesto($_POST['id_presupuesto_enviar']);

            exit();
        }
        if (isset($_POST['id_presupuesto_materiales_enviar'])) {

            $Presupuesto = $this->Presupuestos->GetPresupuestoMaterial($_POST['id_presupuesto_materiales_enviar']);

            $fileatt = $this->ArmarPDFPresupuestoMateriales($_POST['id_presupuesto_materiales_enviar']);

            $nombre = "Presupuesto";



            echo $this->Mailer->_Mail(

                EMAIL_VALIDATE_USERNAME,

                $Presupuesto["email"],

                $personalizacion['cabecera_email_presupuesto'],

                $personalizacion['cuerpo_email_presupuesto'],

                APP_NAME,

                "Cliente",

                $fileatt,

                true,

                true,

                $nombre,

                ".pdf"

            );



            exit();
        }
        if (isset($_POST['id_albaran_enviar'])) {

            $Albaran = $this->Albaranes->GetAlbaran($_POST['id_albaran_enviar']);

            $fileatt = $this->ArmarPDFAlbaran($_POST['id_albaran_enviar']);

            $nombre = "Albaran";

            echo $nombre;

            echo $this->Mailer->_Mail(

                EMAIL_VALIDATE_USERNAME,

                $Albaran["email"],

                $personalizacion['cabecera_email_albaran'],

                $personalizacion['cuerpo_email_albaran'],

                APP_NAME,

                "Cliente",

                $fileatt,

                true,

                true,

                $nombre,

                ".pdf"

            );

            $this->Albaranes->ReenviarAlbaran($_POST['id_albaran_enviar']);

            exit();
        }

        if (isset($_POST['id_compra_enviar'])) {

            $Compra = $this->PyS->GetCompra($_POST['id_compra_enviar']);

            $fileatt = $this->ArmarPDFCompra($_POST['id_compra_enviar']);

            $Cliente = $this->Clientes->GetCliente($Compra['client_id']);

            echo $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $Cliente["email"], "Le enviamos su ticket", "Le enviamos el ticket correspondiente a su compra", APP_NAME, "Cliente", $fileatt, true, true);

            exit();
        }

        if (isset($_POST['id_factura_enviar_multiples']) && isset($_POST['email'])) {

            $Factura = $this->Facturas->GetFactura($_POST['id_factura_enviar_multiples']);

            //$fileatt = $this->ArmarPDFFactura($_POST['id_factura_enviar_multiples']);

            //echo $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $_POST['email'], $personalizacion['cabecera_email_factura'], $personalizacion['cuerpo_email_factura'], APP_NAME, "Cliente", $fileatt, true, true);

            exit();
        }

        if (isset($_POST['id_presupuesto_enviar_multiples']) && isset($_POST['email'])) {

            $Presupuesto = $this->Presupuestos->GetPresupuesto($_POST['id_presupuesto_enviar_multiples']);

            $fileatt = $this->ArmarPDFPresupuesto($_POST['id_presupuesto_enviar_multiples']);

            echo $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, $_POST['email'], $personalizacion['cabecera_email_presupuesto'], $personalizacion['cuerpo_email_presupuesto'], APP_NAME, "Cliente", $fileatt, true, true);

            exit();
        }

        if (isset($_POST['id_factura_manual_enviar'])) {

            $Factura = $this->FacturaManual->GetFacturaManual($_POST['id_factura_manual_enviar']);

            $fileatt = $this->ArmarPDFFacturaManual($_POST['id_factura_manual_enviar']);

            $nombre = "Factura";

            echo $this->Mailer->_Mail(

                EMAIL_VALIDATE_USERNAME,

                $Factura["email"],

                $personalizacion['cabecera_email_factura'],

                $personalizacion['cuerpo_email_factura'],

                APP_NAME,

                "Cliente",

                $fileatt,

                true,

                true,

                $nombre,

                ".pdf"

            );

            $this->FacturaManual->EnviarFacturaManual($_POST['id_factura_manual_enviar']);

            exit();
        }

        if (isset($_POST['id_presupuesto_descargar'])) {

            echo $this->DescargarPDFPresupuesto($_POST['id_presupuesto_descargar']);

            exit();
        }
        if (isset($_POST['id_evento_presupuesto_materiales_descargar'])) {

            echo $this->DescargarPDFPresupuestoMateriales($_POST['id_evento_presupuesto_materiales_descargar']);

            exit();
        }
        if (isset($_POST['id_evento_factura_materiales_descargar'])) {

            echo $this->DescargarPDFFacturasMateriales($_POST['id_evento_factura_materiales_descargar']);

            exit();
        }
        if (isset($_POST['id_albaran_descargar'])) {

            echo $this->DescargarPDFAlbaran($_POST['id_albaran_descargar']);

            exit();
        }

        if (isset($_POST['id_compra_descargar'])) {

            echo $this->DescargarPDFCompra($_POST['id_compra_descargar']);

            exit();
        }

        if (isset($_POST['descargar_anexo'])) {

            echo $this->DescargarPDFAnexo();

            exit();
        }

        if (isset($_POST['id_factura_descargar'])) {

            //     echo $this->DescargarPDFFactura($_POST['id_factura_descargar']);

            exit();
        }

        if (isset($_POST['id_factura_manual_descargar'])) {

            echo $this->DescargarPDFFacturaManual($_POST['id_factura_manual_descargar']);

            exit();
        }
    }

    public function safeHtmlEntities($value)
    {

        return htmlentities($value ?? '', ENT_QUOTES);
    }
    public function DescargarPDFFacturasMateriales($id)

    {


        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Presupuesto = $this->Presupuestos->GetFacturaMateriales2($id);

        $Cliente = $this->Clientes->GetCliente($Presupuesto['client_id']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/factura_manual_materiales.html');

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);
        $imagen = $Presupuesto['imagen'];

        if (substr($imagen, 0, 2) === "./") {
            $imagen = WEBSITE_URL .  substr($imagen, 1); // quita solo el punto
        }

        $Newsletter = str_replace("%imagen%", $this->safeHtmlEntities($imagen), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_factura%", $this->safeHtmlEntities($Presupuesto['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Presupuesto['fecha']));

        $Newsletter = str_replace("%fecha_factura%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        $Newsletter = str_replace("%lugar_factura_view%", "none", $Newsletter);

        $Newsletter = str_replace("%lugar_factura%", "Ninguna", $Newsletter);



        if ($Presupuesto['titulo'] != null) {

            $Newsletter = str_replace("%titulo_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_factura%", $this->safeHtmlEntities($Presupuesto['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_factura%", "Ninguna", $Newsletter);
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        $detallado = '';

        $igic = 0.00;
        $base_sin_descuento = 0.00;
        $total_descuento = 0.00;
        $impuesto = "";
        $descuento_global = 0.00;
        $total_total = 0.00;
        $subtotal_total = 0.00;

        $base_con_descuento_individual = 0.00;
        if ($Presupuesto['descuento'] != null) {

            $descuento_global = floatval($Presupuesto['descuento']) / 100;
        }
        foreach ($Presupuesto['detallado']  as $apartado) {
            $dias = floatval($apartado["dias"]);
            $cantidad = floatval($apartado["cantidad"]);
            $precio_unitario = floatval($apartado["precio_unitario"]);
            $descuento = floatval($apartado["descuento"]) / 100;
            $igic_percent = floatval($apartado["igic"]) / 100;

            $subtotal = $dias * $cantidad * $precio_unitario;
            $descuento_monto = $subtotal * $descuento;
            $descuento_monto_global = ($subtotal - $descuento_monto)  * $descuento_global;
            $subtotal_con_descuento = $subtotal - $descuento_monto - $descuento_monto_global;
            $igic_aplicado = $subtotal_con_descuento * $igic_percent;
            $total_linea = $subtotal_con_descuento + $igic_aplicado;
            $total_total += $total_linea;
            // Sumar totales
            $base_sin_descuento += $subtotal;
            $base_con_descuento_individual += $subtotal - $descuento_monto;
            $total_descuento += $descuento_monto + $descuento_monto_global;
            $subtotal_total += $subtotal_con_descuento; // <-- suma el subtotal sin IGIC ni IRPF

            $igic += $igic_aplicado;


            $detallado .= '<tr>';
            $detallado .= '<td style="text-align:left;">' . $apartado["descripcion"] . '</td>';
            $detallado .= '<td style="text-align:left;">' . $apartado["cantidad"] . '</td>';
            $detallado .= '<td style="text-align:left;">' . $apartado["dias"] . '</td>';
            $detallado .= '<td style="text-align:left;">' . sprintf("%.2f", $precio_unitario) . '€</td>';
            $detallado .= '<td style="text-align:left;">' . sprintf("%.2f", $apartado["igic"]) . '%</td>';
            $detallado .= '<td style="text-align:left;">' . sprintf("%.2f", $apartado["descuento"]) . '%</td>';
            $detallado .= '<td style="text-align:left;">' . sprintf("%.2f", $total_linea) . '€</td>';
            $detallado .= '</tr>';
            if (floatval($apartado["descuento"]) > 0 || floatval($apartado["igic"]) > 0) {

                $d = sprintf('%.2f', $descuento_monto);
                $dd = $apartado['descuento'];
                $d2 = sprintf('%.2f', $igic_aplicado);
                $dd2 = $apartado['igic'];
                $impuesto .= '<tr>
                <td class="table-cell">' . sprintf("%.2f", $subtotal) . '€</td>
                                <td class="table-cell">' . $dd . '%</td>
                                <td class="table-cell">' . $d . '€ </td>
                            <td class="table-cell">' . $dd2 . '%</td>
                                <td class="table-cell">' . $d2  . '€ </td>
                            </tr>';
            }
        }
        
        $irpf_percent = $Presupuesto['irpf'] !== null ? floatval($Presupuesto['irpf']) / 100 : 0;
        $irpf_monto = $subtotal_total * $irpf_percent;
        $total_total_final = $subtotal_total - $irpf_monto + $igic;

        $Newsletter = str_replace("%base_sin_descuento%", $this->formatearNumero(sprintf("%.2f", $base_sin_descuento)), $Newsletter);
        $Newsletter = str_replace("%total_descuento%", $this->formatearNumero(sprintf("%.2f", $total_descuento)), $Newsletter);
        $descuento_general = '<tr>
                <td class="table-cell">' . sprintf("%.2f", $base_con_descuento_individual) . '€</td>
                <td class="table-cell">' . sprintf("%.2f", $Presupuesto["descuento"]) . '%</td>
                <td class="table-cell">' . sprintf("%.2f", $base_con_descuento_individual * $descuento_global) . '€ </td>
                            
                            </tr>';
        $Newsletter = str_replace("%descuento_general%",  $descuento_general   , $Newsletter);
        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);
        $Newsletter = str_replace("%impuestos%", $impuesto, $Newsletter);
        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Cliente['nombre']), $Newsletter);
        if($Presupuesto['banco'] = null){$pagos = '<tr>
                <td class="table-cell">2025/07/09'  . ' </td>
                <td class="table-cell">Transferencia bancaria'  . ' </td>
                                <td class="table-cell">' .  $Presupuesto["banco"]["iban"]  . ' </td>
                                <td class="table-cell">' . sprintf("%.2f", $total_total_final) . '€ </td>
                            
                            </tr>';
        }else{
        $pagos = '<tr>
                <td class="table-cell"> '  . ' </td>
                <td class="table-cell"> '  . ' </td>
                                <td class="table-cell">' .    ' </td>
                                <td class="table-cell">' . '  </td>
                            
                            </tr>';
        }
        $Newsletter = str_replace("%pagos%", $pagos, $Newsletter);
        if ($Presupuesto['direccion'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Presupuesto['direccion']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        $Newsletter = str_replace("%obra_cliente_view%", "none", $Newsletter);

        $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Presupuesto['email']), $Newsletter);

        $Newsletter = str_replace("%sector_cliente_view%", "none", $Newsletter);

        $Newsletter = str_replace("%fase_cliente_view%", "none", $Newsletter);
        $Newsletter = str_replace("%evento_factura%", $this->safeHtmlEntities($Presupuesto['nombre_evento']), $Newsletter);
        $Newsletter = str_replace("%localizacion_evento%", $this->safeHtmlEntities($Presupuesto['localizacion_evento']), $Newsletter);
        if ($Presupuesto['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Presupuesto['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Presupuesto['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Presupuesto['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Presupuesto['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="font-size: 15px;margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_factura%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%subtotal_factura%", $this->formatearNumero(sprintf("%.2f", $subtotal_total)), $Newsletter);

        $Newsletter = str_replace("%total_factura%", $this->formatearNumero(sprintf("%.2f", $total_total_final)), $Newsletter);


        $Newsletter = str_replace("%total_impuesto_factura%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        if ($Presupuesto['irpf'] != null) {

            $Newsletter = str_replace("%irpf_factura%", $this->safeHtmlEntities($Presupuesto['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_factura%", $this->formatearNumero(sprintf("%.2f", $irpf_monto)), $Newsletter);


            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_factura%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_factura%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }
        $qrCodeContent = $Presupuesto['id_factura_manual_materiales'] . '_' . $Presupuesto['numero'];

        // Configuración del QR (opcional)

        $options = new QROptions([

            'version'    => 6,

            'eccLevel'   => QRCode::ECC_L,

            'outputType' => QRCode::OUTPUT_IMAGE_PNG,

            'imageBase64' => false, // No convertir a Base64, solo guardarlo como archivo

        ]);

        // Crea el objeto QR

        $qrCode = new QRCode($options);

        $hash = hash('sha256', $qrCodeContent);

        $qrCodeContentWithHash = WEBSITE_URL  . "verifactu?hash=" . $hash . "&id_factura_materiales=" . $Presupuesto['id_factura_manual_materiales'];

        // Guarda el código QR en un archivo

        $qrFilePath = __DIR__ . '/qrcode.png'; // Especifica la ruta donde guardar el archivo

        $qrCode->render($qrCodeContentWithHash, $qrFilePath); // Guarda el archivo QR

        // Incrustamos el QR en el HTML

        $qrCodeBase64 = base64_encode(file_get_contents($qrFilePath)); // Codificamos el archivo QR en Base64

        // Reemplazamos el marcador %qr_code% con el código QR en HTML

        $Newsletter = str_replace("%qr_code%", '<img style="width:100px; height:100px;" src="data:image/png;base64,' . $qrCodeBase64 . '" />', $Newsletter);


        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        //$pdf->set_paper("A4", "portrait");
        //$pdf->setPaper(array(0, 0, 595.28, 841.89));
        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $nombre = "Factura_" . str_replace('/', '_', str_replace(' ', '_', $Presupuesto['numero'])) . ".pdf";

        $file_to_save = "facturas/" . $nombre;

        $files = glob('facturas/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        return $file_to_save;
    }
    public function ArmarPDFCompra($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Compra = $this->PyS->GetCompra($id);

        // $Cliente = $this->Clientes->GetCliente($Compra['client_id']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/ticket.html');

        $Newsletter = str_replace("%img%", $this->safeHtmlEntities($personalizacion['url_logo_portada']), $Newsletter);

        $fecha_hora = $Compra['fecha'];

        // Convertir la fecha y hora al formato deseado

        $fecha_formateada = date("d/m/Y", strtotime($fecha_hora)); // Fecha en formato dd/mm/yyyy

        $hora_formateada = date("h:i A", strtotime($fecha_hora)); // Hora en formato hh:mm AM/PM

        $Newsletter = str_replace("%fecha%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $Newsletter = str_replace("%hora%", $this->safeHtmlEntities($hora_formateada), $Newsletter);

        $Newsletter = str_replace("%importe%", $this->safeHtmlEntities($this->formatearNumero($Compra['importe'])), $Newsletter);

        $Newsletter = str_replace("%numero%", $this->safeHtmlEntities($Compra['numero']), $Newsletter);

        $Newsletter = str_replace("%igic%", $this->safeHtmlEntities($this->formatearNumero($Compra['igic'])), $Newsletter);

        $Newsletter = str_replace("%igic_val%", $this->safeHtmlEntities($this->formatearNumero(sprintf("%.2f", ($Compra["igic"] * explode(" ", trim($Compra["importe"]))[0])))), $Newsletter);

        $Usuario = ($Compra['user_id'] != null) ? $this->Users->_GetUserData($Compra['user_id'])["user_full_name"] : "Ningún responsable seleccionado";

        $Newsletter = str_replace("%importe_final%", $this->safeHtmlEntities($this->formatearNumero($Compra['importe_final'])), $Newsletter);

        $Newsletter = str_replace("%nombre_comercial%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%cif%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%responsable%", $this->safeHtmlEntities($Usuario), $Newsletter);

        $detallado = '';

        foreach (json_decode($Compra['detallado'], true) as $apartado) {

            $detallado .= '<div class="table-row">';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["cantidad"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["nombre"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero($apartado["precio_unitario"]) . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero(sprintf("%.2f", ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]))) . '</div>';

            $detallado .= '</div>';
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        //$Newsletter = str_replace("%total_impuesto_presupuesto%", $this->formatearNumero(sprintf("%.2f", (($Presupuesto['igic'] / 100) * $Presupuesto['importe']))), $Newsletter);

        $options = new Options();

        $options->set('defaultFont', 'courier');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        $paperSize = array(0, 0, 200, 320);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper($paperSize, "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        $fileatt = $pdf->output();

        return $fileatt;
    }

    public function DescargarPDFCompra($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Compra = $this->PyS->GetCompra($id);

        // $Cliente = $this->Clientes->GetCliente($Compra['client_id']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/ticket.html');

        $Newsletter = str_replace("%img%", $this->safeHtmlEntities($personalizacion['url_logo_portada']), $Newsletter);

        $fecha_hora = $Compra['fecha'];

        // Convertir la fecha y hora al formato deseado

        $fecha_formateada = date("d/m/Y", strtotime($fecha_hora)); // Fecha en formato dd/mm/yyyy

        $hora_formateada = date("h:i A", strtotime($fecha_hora)); // Hora en formato hh:mm AM/PM

        $Newsletter = str_replace("%fecha%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $Newsletter = str_replace("%hora%", $this->safeHtmlEntities($hora_formateada), $Newsletter);

        $Newsletter = str_replace("%importe%", $this->safeHtmlEntities($this->formatearNumero($Compra['importe'])), $Newsletter);

        $Newsletter = str_replace("%numero%", $this->safeHtmlEntities($Compra['numero']), $Newsletter);

        $Newsletter = str_replace("%igic%", $this->safeHtmlEntities($this->formatearNumero($Compra['igic'])), $Newsletter);

        $Newsletter = str_replace("%igic_type%", $Compra['igic'] * 100, $Newsletter);

        $Newsletter = str_replace("%igic_val%", $this->safeHtmlEntities($this->formatearNumero(sprintf("%.2f", ($Compra["igic"] * explode(" ", trim($Compra["importe"]))[0])))), $Newsletter);

        $Usuario = ($Compra['user_id'] != null) ? $this->Users->_GetUserData($Compra['user_id'])["user_full_name"] : "Ningún responsable seleccionado";

        $Newsletter = str_replace("%importe_final%", $this->safeHtmlEntities($this->formatearNumero($Compra['importe_final'])), $Newsletter);

        $Newsletter = str_replace("%nombre_comercial%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%cif%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%responsable%", $this->safeHtmlEntities($Usuario), $Newsletter);

        $Newsletter = str_replace("%direccion%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%email%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%web%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $detallado = '';

        foreach (json_decode($Compra['detallado'], true) as $apartado) {

            $detallado .= '<div class="table-row">';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["cantidad"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["nombre"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero($apartado["precio_unitario"]) . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero(sprintf("%.2f", ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]))) . '</div>';

            $detallado .= '</div>';
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        //$Newsletter = str_replace("%total_impuesto_presupuesto%", $this->formatearNumero(sprintf("%.2f", (($Presupuesto['igic'] / 100) * $Presupuesto['importe']))), $Newsletter);

        $options = new Options();

        $options->set('defaultFont', 'courier');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        $paperSize = array(0, 0, 200, 320);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper($paperSize, "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $nombre = "Compra" . str_replace('/', '_', str_replace(' ', '_', $Compra['numero'])) . ".pdf";

        $file_to_save = "presupuestos/" . $nombre;

        $files = glob('presupuestos/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        return $file_to_save;
    }

    public function ArmarPDFPresupuesto($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Presupuesto = $this->Presupuestos->GetPresupuesto($id);

        $Cliente = $this->Clientes->GetCliente($Presupuesto['id_cliente']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/presupuesto.html');

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%imagen%", $this->safeHtmlEntities($Presupuesto['imagen']), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_presupuesto%", $this->safeHtmlEntities($Presupuesto['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Presupuesto['fecha']));

        $Newsletter = str_replace("%fecha_presupuesto%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $Newsletter = str_replace("%nota_presupuesto%", $this->safeHtmlEntities($Presupuesto['nota_externa']), $Newsletter);

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        if ($Presupuesto['lugar'] != null) {

            $Newsletter = str_replace("%lugar_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%lugar_presupuesto%", $this->safeHtmlEntities($Presupuesto['lugar']), $Newsletter);
        } else {

            $Newsletter = str_replace("%lugar_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%lugar_presupuesto%", "Ninguna", $Newsletter);
        }

        if ($Presupuesto['fechas'] != null) {

            $Newsletter = str_replace("%fechas_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%fechas_presupuesto%", $this->safeHtmlEntities($Presupuesto['fechas']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fechas_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%fechas_presupuesto%", "Ninguna", $Newsletter);
        }

        if ($Presupuesto['titulo'] != null) {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", $this->safeHtmlEntities($Presupuesto['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", "Ninguna", $Newsletter);
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        $detallado = '';

        $igic = 0.00;

        foreach (json_decode($Presupuesto['detallado'], true) as $apartado) {

            $igic += $apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100);

            $detallado .= '<tr>';

            $detallado .= '<td style="text-align:center;">' . $apartado["codigo"] . '</td>';

            $detallado .= '<td style="text-align:center;"><h4 style="margin-bottom:0px;text-align:center;">' . $apartado["titulo"] . '</h4><p style="margin:0px;">' . $apartado["descripcion"] . '</p></td>';

            $detallado .= '<td style="text-align:center;">' . $apartado["cantidad"] . '</td>';

            $detallado .= '<td style="text-align:center;">' . $this->formatearNumero($apartado["precio_unitario"]) . '€</td>';

            $detallado .= '<td style="text-align:center;">' . $this->formatearNumero($apartado["igic"]) . '%</td>';

            $detallado .= '<td style="text-align:center;">' . $this->formatearNumero(sprintf("%.2f", (($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]) + ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100))))) . '€</td>';

            $detallado .= '</tr>';
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Cliente['nombre']), $Newsletter);

        if ($Presupuesto['domicilio'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Presupuesto['domicilio']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        if ($Presupuesto['id_obra'] != null) {

            $Newsletter = str_replace("%obra_cliente_view%", "block", $Newsletter);

            $Obra = $this->Presupuestos->GetObra($Presupuesto['id_obra']);

            $Newsletter = str_replace("%obra_cliente%", $this->safeHtmlEntities($Obra['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%obra_cliente_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Presupuesto['email']), $Newsletter);

        if ($Presupuesto['id_sector'] != null) {

            $Newsletter = str_replace("%sector_cliente_view%", "block", $Newsletter);

            $Sector = $this->Presupuestos->GetSector($Presupuesto['id_sector']);

            $Newsletter = str_replace("%sector_cliente%", $this->safeHtmlEntities($Sector['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%sector_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['id_fase'] != null) {

            $Newsletter = str_replace("%fase_cliente_view%", "block", $Newsletter);

            $Fase = $this->Presupuestos->GetFase($Presupuesto['id_fase']);

            $Newsletter = str_replace("%fase_cliente%", $this->safeHtmlEntities($Fase['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fase_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Presupuesto['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Presupuesto['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Presupuesto['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Presupuesto['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_presupuesto%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        if ($Presupuesto['nota_externa'] != null) {

            $Newsletter = str_replace("%nota_view%", "block", $Newsletter);

            $Newsletter = str_replace("%nota_presupuesto%", $this->safeHtmlEntities($Presupuesto['nota_externa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%nota_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%subtotal_presupuesto%", $this->formatearNumero($this->safeHtmlEntities($Presupuesto['importe'])), $Newsletter);

        $Newsletter = str_replace("%total_presupuesto%", $this->formatearNumero($this->safeHtmlEntities($Presupuesto['importe_final'])), $Newsletter);

        $Newsletter = str_replace("%total_impuesto_presupuesto%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        if ($Presupuesto['irpf'] != null) {

            $Newsletter = str_replace("%irpf_presupuesto%", $this->safeHtmlEntities($Presupuesto['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", $this->formatearNumero(sprintf("%.2f", (($Presupuesto['irpf'] / 100) * $Presupuesto['importe']))), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_presupuesto%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper("A4", "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $fileatt = $pdf->output();

        return $fileatt;
    }

    public function DescargarPDFPresupuesto($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Presupuesto = $this->Presupuestos->GetPresupuesto($id);

        $Cliente = $this->Clientes->GetCliente($Presupuesto['id_cliente']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/presupuesto.html');

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%imagen%", $this->safeHtmlEntities($Presupuesto['imagen']), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_presupuesto%", $this->safeHtmlEntities($Presupuesto['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Presupuesto['fecha']));

        $Newsletter = str_replace("%fecha_presupuesto%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        if ($Presupuesto['lugar'] != null) {

            $Newsletter = str_replace("%lugar_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%lugar_presupuesto%", $this->safeHtmlEntities($Presupuesto['lugar']), $Newsletter);
        } else {

            $Newsletter = str_replace("%lugar_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%lugar_presupuesto%", "Ninguna", $Newsletter);
        }

        if ($Presupuesto['fechas'] != null) {

            $Newsletter = str_replace("%fechas_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%fechas_presupuesto%", $this->safeHtmlEntities($Presupuesto['fechas']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fechas_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%fechas_presupuesto%", "Ninguna", $Newsletter);
        }

        if ($Presupuesto['titulo'] != null) {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", $this->safeHtmlEntities($Presupuesto['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", "Ninguna", $Newsletter);
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        $detallado = '';

        $igic = 0.00;

        foreach (json_decode($Presupuesto['detallado'], true) as $apartado) {

            $igic += $apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100);

            $detallado .= '<tr>';

            $detallado .= '<td style="text-align:center;">' . $apartado["codigo"] . '</td>';

            $detallado .= '<td style="text-align:center;"><h4 style="margin-bottom:0px;text-align:center;">' . $apartado["titulo"] . '</h4><p style="margin:0px;">' . $apartado["descripcion"] . '</p></td>';

            $detallado .= '<td style="text-align:center;">' . $apartado["cantidad"] . '</td>';

            $detallado .= '<td style="text-align:center;">' . $this->formatearNumero($apartado["precio_unitario"]) . '€</td>';

            $detallado .= '<td style="text-align:center;">' . $this->formatearNumero($apartado["igic"]) . '%</td>';

            $detallado .= '<td style="text-align:center;">' . $this->formatearNumero(sprintf("%.2f", (($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]) + ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100))))) . '€</td>';

            $detallado .= '</tr>';
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Cliente['nombre']), $Newsletter);

        if ($Presupuesto['domicilio'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Presupuesto['domicilio']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        if ($Presupuesto['id_obra'] != null) {

            $Newsletter = str_replace("%obra_cliente_view%", "block", $Newsletter);

            $Obra = $this->Presupuestos->GetObra($Presupuesto['id_obra']);

            $Newsletter = str_replace("%obra_cliente%", $this->safeHtmlEntities($Obra['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%obra_cliente_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Presupuesto['email']), $Newsletter);

        if ($Presupuesto['id_sector'] != null) {

            $Newsletter = str_replace("%sector_cliente_view%", "block", $Newsletter);

            $Sector = $this->Presupuestos->GetSector($Presupuesto['id_sector']);

            $Newsletter = str_replace("%sector_cliente%", $this->safeHtmlEntities($Sector['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%sector_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['id_fase'] != null) {

            $Newsletter = str_replace("%fase_cliente_view%", "block", $Newsletter);

            $Fase = $this->Presupuestos->GetFase($Presupuesto['id_fase']);

            $Newsletter = str_replace("%fase_cliente%", $this->safeHtmlEntities($Fase['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fase_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Presupuesto['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Presupuesto['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Presupuesto['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Presupuesto['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_presupuesto%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        if ($Presupuesto['nota_externa'] != null) {

            $Newsletter = str_replace("%nota_view%", "block", $Newsletter);

            $Newsletter = str_replace("%nota_presupuesto%", $this->safeHtmlEntities($Presupuesto['nota_externa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%nota_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%subtotal_presupuesto%", $this->formatearNumero($this->safeHtmlEntities($Presupuesto['importe'])), $Newsletter);

        $Newsletter = str_replace("%total_presupuesto%", $this->formatearNumero($this->safeHtmlEntities($Presupuesto['importe_final'])), $Newsletter);

        $Newsletter = str_replace("%total_impuesto_presupuesto%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        if ($Presupuesto['irpf'] != null) {

            $Newsletter = str_replace("%irpf_presupuesto%", $this->safeHtmlEntities($Presupuesto['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", $this->formatearNumero(sprintf("%.2f", (($Presupuesto['irpf'] / 100) * $Presupuesto['importe']))), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_presupuesto%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper("A4", "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $nombre = "Presupuesto_" . str_replace('/', '_', str_replace(' ', '_', $Presupuesto['numero'])) . ".pdf";

        $file_to_save = "presupuestos/" . $nombre;

        $files = glob('presupuestos/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        return $file_to_save;
    }

    public function ArmarPDFAlbaran($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Albaran = $this->Albaranes->GetAlbaran($id);

        $Cliente = $this->Clientes->GetCliente($Albaran['id_cliente']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/albaran.html');

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%imagen%", WEBSITE_URL . substr($this->safeHtmlEntities($Albaran['imagen']), 2), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_albaran%", $this->safeHtmlEntities($Albaran['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Albaran['fecha']));

        $Newsletter = str_replace("%fecha_albaran%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $Newsletter = str_replace("%nota_albaran%", $this->safeHtmlEntities($Albaran['nota_externa']), $Newsletter);

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        if ($Albaran['lugar'] != null) {

            $Newsletter = str_replace("%lugar_albaran_view%", "block", $Newsletter);

            $Newsletter = str_replace("%lugar_albaran%", $this->safeHtmlEntities($Albaran['lugar']), $Newsletter);
        } else {

            $Newsletter = str_replace("%lugar_albaran_view%", "none", $Newsletter);

            $Newsletter = str_replace("%lugar_albaran%", "Ninguna", $Newsletter);
        }

        if ($Albaran['fechas'] != null) {

            $Newsletter = str_replace("%fechas_albaran_view%", "block", $Newsletter);

            $Newsletter = str_replace("%fechas_albaran%", $this->safeHtmlEntities($Albaran['fechas']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fechas_albaran_view%", "none", $Newsletter);

            $Newsletter = str_replace("%fechas_albaran%", "Ninguna", $Newsletter);
        }

        if ($Albaran['titulo'] != null) {

            $Newsletter = str_replace("%titulo_albaran_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_albaran%", $this->safeHtmlEntities($Albaran['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_albaran_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_albaran%", "Ninguna", $Newsletter);
        }

        $detallado = '';

        $igic = 0.00;

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        foreach (json_decode($Albaran['detallado'], true) as $apartado) {

            $igic += $apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100);

            $detallado .= '<div class="table-row">';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["codigo"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1"><h4 style="margin-bottom:0px;text-align:center;">' . $apartado["titulo"] . '</h4><p style="margin:0px;">' . $apartado["descripcion"] . '</p></div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["cantidad"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero($apartado["precio_unitario"]) . '€</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero($apartado["igic"]) . '%</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero(sprintf("%.2f", (($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]) + ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100))))) . '€</div>';

            $detallado .= '</div>';
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Cliente['nombre']), $Newsletter);

        if ($Albaran['domicilio'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Albaran['domicilio']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        if ($Albaran['id_obra'] != null) {

            $Newsletter = str_replace("%obra_cliente_view%", "block", $Newsletter);

            $Obra = $this->Albaranes->GetObra($Albaran['id_obra']);

            $Newsletter = str_replace("%obra_cliente%", $this->safeHtmlEntities($Obra['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%obra_cliente_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Albaran['email']), $Newsletter);

        if ($Albaran['id_sector'] != null) {

            $Newsletter = str_replace("%sector_cliente_view%", "block", $Newsletter);

            $Sector = $this->Albaranes->GetSector($Albaran['id_sector']);

            $Newsletter = str_replace("%sector_cliente%", $this->safeHtmlEntities($Sector['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%sector_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['id_fase'] != null) {

            $Newsletter = str_replace("%fase_cliente_view%", "block", $Newsletter);

            $Fase = $this->Albaranes->GetFase($Albaran['id_fase']);

            $Newsletter = str_replace("%fase_cliente%", $this->safeHtmlEntities($Fase['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fase_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Albaran['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Albaran['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Albaran['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Albaran['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_albaran%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        if ($Albaran['nota_externa'] != null) {

            $Newsletter = str_replace("%nota_view%", "block", $Newsletter);

            $Newsletter = str_replace("%nota_albaran%", $this->safeHtmlEntities($Albaran['nota_externa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%nota_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%subtotal_albaran%", $this->formatearNumero($this->safeHtmlEntities($Albaran['importe'])), $Newsletter);

        $Newsletter = str_replace("%total_albaran%", $this->formatearNumero($this->safeHtmlEntities($Albaran['importe_final'])), $Newsletter);

        $Newsletter = str_replace("%total_impuesto_albaran%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        if ($Albaran['irpf'] != null) {

            $Newsletter = str_replace("%irpf_albaran%", $this->safeHtmlEntities($Albaran['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_albaran%", $this->formatearNumero(sprintf("%.2f", (($Albaran['irpf'] / 100) * $Albaran['importe']))), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_albaran%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_albaran%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper("A4", "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $fileatt = $pdf->output();

        return $fileatt;
    }

    public function DescargarPDFAlbaran($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Albaran = $this->Albaranes->GetAlbaran($id);

        $Cliente = $this->Clientes->GetCliente($Albaran['id_cliente']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/albaran.html');

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%imagen%", WEBSITE_URL . substr($this->safeHtmlEntities($Albaran['imagen']), 2), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_albaran%", $this->safeHtmlEntities($Albaran['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Albaran['fecha']));

        $Newsletter = str_replace("%fecha_albaran%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['lugar'] != null) {

            $Newsletter = str_replace("%lugar_albaran_view%", "block", $Newsletter);

            $Newsletter = str_replace("%lugar_albaran%", $this->safeHtmlEntities($Albaran['lugar']), $Newsletter);
        } else {

            $Newsletter = str_replace("%lugar_albaran_view%", "none", $Newsletter);

            $Newsletter = str_replace("%lugar_albaran%", "Ninguna", $Newsletter);
        }

        if ($Albaran['fechas'] != null) {

            $Newsletter = str_replace("%fechas_albaran_view%", "block", $Newsletter);

            $Newsletter = str_replace("%fechas_albaran%", $this->safeHtmlEntities($Albaran['fechas']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fechas_albaran_view%", "none", $Newsletter);

            $Newsletter = str_replace("%fechas_albaran%", "Ninguna", $Newsletter);
        }

        if ($Albaran['titulo'] != null) {

            $Newsletter = str_replace("%titulo_albaran_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_albaran%", $this->safeHtmlEntities($Albaran['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_albaran_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_albaran%", "Ninguna", $Newsletter);
        }

        $detallado = '';

        $igic = 0.00;

        foreach (json_decode($Albaran['detallado'], true) as $apartado) {

            $igic += $apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100);

            $detallado .= '<div class="table-row">';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["codigo"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1"><h4 style="margin-bottom:0px;text-align:center;">' . $apartado["titulo"] . '</h4><p style="margin:0px;">' . $apartado["descripcion"] . '</p></div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $apartado["cantidad"] . '</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero($apartado["precio_unitario"]) . '€</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero($apartado["igic"]) . '%</div>';

            $detallado .= '<div class="table-cell" colspan="1">' . $this->formatearNumero(sprintf("%.2f", (($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]) + ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100))))) . '€</div>';

            $detallado .= '</div>';
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Cliente['nombre']), $Newsletter);

        if ($Albaran['domicilio'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Albaran['domicilio']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        if ($Albaran['id_obra'] != null) {

            $Newsletter = str_replace("%obra_cliente_view%", "block", $Newsletter);

            $Obra = $this->Albaranes->GetObra($Albaran['id_obra']);

            $Newsletter = str_replace("%obra_cliente%", $this->safeHtmlEntities($Obra['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%obra_cliente_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Albaran['email']), $Newsletter);

        if ($Albaran['id_sector'] != null) {

            $Newsletter = str_replace("%sector_cliente_view%", "block", $Newsletter);

            $Sector = $this->Albaranes->GetSector($Albaran['id_sector']);

            $Newsletter = str_replace("%sector_cliente%", $this->safeHtmlEntities($Sector['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%sector_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['id_fase'] != null) {

            $Newsletter = str_replace("%fase_cliente_view%", "block", $Newsletter);

            $Fase = $this->Albaranes->GetFase($Albaran['id_fase']);

            $Newsletter = str_replace("%fase_cliente%", $this->safeHtmlEntities($Fase['nombre']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fase_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Albaran['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Albaran['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Albaran['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Albaran['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Albaran['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_albaran%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        if ($Albaran['nota_externa'] != null) {

            $Newsletter = str_replace("%nota_view%", "block", $Newsletter);

            $Newsletter = str_replace("%nota_albaran%", $this->safeHtmlEntities($Albaran['nota_externa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%nota_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%subtotal_albaran%", $this->formatearNumero($this->safeHtmlEntities($Albaran['importe'])), $Newsletter);

        $Newsletter = str_replace("%total_albaran%", $this->formatearNumero($this->safeHtmlEntities($Albaran['importe_final'])), $Newsletter);

        $Newsletter = str_replace("%total_impuesto_albaran%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        if ($Albaran['irpf'] != null) {

            $Newsletter = str_replace("%irpf_albaran%", $this->safeHtmlEntities($Albaran['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_albaran%", $this->formatearNumero(sprintf("%.2f", (($Albaran['irpf'] / 100) * $Albaran['importe']))), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_albaran%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_albaran%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper("A4", "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $nombre = "Albaran_" . str_replace('/', '_', str_replace(' ', '_', $Albaran['numero'])) . ".pdf";

        $file_to_save = "albaranes/" . $nombre;

        $files = glob('albaranes/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        return $file_to_save;
    }

    public function ArmarPDFFacturaManual($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Factura = $this->FacturaManual->GetFacturaManual($id);

        $Cliente = $this->Clientes->GetCliente($Factura['client_id']);

        $Apartados = $this->FacturaManual->GetDetallado($id);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/factura.html');

        $Newsletter = str_replace("%color%", $this->safeHtmlEntities($personalizacion['color_elementos']), $Newsletter);

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%imagen%", $this->safeHtmlEntities($Factura['imagen']), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_factura%", $this->safeHtmlEntities($Factura['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Factura['fecha']));

        $Newsletter = str_replace("%fecha_factura%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        if ($Factura['fecha_vencimiento'] != null) {

            $fecha_formateada = date("Y/m/d", strtotime($Factura['fecha_vencimiento']));

            $Newsletter = str_replace("%fecha_vencimiento_factura%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

            $Newsletter = str_replace("%fecha_factura_display%", "table-cell", $Newsletter);
        } else {

            $Newsletter = str_replace("%fecha_factura_display%", "none", $Newsletter);
        }

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        $detallado = '';

        $igic = 0.00;

        foreach ($Apartados as $apartado) {

            // Calcular el IGIC para cada apartado

            $cantidad = explode(" ", trim($apartado["cantidad"]))[0];

            $precio_total = $apartado["precio_unitario"] * $cantidad;

            $igic_calculado = $precio_total * ($apartado["igic"] / 100);

            $igic += $igic_calculado;

            $total_con_igic = $precio_total + $igic_calculado;

            // Generar las filas de la tabla HTML

            $detallado .= '<tr>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $apartado["codigo"] . '</td>';

            $detallado .= '<td class="table-cell" style="width: 40%; text-align:center;">';

            $detallado .= '<h4 style="margin-bottom:0px; text-align:center;">' . $apartado["titulo"] . '</h4>';

            $detallado .= '<p style="margin:0px; text-align:center;">' . $apartado["descripcion"] . '</p>';

            $detallado .= '</td>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $apartado["cantidad"] . '</td>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $this->formatearNumero($apartado["precio_unitario"]) . '€</td>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $this->formatearNumero($apartado["igic"]) . '%</td>';

            $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $this->formatearNumero(sprintf("%.2f", (($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]) + ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100))))) . '€</td>';

            $detallado .= '</tr>';
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Factura['nombre']), $Newsletter);

        $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Factura['direccion']), $Newsletter);

        if ($Cliente['codigo'] != null) {

            $Newsletter = str_replace("%codigo_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%codigo_cliente%", $this->safeHtmlEntities($Cliente['codigo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%codigo_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%codigo_cliente%", "Ninguna", $Newsletter);
        }

        if ($Factura['lugar'] != null) {

            $Newsletter = str_replace("%lugar_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%lugar_factura%", $this->safeHtmlEntities($Factura['lugar']), $Newsletter);
        } else {

            $Newsletter = str_replace("%lugar_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%lugar_factura%", "Ninguna", $Newsletter);
        }

        if ($Factura['fechas'] != null) {

            $Newsletter = str_replace("%fechas_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%fechas_factura%", $this->safeHtmlEntities($Factura['fechas']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fechas_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%fechas_factura%", "Ninguna", $Newsletter);
        }

        if ($Factura['titulo'] != null) {

            $Newsletter = str_replace("%titulo_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_factura%", $this->safeHtmlEntities($Factura['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_factura%", "Ninguna", $Newsletter);
        }

        if ($Factura['direccion'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Factura['direccion']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        if ($Factura['email'] != null) {

            $Newsletter = str_replace("%email_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Factura['email']), $Newsletter);
        } else {

            $Newsletter = str_replace("%email_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%email_cliente%", "Ninguna", $Newsletter);
        }

        if ($Factura['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Factura['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Factura['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Factura['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Factura['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Factura['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_factura%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        if ($Factura['impuesto'] != null) {

            $Newsletter = str_replace("%impuestos_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Factura['impuesto']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%impuestos_factura%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%impuestos_view%", "none", $Newsletter);
        }

        if ($Factura['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Factura['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco'] != null) {

            $Newsletter = str_replace("%banco_1_view%", "table-row", $Newsletter);

            $Banco = $this->Pagos->GetBanco($Factura['id_banco']);

            $Newsletter = str_replace("%nombre_banco_1%", $this->safeHtmlEntities($Banco['nombre']), $Newsletter);

            $Newsletter = str_replace("%beneficiario_banco_1%", $this->safeHtmlEntities($Banco['beneficiario']), $Newsletter);

            $Newsletter = str_replace("%iban_banco_1%", $this->safeHtmlEntities($Banco['iban']), $Newsletter);

            $Newsletter = str_replace("%swift_banco_1%", $this->safeHtmlEntities($Banco['swift']), $Newsletter);

            $Newsletter = str_replace("%divisa_banco_1%", $this->safeHtmlEntities($Banco['divisa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%banco_1_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco_2'] != null) {

            $Newsletter = str_replace("%banco_2_view%", "table-row", $Newsletter);

            $Banco = $this->Pagos->GetBanco($Factura['id_banco_2']);

            $Newsletter = str_replace("%nombre_banco_2%", $this->safeHtmlEntities($Banco['nombre']), $Newsletter);

            $Newsletter = str_replace("%beneficiario_banco_2%", $this->safeHtmlEntities($Banco['beneficiario']), $Newsletter);

            $Newsletter = str_replace("%iban_banco_2%", $this->safeHtmlEntities($Banco['iban']), $Newsletter);

            $Newsletter = str_replace("%swift_banco_2%", $this->safeHtmlEntities($Banco['swift']), $Newsletter);

            $Newsletter = str_replace("%divisa_banco_2%", $this->safeHtmlEntities($Banco['divisa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%banco_2_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco_3'] != null) {

            $Newsletter = str_replace("%banco_3_view%", "table-row", $Newsletter);

            $Banco = $this->Pagos->GetBanco($Factura['id_banco_3']);

            $Newsletter = str_replace("%nombre_banco_3%", $this->safeHtmlEntities($Banco['nombre']), $Newsletter);

            $Newsletter = str_replace("%beneficiario_banco_3%", $this->safeHtmlEntities($Banco['beneficiario']), $Newsletter);

            $Newsletter = str_replace("%iban_banco_3%", $this->safeHtmlEntities($Banco['iban']), $Newsletter);

            $Newsletter = str_replace("%swift_banco_3%", $this->safeHtmlEntities($Banco['swift']), $Newsletter);

            $Newsletter = str_replace("%divisa_banco_3%", $this->safeHtmlEntities($Banco['divisa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%banco_3_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco'] == null && $Factura['id_banco_2'] == null && $Factura['id_banco_3'] == null) {

            $Newsletter = str_replace("%bancos_view%", "none", $Newsletter);
        } else {

            $Newsletter = str_replace("%bancos_view%", "block", $Newsletter);
        }

        $importe = sprintf("%.2f", ($Factura['importe']));

        $Newsletter = str_replace("%subtotal_factura%", $this->formatearNumero($importe), $Newsletter);

        if ($Cliente["codigo_contable"] != null) {

            $Newsletter = str_replace("%contable_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%contable_factura%", $this->safeHtmlEntities($Cliente["codigo_contable"]), $Newsletter);
        } else {

            $Newsletter = str_replace("%contable_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%contable_factura%", "Ninguna", $Newsletter);
        }

        if ($Cliente["codigo_gestor"] != null) {

            $Newsletter = str_replace("%gestor_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%gestor_factura%", $this->safeHtmlEntities($Cliente["codigo_gestor"]), $Newsletter);
        } else {

            $Newsletter = str_replace("%gestor_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%gestor_factura%", "Ninguna", $Newsletter);
        }

        if ($Cliente["codigo_tramitador"] != null) {

            $Newsletter = str_replace("%tramitadora_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%tramitadora_factura%", $this->safeHtmlEntities($Cliente["codigo_tramitador"]), $Newsletter);
        } else {

            $Newsletter = str_replace("%tramitadora_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%tramitadora_factura%", "Ninguna", $Newsletter);
        }

        $importe = sprintf("%.2f", ($Factura['importe']));

        $Newsletter = str_replace("%subtotal_factura%", $this->formatearNumero($importe), $Newsletter);

        $resto_igic = sprintf("%.2f", (($importe * $igic) / 100));

        $resto_irpf = 0;

        if ($Factura['irpf'] != null) {

            $irpf = $Factura['irpf'];

            $resto_irpf = sprintf("%.2f", (($importe * $irpf) / 100));

            $Newsletter = str_replace("%irpf_factura%", $this->safeHtmlEntities($Factura['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_factura%", $this->formatearNumero($resto_irpf), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_factura%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_factura%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%total_impuesto_factura%", $this->formatearNumero($igic), $Newsletter);

        $total = $this->formatearNumero(sprintf("%.2f", ($importe + $igic - $resto_irpf)));

        $Newsletter = str_replace("%total_factura%", $this->safeHtmlEntities($total), $Newsletter);

        $Newsletter = str_replace("%total_impuesto_factura%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        $total = $this->formatearNumero(sprintf("%.2f", ($importe + $igic - $resto_irpf)));

        $Newsletter = str_replace("%total_factura%", $this->safeHtmlEntities($total), $Newsletter);

        $qrCodeContent = $Factura['id_factura_manual'] . '_' . $Factura['numero'];

        // Configuración del QR (opcional)

        $options = new QROptions([

            'version'    => 6,

            'eccLevel'   => QRCode::ECC_L,

            'outputType' => QRCode::OUTPUT_IMAGE_PNG,

            'imageBase64' => false, // No convertir a Base64, solo guardarlo como archivo

        ]);

        // Crea el objeto QR

        $qrCode = new QRCode($options);

        $hash = hash('sha256', $qrCodeContent);

        $qrCodeContentWithHash = WEBSITE_URL  . "verifactu?hash=" . $hash . "&id=" . $Factura['id_factura_manual'];

        // Guarda el código QR en un archivo

        $qrFilePath = __DIR__ . '/qrcode.png'; // Especifica la ruta donde guardar el archivo

        $qrCode->render($qrCodeContentWithHash, $qrFilePath); // Guarda el archivo QR

        // Incrustamos el QR en el HTML

        $qrCodeBase64 = base64_encode(file_get_contents($qrFilePath)); // Codificamos el archivo QR en Base64

        // Reemplazamos el marcador %qr_code% con el código QR en HTML

        $Newsletter = str_replace("%qr_code%", '<img style="width:100px; height:100px;" src="data:image/png;base64,' . $qrCodeBase64 . '" />', $Newsletter);

        $options = new Options();

        $options->set('defaultFont', 'Dejavu Sans');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper("A4", "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $fileatt = $pdf->output();

        return $fileatt;
    }

    public function DescargarPDFFacturaManual($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Factura = $this->FacturaManual->GetFacturaManual($id);

        $Cliente = $this->Clientes->GetCliente($Factura['client_id']);

        $Apartados = $this->FacturaManual->GetDetallado($id);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/factura.html');

        $Newsletter = str_replace("%color%", $this->safeHtmlEntities($personalizacion['color_elementos']), $Newsletter);

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%imagen%", $this->safeHtmlEntities($Factura['imagen']), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_factura%", $this->safeHtmlEntities($Factura['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Factura['fecha']));

        $Newsletter = str_replace("%fecha_factura%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        if ($Factura['fecha_vencimiento'] != null) {

            $fecha_formateada = date("Y/m/d", strtotime($Factura['fecha_vencimiento']));

            $Newsletter = str_replace("%fecha_vencimiento_factura%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

            $Newsletter = str_replace("%fecha_factura_display%", "table-cell", $Newsletter);
        } else {

            $Newsletter = str_replace("%fecha_factura_display%", "none", $Newsletter);
        }

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        $detallado = '';

        $igic = 0.00;

        foreach ($Apartados as $apartado) {

            // Calcular el IGIC para cada apartado

            $cantidad = explode(" ", trim($apartado["cantidad"]))[0];

            $precio_total = $apartado["precio_unitario"] * $cantidad;

            $igic_calculado = $precio_total * ($apartado["igic"] / 100);

            $igic += $igic_calculado;

            $total_con_igic = $precio_total + $igic_calculado;

            // Generar las filas de la tabla HTML

            $detallado .= '<tr>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $apartado["codigo"] . '</td>';

            $detallado .= '<td class="table-cell" style="width: 40%; text-align:center;">';

            $detallado .= '<h4 style="margin-bottom:0px; text-align:center;">' . $apartado["titulo"] . '</h4>';

            $detallado .= '<p style="margin:0px; text-align:center;">' . $apartado["descripcion"] . '</p>';

            $detallado .= '</td>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $apartado["cantidad"] . '</td>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $this->formatearNumero($apartado["precio_unitario"]) . '€</td>';

            $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $this->formatearNumero($apartado["igic"]) . '%</td>';

            $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $this->formatearNumero(sprintf("%.2f", (($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0]) + ($apartado["precio_unitario"] * explode(" ", trim($apartado["cantidad"]))[0] * ($apartado["igic"] / 100))))) . '€</td>';

            $detallado .= '</tr>';
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Factura['nombre']), $Newsletter);

        $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Factura['direccion']), $Newsletter);

        if ($Cliente['codigo'] != null) {

            $Newsletter = str_replace("%codigo_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%codigo_cliente%", $this->safeHtmlEntities($Cliente['codigo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%codigo_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%codigo_cliente%", "Ninguna", $Newsletter);
        }

        if ($Factura['lugar'] != null) {

            $Newsletter = str_replace("%lugar_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%lugar_factura%", $this->safeHtmlEntities($Factura['lugar']), $Newsletter);
        } else {

            $Newsletter = str_replace("%lugar_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%lugar_factura%", "Ninguna", $Newsletter);
        }

        if ($Factura['fechas'] != null) {

            $Newsletter = str_replace("%fechas_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%fechas_factura%", $this->safeHtmlEntities($Factura['fechas']), $Newsletter);
        } else {

            $Newsletter = str_replace("%fechas_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%fechas_factura%", "Ninguna", $Newsletter);
        }

        if ($Factura['titulo'] != null) {

            $Newsletter = str_replace("%titulo_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_factura%", $this->safeHtmlEntities($Factura['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_factura%", "Ninguna", $Newsletter);
        }

        if ($Factura['direccion'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Factura['direccion']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        if ($Factura['email'] != null) {

            $Newsletter = str_replace("%email_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Factura['email']), $Newsletter);
        } else {

            $Newsletter = str_replace("%email_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%email_cliente%", "Ninguna", $Newsletter);
        }

        if ($Factura['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Factura['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Factura['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Factura['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        if ($Factura['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Factura['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_factura%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        if ($Factura['impuesto'] != null) {

            $Newsletter = str_replace("%impuestos_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Factura['impuesto']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%impuestos_factura%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%impuestos_view%", "none", $Newsletter);
        }

        if ($Factura['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Factura['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco'] != null) {

            $Newsletter = str_replace("%banco_1_view%", "table-row", $Newsletter);

            $Banco = $this->Pagos->GetBanco($Factura['id_banco']);

            $Newsletter = str_replace("%nombre_banco_1%", $this->safeHtmlEntities($Banco['nombre']), $Newsletter);

            $Newsletter = str_replace("%beneficiario_banco_1%", $this->safeHtmlEntities($Banco['beneficiario']), $Newsletter);

            $Newsletter = str_replace("%iban_banco_1%", $this->safeHtmlEntities($Banco['iban']), $Newsletter);

            $Newsletter = str_replace("%swift_banco_1%", $this->safeHtmlEntities($Banco['swift']), $Newsletter);

            $Newsletter = str_replace("%divisa_banco_1%", $this->safeHtmlEntities($Banco['divisa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%banco_1_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco_2'] != null) {

            $Newsletter = str_replace("%banco_2_view%", "table-row", $Newsletter);

            $Banco = $this->Pagos->GetBanco($Factura['id_banco_2']);

            $Newsletter = str_replace("%nombre_banco_2%", $this->safeHtmlEntities($Banco['nombre']), $Newsletter);

            $Newsletter = str_replace("%beneficiario_banco_2%", $this->safeHtmlEntities($Banco['beneficiario']), $Newsletter);

            $Newsletter = str_replace("%iban_banco_2%", $this->safeHtmlEntities($Banco['iban']), $Newsletter);

            $Newsletter = str_replace("%swift_banco_2%", $this->safeHtmlEntities($Banco['swift']), $Newsletter);

            $Newsletter = str_replace("%divisa_banco_2%", $this->safeHtmlEntities($Banco['divisa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%banco_2_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco_3'] != null) {

            $Newsletter = str_replace("%banco_3_view%", "table-row", $Newsletter);

            $Banco = $this->Pagos->GetBanco($Factura['id_banco_3']);

            $Newsletter = str_replace("%nombre_banco_3%", $this->safeHtmlEntities($Banco['nombre']), $Newsletter);

            $Newsletter = str_replace("%beneficiario_banco_3%", $this->safeHtmlEntities($Banco['beneficiario']), $Newsletter);

            $Newsletter = str_replace("%iban_banco_3%", $this->safeHtmlEntities($Banco['iban']), $Newsletter);

            $Newsletter = str_replace("%swift_banco_3%", $this->safeHtmlEntities($Banco['swift']), $Newsletter);

            $Newsletter = str_replace("%divisa_banco_3%", $this->safeHtmlEntities($Banco['divisa']), $Newsletter);
        } else {

            $Newsletter = str_replace("%banco_3_view%", "none", $Newsletter);
        }

        if ($Factura['id_banco'] == null && $Factura['id_banco_2'] == null && $Factura['id_banco_3'] == null) {

            $Newsletter = str_replace("%bancos_view%", "none", $Newsletter);
        } else {

            $Newsletter = str_replace("%bancos_view%", "block", $Newsletter);
        }

        if ($Cliente["codigo_contable"] != null) {

            $Newsletter = str_replace("%contable_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%contable_factura%", $this->safeHtmlEntities($Cliente["codigo_contable"]), $Newsletter);
        } else {

            $Newsletter = str_replace("%contable_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%contable_factura%", "Ninguna", $Newsletter);
        }

        if ($Cliente["codigo_gestor"] != null) {

            $Newsletter = str_replace("%gestor_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%gestor_factura%", $this->safeHtmlEntities($Cliente["codigo_gestor"]), $Newsletter);
        } else {

            $Newsletter = str_replace("%gestor_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%gestor_factura%", "Ninguna", $Newsletter);
        }

        if ($Cliente["codigo_tramitador"] != null) {

            $Newsletter = str_replace("%tramitadora_factura_view%", "block", $Newsletter);

            $Newsletter = str_replace("%tramitadora_factura%", $this->safeHtmlEntities($Cliente["codigo_tramitador"]), $Newsletter);
        } else {

            $Newsletter = str_replace("%tramitadora_factura_view%", "none", $Newsletter);

            $Newsletter = str_replace("%tramitadora_factura%", "Ninguna", $Newsletter);
        }

        $importe = sprintf("%.2f", ($Factura['importe']));

        $Newsletter = str_replace("%subtotal_factura%", $this->formatearNumero($importe), $Newsletter);

        $resto_igic = sprintf("%.2f", (($importe * $igic) / 100));

        $resto_irpf = 0;

        if ($Factura['irpf'] != null) {

            $irpf = $Factura['irpf'];

            $resto_irpf = sprintf("%.2f", (($importe * $irpf) / 100));

            $Newsletter = str_replace("%irpf_factura%", $this->safeHtmlEntities($Factura['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_factura%", $this->formatearNumero($resto_irpf), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_factura%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_factura%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%total_impuesto_factura%", $this->formatearNumero($igic), $Newsletter);

        $total = $this->formatearNumero(sprintf("%.2f", ($importe + $igic - $resto_irpf)));

        $Newsletter = str_replace("%total_factura%", $this->safeHtmlEntities($total), $Newsletter);

        $qrCodeContent = $Factura['id_factura_manual'] . '_' . $Factura['numero'];

        // Configuración del QR (opcional)

        $options = new QROptions([

            'version'    => 6,

            'eccLevel'   => QRCode::ECC_L,

            'outputType' => QRCode::OUTPUT_IMAGE_PNG,

            'imageBase64' => false, // No convertir a Base64, solo guardarlo como archivo

        ]);

        // Crea el objeto QR

        $qrCode = new QRCode($options);

        $hash = hash('sha256', $qrCodeContent);

        $qrCodeContentWithHash = WEBSITE_URL  . "verifactu?hash=" . $hash . "&id=" . $Factura['id_factura_manual'];

        // Guarda el código QR en un archivo

        $qrFilePath = __DIR__ . '/qrcode.png'; // Especifica la ruta donde guardar el archivo

        $qrCode->render($qrCodeContentWithHash, $qrFilePath); // Guarda el archivo QR

        // Incrustamos el QR en el HTML

        $qrCodeBase64 = base64_encode(file_get_contents($qrFilePath)); // Codificamos el archivo QR en Base64

        // Reemplazamos el marcador %qr_code% con el código QR en HTML

        $Newsletter = str_replace("%qr_code%", '<img style="width:100px; height:100px;" src="data:image/png;base64,' . $qrCodeBase64 . '" />', $Newsletter);

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper("A4", "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $nombre = "Factura_" . str_replace('/', '_', str_replace(' ', '_', $Factura['numero'])) . ".pdf";

        $file_to_save = "facturas/" . $nombre;

        $files = glob('facturas/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        return $file_to_save;
    }

    public function formatearNumero($cadena)

    {

        // Reemplazar la coma por el punto para asegurar el formato numérico correcto

        $cadena = str_replace(',', '.', $cadena);

        // Separar la parte entera de la decimal

        $partes = explode('.', $cadena);

        $parteEntera = $partes[0];

        $parteDecimal = isset($partes[1]) ? $partes[1] : '';

        // Formatear la parte entera con separadores de miles

        $parteEntera = number_format($parteEntera, 0, '', '.');

        // Unir la parte entera y decimal con el formato deseado

        $numeroFormateado = $parteEntera . ',' . $parteDecimal;

        return $numeroFormateado;
    }

    public function DescargarPDFAnexo()

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/factura.html');

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        $pdf->set_paper("A4", "portrait");

        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $nombre = "Anexo.pdf";

        $file_to_save = "anexos/" . $nombre;

        $files = glob('anexos/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        return $file_to_save;
    }

    public function DescargarPDFPresupuestoMateriales($id)

    {


        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Presupuesto = $this->Presupuestos->GetPresupuestoMateriales2($id);

        $Cliente = $this->Clientes->GetCliente($Presupuesto['id_cliente']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/presupuesto_materiales.html');

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $imagen = $Presupuesto['imagen'];

        if (substr($imagen, 0, 2) === "./") {
            $imagen = WEBSITE_URL .  substr($imagen, 1); // quita solo el punto
        }

        $Newsletter = str_replace("%imagen%", $this->safeHtmlEntities($imagen), $Newsletter);


        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_presupuesto%", $this->safeHtmlEntities($Presupuesto['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Presupuesto['fecha']));

        $Newsletter = str_replace("%fecha_presupuesto%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);



        $Newsletter = str_replace("%fechas_presupuesto_view%", "none", $Newsletter);

        $Newsletter = str_replace("%fechas_presupuesto%", "Ninguna", $Newsletter);

        if ($Presupuesto['titulo'] != null) {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", $this->safeHtmlEntities($Presupuesto['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", "Ninguna", $Newsletter);
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        $detallado = '';

        $igic = 0.00;
        $base_sin_descuento = 0.00;
        $total_descuento = 0.00;
        $impuesto = "";
        $descuento_global = 0.00;
  $total_total = 0.00;
        $subtotal_total = 0.00;

        $base_con_descuento_individual = 0.00;
        if ($Presupuesto['descuento'] != null) {

            $descuento_global = floatval($Presupuesto['descuento']) / 100;
        }
        foreach (json_decode($Presupuesto['detallado'], true) as $apartado) {
            $dias = floatval($apartado["dias"]);
            $cantidad = floatval($apartado["cantidad"]);
            $precio_unitario = floatval($apartado["precio_unitario"]);
            $descuento = floatval($apartado["descuento"]) / 100;
            $igic_percent = floatval($apartado["igic"]) / 100;

            $subtotal = $dias * $cantidad * $precio_unitario;
            $descuento_monto = $subtotal * $descuento;
            $descuento_monto_global = ($subtotal - $descuento_monto)  * $descuento_global;
            $subtotal_con_descuento = $subtotal - $descuento_monto - $descuento_monto_global;
            $igic_aplicado = $subtotal_con_descuento * $igic_percent;
            $total_linea = $subtotal_con_descuento + $igic_aplicado;
            $total_total += $total_linea;
            // Sumar totales
            $base_sin_descuento += $subtotal;
            $base_con_descuento_individual += $subtotal - $descuento_monto;
            $total_descuento += $descuento_monto + $descuento_monto_global;
            $subtotal_total += $subtotal_con_descuento; // <-- suma el subtotal sin IGIC ni IRPF

            $igic += $igic_aplicado;


            $detallado .= '<tr>';
            $detallado .= '<td style="text-align:center;">' . $apartado["descripcion"] . '</td>';
            $detallado .= '<td style="text-align:center;">' . $apartado["cantidad"] . '</td>';
            $detallado .= '<td style="text-align:center;">' . $apartado["dias"] . '</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $precio_unitario) . '€</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $apartado["igic"]) . '%</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $apartado["descuento"]) . '%</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $total_linea) . '€</td>';
            $detallado .= '</tr>';
            if (floatval($apartado["descuento"]) > 0 || floatval($apartado["igic"]) > 0) {

                $d = sprintf('%.2f', $descuento_monto);
                $dd = $apartado['descuento'];
                $d2 = sprintf('%.2f', $igic_aplicado);
                $dd2 = $apartado['igic'];
                $impuesto .= '<tr>
 <td class="table-cell">' . sprintf("%.2f", $subtotal) . '€</td>
                <td class="table-cell">' . $dd . '%</td>
                <td class="table-cell">' . $d . '€ </td>
               <td class="table-cell">' . $dd2 . '%</td>
                <td class="table-cell">' . $d2  . '€ </td>
              </tr>';
            }
        }
     
        $irpf_percent = $Presupuesto['irpf'] !== null ? floatval($Presupuesto['irpf']) / 100 : 0;
        $irpf_monto = $subtotal_total * $irpf_percent;
        $total_total_final = $subtotal_total - $irpf_monto + $igic;

        
        $Newsletter = str_replace("%base_sin_descuento%", $this->formatearNumero(sprintf("%.2f", $base_sin_descuento)), $Newsletter);
        $Newsletter = str_replace("%total_descuento%", $this->formatearNumero(sprintf("%.2f", $total_descuento)), $Newsletter);
  $descuento_general = '<tr>
                <td class="table-cell">' . sprintf("%.2f", $base_con_descuento_individual) . '€</td>
                <td class="table-cell">' . sprintf("%.2f", $Presupuesto["descuento"]) . '%</td>
                <td class="table-cell">' . sprintf("%.2f", $base_con_descuento_individual * $descuento_global) . '€ </td>
                            
                            </tr>';
        $Newsletter = str_replace("%descuento_general%",  $descuento_general   , $Newsletter);
        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);
        $Newsletter = str_replace("%impuestos%", $impuesto, $Newsletter);
        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Cliente['nombre']), $Newsletter);

        if ($Presupuesto['domicilio'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Presupuesto['domicilio']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        $Newsletter = str_replace("%obra_cliente_view%", "none", $Newsletter);

        $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Presupuesto['email']), $Newsletter);

        $Newsletter = str_replace("%sector_cliente_view%", "none", $Newsletter);

        $Newsletter = str_replace("%fase_cliente_view%", "none", $Newsletter);
        $Newsletter = str_replace("%evento_presupuesto%", $this->safeHtmlEntities($Presupuesto['nombre_evento']), $Newsletter);
        $Newsletter = str_replace("%localizacion_evento%", $this->safeHtmlEntities($Presupuesto['localizacion_evento']), $Newsletter);
        if ($Presupuesto['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Presupuesto['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Presupuesto['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Presupuesto['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Presupuesto['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_presupuesto%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%subtotal_presupuesto%", $this->formatearNumero($this->safeHtmlEntities(sprintf("%.2f", $subtotal_total))), $Newsletter);

        $Newsletter = str_replace("%total_presupuesto%", $this->formatearNumero($this->safeHtmlEntities(sprintf("%.2f", $total_total_final))), $Newsletter);

        $Newsletter = str_replace("%total_impuesto_presupuesto%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        if ($Presupuesto['irpf'] != null) {

            $Newsletter = str_replace("%irpf_presupuesto%", $this->safeHtmlEntities($Presupuesto['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", $this->formatearNumero(sprintf("%.2f", $irpf_monto)), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_presupuesto%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        //$pdf->set_paper("A4", "portrait");
        //$pdf->setPaper(array(0, 0, 595.28, 841.89));
        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        // Enviamos el fichero PDF al navegador.

        //$pdf->stream('Factura.pdf',array("Attachment" => true));

        $nombre = "Presupuesto_" . str_replace('/', '_', str_replace(' ', '_', $Presupuesto['numero'])) . ".pdf";

        $file_to_save = "presupuestos/" . $nombre;

        $files = glob('presupuestos/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        return $file_to_save;
    }
    /*  public function ArmarPDFPresupuestoMateriales($id)

    {

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $Presupuesto = $this->Presupuestos->GetPresupuestoMateriales2($id);

        $Cliente = $this->Clientes->GetCliente($Presupuesto['id_cliente']);

        $Newsletter = file_get_contents(__ROOT__ . '/emails/presupuesto_materiales.html');

        $Newsletter = str_replace("%cif_comercio%", $this->safeHtmlEntities($personalizacion['cif']), $Newsletter);

        $Newsletter = str_replace("%imagen%", $this->safeHtmlEntities($Presupuesto['imagen']), $Newsletter);

        $Newsletter = str_replace("%direccion_comercio%", $this->safeHtmlEntities($personalizacion['direccion']), $Newsletter);

        $Newsletter = str_replace("%nombre_comercio%", $this->safeHtmlEntities($personalizacion['nombre']), $Newsletter);

        $Newsletter = str_replace("%telefono_comercio%", $this->safeHtmlEntities($personalizacion['telefono']), $Newsletter);

        $Newsletter = str_replace("%email_comercio%", $this->safeHtmlEntities($personalizacion['email']), $Newsletter);

        $Newsletter = str_replace("%fax_comercio%", $this->safeHtmlEntities($personalizacion['fax']), $Newsletter);

        $Newsletter = str_replace("%web_comercio%", $this->safeHtmlEntities($personalizacion['web']), $Newsletter);

        $Newsletter = str_replace("%numero_presupuesto%", $this->safeHtmlEntities($Presupuesto['numero']), $Newsletter);

        $fecha_formateada = date("Y/m/d", strtotime($Presupuesto['fecha']));

        $Newsletter = str_replace("%fecha_presupuesto%", $this->safeHtmlEntities($fecha_formateada), $Newsletter);

        $cifview = ($this->safeHtmlEntities($personalizacion['cif']) != "") ? "block" : "none";

        $direccionview = ($this->safeHtmlEntities($personalizacion['direccion']) != "") ? "block" : "none";

        $nombreview = ($this->safeHtmlEntities($personalizacion['nombre']) != "") ? "block" : "none";

        $telefonoview = ($this->safeHtmlEntities($personalizacion['telefono']) != "") ? "block" : "none";

        $emailview = ($this->safeHtmlEntities($personalizacion['email']) != "") ? "block" : "none";

        $faxview = ($this->safeHtmlEntities($personalizacion['fax']) != "") ? "block" : "none";

        $webview = ($this->safeHtmlEntities($personalizacion['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

        $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

        $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

        $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

        $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

        $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

        $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);

        $Newsletter = str_replace("%lugar_presupuesto_view%", "none", $Newsletter);

        $Newsletter = str_replace("%lugar_presupuesto%", "Ninguna", $Newsletter);

        $Newsletter = str_replace("%fechas_presupuesto_view%", "none", $Newsletter);

        $Newsletter = str_replace("%fechas_presupuesto%", "Ninguna", $Newsletter);

        if ($Presupuesto['titulo'] != null) {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "block", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", $this->safeHtmlEntities($Presupuesto['titulo']), $Newsletter);
        } else {

            $Newsletter = str_replace("%titulo_presupuesto_view%", "none", $Newsletter);

            $Newsletter = str_replace("%titulo_presupuesto%", "Ninguna", $Newsletter);
        }

        $webview = ($this->safeHtmlEntities($Cliente['web']) != "") ? "block" : "none";

        $Newsletter = str_replace("%web_cliente_view%", $webview, $Newsletter);

        if ($Cliente['web'] != null) {

            $Newsletter = str_replace("%web_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%web_cliente%", $this->safeHtmlEntities($Cliente['web']), $Newsletter);
        } else {

            $Newsletter = str_replace("%web_cliente_view%", "none", $Newsletter);
        }

        $detallado = '';

        $igic = 0.00;
        $base_sin_descuento = 0.00;
        $total_descuento = 0.00;
        $impuesto = "";
        $descuento_global = 0.00;

        if ($Presupuesto['descuento'] != null) {

            $descuento_global = floatval($Presupuesto['descuento']) / 100;
        }
        foreach (json_decode($Presupuesto['detallado'], true) as $apartado) {

            $cantidad = floatval($apartado["cantidad"]);
            $precio_unitario = floatval($apartado["precio_unitario"]);
            $descuento = floatval($apartado["descuento"]) / 100;
            $igic_percent = floatval($apartado["igic"]) / 100;

            $subtotal = $cantidad * $precio_unitario;
            $descuento_monto = $subtotal * $descuento;
            $descuento_monto_global = $subtotal * $descuento_global;
            $subtotal_con_descuento = $subtotal - $descuento_monto - $descuento_monto_global;
            $igic_aplicado = $subtotal_con_descuento * $igic_percent;
            $total_linea = $subtotal_con_descuento + $igic_aplicado;

            // Sumar totales
            $base_sin_descuento += $subtotal;
            $total_descuento += $descuento_monto + $descuento_monto_global;

            $igic += $igic_aplicado;


            $detallado .= '<tr>';
            $detallado .= '<td style="text-align:center;">' . $apartado["nombre"] . '</td>';
            $detallado .= '<td style="text-align:center;">' . $apartado["descripcion"] . '</td>';
            $detallado .= '<td style="text-align:center;">' . $apartado["cantidad"] . '</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $precio_unitario) . '€</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $apartado["igic"]) . '%</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $apartado["descuento"]) . '%</td>';
            $detallado .= '<td style="text-align:center;">' . sprintf("%.2f", $total_linea) . '€</td>';
            $detallado .= '</tr>';
            if (floatval($apartado["descuento"]) > 0 || floatval($apartado["igic"]) > 0) {

                $d = sprintf('%.2f', $descuento_monto);
                $dd = $apartado['descuento'];
                $d2 = sprintf('%.2f', $igic_aplicado);
                $dd2 = $apartado['igic'];
                $impuesto .= '<tr>
        <td class="table-cell">' . sprintf("%.2f", $subtotal) . '€</td>
                <td class="table-cell">' . $dd . '%</td>
                <td class="table-cell">' . $d . '€ </td>
               <td class="table-cell">' . $dd2 . '%</td>
                <td class="table-cell">' . $d2  . '€ </td>
              </tr>';
            }
        }
        
        $Newsletter = str_replace("%base_sin_descuento%", $this->formatearNumero(sprintf("%.2f", $base_sin_descuento)), $Newsletter);
        $Newsletter = str_replace("%total_descuento%", $this->formatearNumero(sprintf("%.2f", $total_descuento)), $Newsletter);


        $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);
        $Newsletter = str_replace("%impuestos%", $impuesto, $Newsletter);
        $Newsletter = str_replace("%nombre_cliente%", $this->safeHtmlEntities($Cliente['nombre']), $Newsletter);

        if ($Presupuesto['domicilio'] != null) {

            $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", $this->safeHtmlEntities($Presupuesto['domicilio']), $Newsletter);
        } else {

            $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);
        }

        $Newsletter = str_replace("%obra_cliente_view%", "none", $Newsletter);

        $Newsletter = str_replace("%email_cliente%", $this->safeHtmlEntities($Presupuesto['email']), $Newsletter);

        $Newsletter = str_replace("%sector_cliente_view%", "none", $Newsletter);

        $Newsletter = str_replace("%fase_cliente_view%", "none", $Newsletter);
        $Newsletter = str_replace("%evento_presupuesto%", $this->safeHtmlEntities($Presupuesto['nombre_evento']), $Newsletter);
        $Newsletter = str_replace("%lugar_presupuesto%", $this->safeHtmlEntities($Presupuesto['localizacion_evento']), $Newsletter);
        if ($Presupuesto['telefono'] != null) {

            $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%telefono_cliente%", $this->safeHtmlEntities($Presupuesto['telefono']), $Newsletter);
        } else {

            $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cif'] != null) {

            $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cif_cliente%", $this->safeHtmlEntities($Presupuesto['cif']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['cp'] != null) {

            $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

            $Newsletter = str_replace("%cp_cliente%", $this->safeHtmlEntities($Presupuesto['cp']), $Newsletter);
        } else {

            $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);
        }

        if ($Presupuesto['condiciones'] != null) {

            $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);

            $arreglo = explode("\\n", $Presupuesto['condiciones']);

            $condi = "";

            foreach ($arreglo as $a) {

                $condi .= '<p style="margin-bottom:.1rem">';

                $condi .= $a;

                $condi .= '</p>';
            }

            $Newsletter = str_replace("%condiciones_presupuesto%", $condi, $Newsletter);
        } else {

            $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);
        }

        $Newsletter = str_replace("%subtotal_presupuesto%", $this->formatearNumero($this->safeHtmlEntities($Presupuesto['importe'])), $Newsletter);

        $Newsletter = str_replace("%total_presupuesto%", $this->formatearNumero($this->safeHtmlEntities($Presupuesto['importe_final'])), $Newsletter);

        $Newsletter = str_replace("%total_impuesto_presupuesto%", $this->formatearNumero(sprintf("%.2f", ($igic))), $Newsletter);

        if ($Presupuesto['irpf'] != null) {

            $Newsletter = str_replace("%irpf_presupuesto%", $this->safeHtmlEntities($Presupuesto['irpf']), $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", $this->formatearNumero(sprintf("%.2f", (($Presupuesto['irpf'] / 100) * $Presupuesto['importe']))), $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);
        } else {

            $Newsletter = str_replace("%irpf_presupuesto%", "0.00", $Newsletter);

            $Newsletter = str_replace("%irpf_total_presupuesto%", "0,00", $Newsletter);

            $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);
        }

        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        // Definimos el tamaño y orientación del papel que queremos.

        //$pdf->set_paper("A4", "portrait");
        //$pdf->setPaper(array(0, 0, 595.28, 841.89));
        // Cargamos el contenido HTML.

        $pdf->load_html($Newsletter);

        // Renderizamos el documento PDF.

        $pdf->render();

        $fileatt = $pdf->output();

        return $fileatt;
    }*/
}