<?php



//Exit if isn't called from the main controller



if (

    !defined('__MODELS__') ||

    !defined('__VIEWS__') ||

    !defined('__CONTROLLERS__') ||

    !defined('__LIBRARIES__') ||

    !defined('__EMAILS__')

) {

    exit();

}



//Load the folders Page Model

require_once(__MODELS__ .    'folders.model.php');

require_once(__MODELS__ .    'eventos.model.php');

require_once(__MODELS__ .    'pedidos.model.php');

require_once(__LIBRARIES__ . 'anti_csrf.class.php');



class _logistica_crear_pedido

{

    private $Users;

    private $DBLink;

    private $Pedidos;



    public function check_user_session()

    {

        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

            $this->Users->_Logout();

            header('Location: ./login');

            exit();

        }

    }



    public function check_user_permissions($User_Data)

    {

        if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {



            //Check the User Index Page

            if (is_array($User_Data) && isset($User_Data['user_role'])) {



                //Get the User Index Page

                $Index = _RoleHome($User_Data['user_role']);



                //Check for Valid Index Page

                if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {



                    header('Location: ./' . $Index);

                    exit();

                } else if ($Index !== false) {



                    header('Location: ./' . $Index);

                    exit();

                }

            }



            header('Location: ./login');

            exit();

        }

    }



    public function __construct(&$DBLink)

    {

        if (!$DBLink instanceof mysqli || $DBLink->connect_error !== null)

            return trigger_error('No MySQL connection!', E_USER_ERROR);



        $this->DBLink  = $DBLink;

        $this->Users   = new _UsersModel($this->DBLink);

        $this->Pedidos = new _PedidosModel($this->DBLink);



        $this->check_user_session();



        $User_Data = $this->Users->_GetUserData();



        $this->check_user_permissions($User_Data);



        $pedidos = $this->Pedidos->GetPedidos();

        $pedidos_por_estado = array_reduce($pedidos, function ($acum, $current) {

            if (!isset($acum[$current['estado']])) {

                $acum[$current['estado']] = array();

            }



            $acum[$current['estado']][] = $current;



            return $acum;

        }, array());



        require_once __VIEWS__ . 'header.template.php';

        require_once __VIEWS__ . 'logistica_crear_pedido.template.php';

        require_once __VIEWS__ . 'footer.template.php';

    }

}