<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__'))

	exit();



//Include the Mailer Model

require_once(__MODELS__ . 'mailer.model.php');



require_once(__LIBRARIES__ . 'anti_csrf.class.php');



class _Login

{

	private $DBLink;

	private $Mailer;

	private $Users;



	public function __construct(&$DBLink)

	{

		//manualLogin($DBLink);

		//DataBase Link is Valid

		if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

			//Link the Class DataBase Link to the Given DataBase Link

			$this->DBLink = $DBLink;

			//The DataBase Link is Invalid. Trigger a Fatal Error Message and Stop Execution

		} else

			trigger_error('No MySQL connection!', E_USER_ERROR);



		$this->Users = new _UsersModel($this->DBLink);

		

		//User Already Loged

		if ($this->Users->_IsLogged() === true) {



			header('Location: ./');

			exit();

		}

		$personalizacion = json_decode(file_get_contents('./personalizacion.json'), true);



		//Have a Login Request

		if ((isset($_POST['email']) && !empty($_POST['email'])) && (isset($_POST['password']) && !empty($_POST['password'])) || (isset($_GET['code']) && !empty('code'))) {

			//Do Login

			$Login = $this->Users->_Login();

			//echo $Login;

			//Sucessfull Login

			if ($Login === true) {



				header('Location: ./');

				exit();

			}

			//Validate Email Request

		} else if (isset($_GET['validate']) && !empty($_GET['validate']) && strlen($_GET['validate']) == 45) {

			//Validate this User

			$ValidateUser = $this->Users->_ValidateUser($_GET['validate']);

			//Create New Email Validation Request

		}



		$this->Users->_FBLoginURL();

		$this->Users->_GGLoginURL();

		if ($personalizacion['habilitar_login_google'] != 1) {

			header('Location: ./login_email');

				exit();

		}


		$csrf_token = NoCSRF::generate('csrf_token');



		//Load the Login Page Template

		require_once(__VIEWS__ . 'login.template.php');

	}

}