<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) exit();
	
	
	require_once(__LIBRARIES__.'anti_csrf.class.php');
		
	//Include materiales Model
	require_once(__MODELS__.'materiales.model.php');
	class _inventario {
		private $DBLink;
		private $Profile;
		private $Users;
		private $Sales;
		private $Browser;
		private $Materiales;
		
		public function __construct(&$DBLink) {
			//If DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			$this->Materiales = new _MaterialesModel($this->DBLink);
			//Logout Function or Invalid Session
			if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
				$this->Users->_Logout();
				
				header('Location: ./login');
				exit();
			}


		
			
			//Get this User Information
			$User_Data = $this->Users->_GetUserData();
			//$User_Data['user_id']
			//$User_Data['user_role']
			//$User_Data['user_origin']
			//$User_Data['user_referrer']
			//$User_Data['user_email']
			//$User_Data['user_password']
			//$User_Data['user_purchases']
			//$User_Data['user_bonuses']
			//$User_Data['user_referrals']
			//$User_Data['user_tokens']
			//$User_Data['user_oneups']
			//$User_Data['user_address']
			//$User_Data['user_avatar']
			//$User_Data['user_code']
			//$User_Data['user_last_seen']
			//$User_Data['user_first_seen']

			
			
			//Check the User Permissions
			if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {
				//Check the User Index Page
				if (is_array($User_Data) && isset($User_Data['user_role'])) {
					//Get the User Index Page
					$Index = _RoleHome($User_Data['user_role']);
					
					//Check for Valid Index Page
					if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {
						header('Location: ./'.$Index);
						exit();
					} else if ($Index !== false) {
						header('Location: ./'.$Index);
						exit();
					}
				}
				
				header('Location: ./login');
				exit();
			}

			$permisos = [];
			//echo var_dump($_SESSION);
			if($User_Data['id_rol'] != NULL){
				$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
			//echo var_dump($permisos);
			
			}
			if(!in_array('inventario', $permisos, true)){
				header('Location: ./login');
				exit();
              }


			/*CREATE ESTADO*/
					
			if(isset($_POST['nombre_estado_agregar'])){
			
				$CreateEstado = $this->Materiales->CreateEstado($_POST['nombre_estado_agregar']);
					
				}

	/*CREATE ESTADO*/
					
	if(isset($_POST['nombre_ubicacion_agregar'])){
			
		$CreateUbicacion = $this->Materiales->CreateUbicacion($_POST['nombre_ubicacion_agregar']);
			
		}



			/*CREATE MTERIAL*/ 

		
							
			if(isset($_POST['nombre_material']) && isset($_POST['cantidad_material'])&& isset($_POST['id_ubicacion_material']) && isset($_POST['id_estado_material'])){
			
				$CreateMaterial = $this->Materiales->CreateMaterial($_POST['nombre_material'], $_POST['cantidad_material'],$_POST['id_ubicacion_material'] ,$_POST['id_estado_material']);
					
				}
					/*CREATE MTERIAL*/ 

		
							
			if(isset($_POST['id_material_editar']) && isset($_POST['nombre_material_editar']) && isset($_POST['cantidad_material_editar'])&& isset($_POST['id_ubicacion_material_editar']) && isset($_POST['id_estado_material_editar'])){
				
				$EditarMaterial = $this->Materiales->UpdateMaterial($_POST['id_material_editar'],$_POST['nombre_material_editar'], $_POST['cantidad_material_editar'],$_POST['id_ubicacion_material_editar'] ,$_POST['id_estado_material_editar']);
					
				}
				/*DELETE MTERIAL*/ 

		
							
			if(isset($_POST['id_material_eliminar'])){
				
				$EliminarMaterial = $this->Materiales->DeleteMaterial($_POST['id_material_eliminar']);
					
				}


				if(isset($_POST['id_estado_material_eliminar'])){
				
					$EliminarEstado = $this->Materiales->DeleteEstado($_POST['id_estado_material_eliminar']);
						
					}

					if(isset($_POST['id_ubicacion_material_eliminar'])){
				
						$EliminarUbicacion = $this->Materiales->DeleteUbicacion($_POST['id_ubicacion_material_eliminar']);
							
						}
            
            $User_Count = $this->Users->_GetUsersCount();
			
			$User_List = $this->Users->_GetUsersList();

			$Materiales_List= $this->Materiales->GetListMateriales();
			$Ubicaciones_List= $this->Materiales->GetListUbicaciones();
			$Estados_List= $this->Materiales->GetListEstados();
            $Materiales_Count= $this->Materiales->GetMaterialesCount();
			require_once(__VIEWS__.'header.template.php');
			
			//Load the Profile Page Template
			require_once(__VIEWS__.'inventario.template.php');
			
			//Load the Footer Template
			require_once(__VIEWS__.'footer.template.php');
		}
		
		
	}
?>