<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {

    exit();
}

//Load the folders Page Model

require_once __MODELS__ . 'folders.model.php';

require_once __MODELS__ . 'presupuestos.model.php';

require_once __LIBRARIES__ . 'anti_csrf.class.php';

require_once __MODELS__ . 'clientes.model.php';

require_once __MODELS__ . 'facturas.model.php';

require_once __MODELS__ . 'pagos.model.php';

class _Home

{

    private $DBLink;

    private $Clientes;

    private $Users;

    private $Sales;

    private $Pagos;

    private $Payment;

    private $Facturas;

    private $CoinPayments;

    private $Presupuestos;

    public function __construct($DBLink)

    {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {

            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->Users = new _UsersModel($this->DBLink);

        $this->Pagos = new _PagosModel($this->DBLink);

        $this->Presupuestos = new _PresupuestosModel($this->DBLink);

        //Logout Function or Invalid Session

        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

            $this->Users->_Logout();

            header('Location: ./login');

            exit();
        }

        $this->Facturas = new _FacturasModel($this->DBLink);

        //Get this User Information

        $User_Data = $this->Users->_GetUserData();

        //$User_Data['user_id']

        //$User_Data['user_role']

        //$User_Data['user_origin']

        //$User_Data['user_referrer']

        //$User_Data['user_email']

        //$User_Data['user_password']

        //$User_Data['user_purchases']

        //$User_Data['user_bonuses']

        //$User_Data['user_referrals']

        //$User_Data['user_tokens']

        //$User_Data['user_bonus_tokens']

        //$User_Data['user_oneups']

        //$User_Data['user_address']

        //$User_Data['user_avatar']

        //$User_Data['user_code']

        //$User_Data['user_last_seen']

        //$User_Data['user_first_seen']

        //Check the User Permissions

        $this->Clientes = new _ClientesModel($this->DBLink);

        $this->Folders = new _FoldersModel($this->DBLink);

        $Pagos_List = $this->Facturas->GetListPagos();

        $Facturas_List = $this->Facturas->GetListFacturas();

        $Pagos_List = $this->Facturas->GetListPagos();

        $Pagos = $this->Pagos->GetListFacturasProveedor();

        $Total_Pendiente_proveedores = 0;

        $Total_Pagados_proveedores = 0;

        foreach ($Pagos as $P) {

            $importe_restante = $this->Pagos->GetImporteRestante($P["id_factura_proveedor"], $P["importe"]);

            $Total_Pendiente_proveedores += $importe_restante;

            $Total_Pagados_proveedores += ($P["importe"] - $importe_restante);
        }

        $Facturas_pendientes = [];

        $Total_pendiente = 0;

        $Total_cobrado = 0;

        foreach ($Facturas_List as $Factura_pendiente) {

            if ($Factura_pendiente["estado"] == "Pendiente") {

                array_push($Facturas_pendientes, $Factura_pendiente);

                $Total_pendiente += $Factura_pendiente["importe_s"];
            } elseif ($Factura_pendiente["estado"] == "Pagado") {

                $Total_cobrado += $Factura_pendiente["importe_s"];
            } elseif ($Factura_pendiente["estado"] == "Pago parcial") {

                $Total_pendiente += $Factura_pendiente["importe_restante"];

                $Total_cobrado += $Factura_pendiente["importe_s"] - $Factura_pendiente["importe_restante"];
            }
        }

        $Uploads = $this->Clientes->GetListUploads();

        $User_CountPending = $this->Users->_GetUsersCountPending();

        $User_Count = $this->Users->_GetUsersCount();

        $Folders_Count = $this->Folders->_GetFoldersCount();

        $Files_Count = $this->Folders->_GetFilesCount();

        $Files = $this->Folders->GetListFiles();

        $Presupuestos_Count = $this->Presupuestos->GetPresupuestosCount();

        $Presupuestos = $this->Presupuestos->GetListPresupuestos();

        $permisos = [];

        $personalizacion = json_decode(file_get_contents('personalizacion.json'), true);

        //echo var_dump($_SESSION);

        if ($User_Data['id_rol'] != null) {

            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);

            //echo var_dump($permisos);

        }

        $menu = json_decode(file_get_contents('menu.json'), true);

        usort($menu['elementos'], function ($a, $b) {

            return $a['orden'] - $b['orden'];
        });

        if (!in_array('inicio', $permisos)) {

            foreach ($menu['elementos'] as $m) {

                if ($m["elementos"] == false) {
                    if ($m["visible"] == true && in_array($m["nombre"], $permisos, true)) {

                        header('Location: ' . $m["url"]);

                        exit();
                    }
                }else{
                    foreach ($m['elementos'] as $e) {
                        if ($e["visible"] == true && in_array($e["nombre"], $permisos, true)) {

                            header('Location: ' . $e["url"]);
    
                            exit();
                        }
                    }

                }
            }
        }

        require_once __VIEWS__ . 'header.template.php';

        //Load the Home Template

        require_once __VIEWS__ . 'statistics.template.php';

        //Load the Footer Template

        require_once __VIEWS__ . 'footer.template.php';
    }
}