<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

require_once __LIBRARIES__ . 'anti_csrf.class.php';
require_once __MODELS__ . 'presupuestos.model.php';
require_once __MODELS__ . 'facturas.model.php';
require_once __MODELS__ . 'pdf.model.php';
require_once __LIBRARIES__ . 'dompdf/autoload.inc.php';
require_once __MODELS__ . 'mailer.model.php';
//Include clientes Model

require_once __MODELS__ . 'clientes.model.php';

class _historial_facturas
{

    private $DBLink;

    private $Profile;

    private $Users;

    private $Sales;

    private $Browser;
    private $Facturas;
    private $Clientes;
    private $Presupuestos;
    private $Pdf;

    private $Mailer;
    public function __construct(&$DBLink)
    {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->Users = new _UsersModel($this->DBLink);
        $this->Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
        $this->Clientes = new _ClientesModel($this->DBLink);
        $this->Facturas = new _FacturasModel($this->DBLink);
        $this->Presupuestos = new _PresupuestosModel($this->DBLink);
        //Logout Function or Invalid Session

        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

            $this->Users->_Logout();

            header('Location: ./login');

            exit();

        }

        /*CREATE CLIENTE*/

        if (isset($_POST['numero_factura'])
            && isset($_POST['email_factura'])
            && isset($_POST['fecha_factura'])

            && isset($_POST['domicilio_factura'])
            && isset($_POST['estado_factura'])
            && isset($_POST['id_presupuesto_factura'])
            && isset($_POST['fecha_envio_factura'])

        ) {
            if ($_POST['fecha_envio_factura'] == "hoy") {
                $_POST['fecha_envio_factura'] = date("Y-m-d H:i:s");
            } else {
                $_POST['fecha_envio_factura'] = "";
            }

            echo $this->Facturas->CreateFactura($_POST['numero_factura'], $_POST['fecha_factura'], $_POST['domicilio_factura'], $_POST['estado_factura'],
                $_POST['id_presupuesto_factura'],
                $_POST['email_factura'],
                $_POST['fecha_envio_factura']

            );
            exit();
        }

        if (isset($_POST['id_factura_eliminar'])) {
            //    echo var_dump( $_POST);
            $DeleteFactura = $this->Facturas->DeleteFactura($_POST['id_factura_eliminar']);

        }

        //Get this User Information

        $User_Data = $this->Users->_GetUserData();

        //$User_Data['user_id']

        //$User_Data['user_role']

        //$User_Data['user_origin']

        //$User_Data['user_referrer']

        //$User_Data['user_email']

        //$User_Data['user_password']

        //$User_Data['user_purchases']

        //$User_Data['user_bonuses']

        //$User_Data['user_referrals']

        //$User_Data['user_tokens']

        //$User_Data['user_oneups']

        //$User_Data['user_address']

        //$User_Data['user_avatar']

        //$User_Data['user_code']

        //$User_Data['user_last_seen']

        //$User_Data['user_first_seen']

        //Check the User Permissions

        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != null) {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

        }
        if (!in_array('historialfacturas', $permisos, true)) {
            header('Location: ./login');
            exit();
        }

        $User_Count = $this->Users->_GetUsersCount();
        $Presupuesto = 0;
        if (isset($_GET["crear"]) && $_GET["crear"] != -1) {
            $Presupuesto = $this->Presupuestos->GetPresupuesto($_GET["crear"]);
        }
        $User_List = $this->Users->_GetUsersList();

        $Presupuestos_List = $this->Presupuestos->GetListPresupuestos();

        $Presupuestos_Count = $this->Presupuestos->GetPresupuestosCount();

        $Facturas_List = $this->Facturas->GetListFacturas();
        $Enviadas = 0;
        $Facturas_Count = $this->Facturas->GetFacturasCount();
        foreach ($Facturas_List as $F) {
            if ($F['estado'] != "No enviada") {
                $Enviadas++;
            }
        }

        $Clientes_List = $this->Clientes->GetListClientes();

        $Clientes_Count = $this->Clientes->GetClientesCount();

        require_once __VIEWS__ . 'header.template.php';

        //Load the Profile Page Template

        require_once __VIEWS__ . 'historial_facturas.template.php';

        //Load the Footer Template

        require_once __VIEWS__ . 'footer.template.php';

    }

}
