<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

//Load the folders Page Model
require_once __MODELS__ . 'folders.model.php';
require_once __MODELS__ . 'apartado.model.php';
require_once __MODELS__ . 'clientes.model.php';
require_once __LIBRARIES__ . 'anti_csrf.class.php';
require_once __MODELS__ . 'productosyservicios.model.php';
class _historial_compras
{
    private $DBLink;
    private $Apartados;
    private $PyS;
    private $Clientes;
    public function __construct(&$DBLink)
    {
        //If DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->Users = new _UsersModel($this->DBLink);
        $this->PyS = new _ProductosyserviciosModel($this->DBLink);
        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
            $this->Users->_Logout();

            header('Location: ./login');
            exit();
        }
        $this->Apartados = new _ApartadoModel($this->DBLink);
        $this->Clientes = new _ClientesModel($this->DBLink);
        /*CREATE APARTADO*/

        if (isset($_POST['titulo_apartado']) && isset($_POST['descripcion_apartado']) && isset($_POST['cantidad_apartado']) && isset($_POST['precio_apartado'])) {

            $CreateApartado = $this->Apartados->CreateApartado($_POST['titulo_apartado'], $_POST['descripcion_apartado'], $_POST['cantidad_apartado'], $_POST['precio_apartado']);

        }

        /*DELETE APARTADO */
        if (isset($_POST['id_compra_eliminar'])) {
            $DeleteApartado = $this->PyS->DeleteCompra($_POST['id_compra_eliminar']);
        }

        /*DELETE APARTADO */
        if (isset($_POST['id_apartado']) && isset($_POST['apartado_titulo']) && isset($_POST['apartado_descripcion']) && isset($_POST['apartado_cantidad']) && isset($_POST['apartado_precio'])) {
            $UpdateApartado = $this->Apartados->UpdateApartado($_POST['id_apartado'], $_POST['apartado_titulo'], $_POST['apartado_descripcion'], $_POST['apartado_cantidad'], $_POST['apartado_precio']);
        }

        //Get this User Information
        $User_Data = $this->Users->_GetUserData();
        //$User_Data['user_id']
        //$User_Data['user_role']
        //$User_Data['user_origin']
        //$User_Data['user_referrer']
        //$User_Data['user_email']
        //$User_Data['user_password']
        //$User_Data['user_purchases']
        //$User_Data['user_bonuses']
        //$User_Data['user_referrals']
        //$User_Data['user_tokens']
        //$User_Data['user_oneups']
        //$User_Data['user_address']
        //$User_Data['user_avatar']
        //$User_Data['user_code']
        //$User_Data['user_last_seen']
        //$User_Data['user_first_seen']
        $Compras = $this->PyS->GetListCompras();
        //Check the User Permissions

        $this->Folders = new _FoldersModel($this->DBLink);

        //Crear carpeta
        if (isset($_POST['folder_name']) && !empty($_POST['folder_name']) && isset($_POST['pulled_apart']) && is_numeric($_POST['pulled_apart']) && isset($_POST['folder'])) {

            $CreateFolder = $this->Folders->CreateFolder($_POST['folder_name'], $_POST['pulled_apart'], $_POST['folder'], $_POST['tags']);

        }

        //Eliminar carpeta
        if (isset($_GET['delete']) && is_numeric($_GET['delete']) && $_GET['delete'] > 0 && NoCSRF::check('csrf_token', $_GET)) {

            $DeleteFolder = $this->Folders->DeleteFolder($_GET['delete']);

        }

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `folders`")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

        }

        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != null) {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

        }
        if (!in_array('historialcompras', $permisos, true)) {
            header('Location: ./login');
            exit();
        }

        //mostrar datos de carpetas
        $Apartados = $this->Apartados->GetListApartados();
        $Apartados_Count = $this->Apartados->GetApartadosCount();
        $Clientes_List = $this->Clientes->GetListClientes();

        $Clientes_Count = $this->Clientes->GetClientesCount();

        $csrf_token = NoCSRF::generate('csrf_token');
        require_once __VIEWS__ . 'header.template.php';


        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `compras`")) {
            $Folders = array();

            //Loop around the Referrals
            while ($Result = mysqli_fetch_assoc($Query)) {
                $Folders[] = $Result;
            }

        }
        
        $compras_totales_count = count($Folders);
        //Load the Profile Page Template
        require_once __VIEWS__ . 'historial_compras.template.php';

        //Load the Footer Template
        require_once __VIEWS__ . 'footer.template.php';

    }

}