<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
    exit();





require_once (__LIBRARIES__ . 'anti_csrf.class.php');
require_once (__MODELS__ . 'presupuestos.model.php');

require_once (__MODELS__ . 'pdf.model.php');
require_once (__LIBRARIES__ . 'dompdf/autoload.inc.php');
require_once (__MODELS__ . 'mailer.model.php');
//Include clientes Model

require_once (__MODELS__ . 'clientes.model.php');
use Dompdf\Dompdf;
use Dompdf\Options;

class _Historial_albaranes
{

    private $DBLink;

    private $Profile;

    private $Users;

    private $Sales;

    private $Browser;

    private $Clientes;
    private $Presupuestos;
    private $Pdf;
    private $Mailer;

    public function __construct(&$DBLink)
    {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else
            trigger_error('No MySQL connection!', E_USER_ERROR);



        $this->Users = new _UsersModel($this->DBLink);
        $this->Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
        $this->Clientes = new _ClientesModel($this->DBLink);
        $this->Presupuestos = new _PresupuestosModel($this->DBLink);
        //Logout Function or Invalid Session

        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

            $this->Users->_Logout();



            header('Location: ./login');

            exit();

        }




        /*ELIMINAR PRESUPUESTO*/
        if (isset($_POST['id_presupuesto_eliminar'])) {
            //	echo var_dump( $_POST);
            $DeletePresupuesto = $this->Presupuestos->EliminarPresupuesto($_POST['id_presupuesto_eliminar']);

        }
        if (isset($_POST["id_presupuesto_aceptar"])) {

            $AceptarPresupuesto = $this->Presupuestos->AceptarPresupuesto($_POST["id_presupuesto_aceptar"]);
            $ContratarCliente = $this->Clientes->ContratarCliente($_GET["id"]);

        }
        if (isset($_POST["id_presupuesto_rechazar"])) {
            $RechazarPresupuesto = $this->Presupuestos->RechazarPresupuesto($_POST["id_presupuesto_rechazar"]);


        }


        //Get this User Information

        $User_Data = $this->Users->_GetUserData();

        //$User_Data['user_id']

        //$User_Data['user_role']

        //$User_Data['user_origin']

        //$User_Data['user_referrer']

        //$User_Data['user_email']

        //$User_Data['user_password']

        //$User_Data['user_purchases']

        //$User_Data['user_bonuses']

        //$User_Data['user_referrals']

        //$User_Data['user_tokens']

        //$User_Data['user_oneups']

        //$User_Data['user_address']

        //$User_Data['user_avatar']

        //$User_Data['user_code']

        //$User_Data['user_last_seen']

        //$User_Data['user_first_seen']







        //Check the User Permissions

        if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {

            //Check the User Index Page

            if (is_array($User_Data) && isset($User_Data['user_role'])) {

                //Get the User Index Page

                $Index = _RoleHome($User_Data['user_role']);



                //Check for Valid Index Page

                if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {

                    header('Location: ./' . $Index);

                    exit();

                } else if ($Index !== false) {

                    header('Location: ./' . $Index);

                    exit();

                }

            }



            header('Location: ./login');

            exit();

        }
        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != NULL) {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

        }
        if (!in_array('historialalbaranes', $permisos, true)) {
            header('Location: ./login');
            exit();
        }





        $User_Count = $this->Users->_GetUsersCount();



        $User_List = $this->Users->_GetUsersList();

        $Presupuestos_List = $this->Presupuestos->GetListPresupuestos();

        $Presupuestos_Count = $this->Presupuestos->GetPresupuestosCount();

        $Clientes_List = $this->Clientes->GetListClientes();

        $Clientes_Count = $this->Clientes->GetClientesCount();


        $Obras_List = $this->Presupuestos->GetListObras();
        $Sectores_List = $this->Presupuestos->GetListSectores();
        $Fases_List = $this->Presupuestos->GetListFases();

        require_once (__VIEWS__ . 'header.template.php');



        //Load the Profile Page Template

        require_once (__VIEWS__ . 'historial_albaranes.template.php');



        //Load the Footer Template

        require_once (__VIEWS__ . 'footer.template.php');

    }





}

?>