<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
    exit();






require_once(__MODELS__ . 'alumnos.model.php');

require_once(__MODELS__ . 'escuela.model.php');


class _formulario
    {

    private $DBLink;

    private $Profile;

    private $Users;

    private $Sales;
    private $Escuela;
    private $Browser;
    private $Alumnos;
    private $Clientes;
    private $Presupuestos;
    private $Pdf;
    private $Mailer;
    public function __construct(&$DBLink)
        {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
            {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

            } else
            trigger_error('No MySQL connection!', E_USER_ERROR);



        $this->Users = new _UsersModel($this->DBLink);

        $this->Escuela = new _EscuelaModel($this->DBLink);
        $this->Alumnos = new _AlumnosModel($this->DBLink);


        //Logout Function or Invalid Session





        //Get this User Information
        if ($_SESSION['avatar'] != "1")
            {
            $User_Data = $this->Users->_GetUserData();
            } else
            {
            $User_Data = $this->Users->_GetUserData2();
            }


        $Formulario = $this->Alumnos->GetFormulario($_GET['id']);


        $User_Count = $this->Users->_GetUsersCount();

        $Cursos = $this->Escuela->GetListCursos();
        $Alumnos = $this->Alumnos->GetListAlumnos();
        $User_List = $this->Users->_GetUsersList();





        require_once(__VIEWS__ . 'header.template.php');



        //Load the Profile Page Template

        require_once(__VIEWS__ . 'formulario.template.php');



        //Load the Footer Template

        require_once(__VIEWS__ . 'footer.template.php');
        if ($_SESSION['avatar'] == "1")
            {
            $this->Users->_Logout();
            }

        }





    }