<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
    exit();





require_once(__LIBRARIES__ . 'anti_csrf.class.php');



//Include clientes Model

require_once(__MODELS__ . 'clientes.model.php');
require_once(__MODELS__ . 'escuela.model.php');

class _firmar_pago
    {

    private $DBLink;

    private $Profile;

    private $Users;

    private $Sales;

    private $Browser;

    private $Clientes;
    private $Escuela;



    public function __construct(&$DBLink)
        {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
            {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

            } else
            trigger_error('No MySQL connection!', E_USER_ERROR);



        $this->Users = new _UsersModel($this->DBLink);

        $this->Clientes = new _ClientesModel($this->DBLink);
        $this->Escuela = new _EscuelaModel($this->DBLink);

        //Logout Function or Invalid Session

     
        if (!isset($_GET['id']) || !isset($_GET['token'])) {
            header('Location: ./login');
            exit();
        }

        $fichaje_id = $_GET['id'];
        $csrf_token = $_GET['token'];
        $Fichaje = $this->Users->GetFacturaEmpleado($_GET['id']);

        if (
            $_SESSION['avatar'] != "1")
        {
        $User_Data = $this->Users->_GetUserData();
        } else
        {
        $User_Data = $this->Users->_GetUserData2();
        }

      
   // Verify CSRF token
   if (!$Fichaje || $Fichaje['csrf_token'] !== $csrf_token) {
    // Token is invalid, redirect to login
    header('Location: ./login');
    exit();
}








        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != NULL)
            {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

            }
      




        $User_Count = $this->Users->_GetUsersCount();



        $User_List = $this->Users->_GetUsersList();


        $Cursos = $this->Escuela->GetListCursos();
        $Clientes_List = $this->Clientes->GetListClientes();
        $Planes = $this->Escuela->GetListPlanes();
        $Clientes_Count = $this->Clientes->GetClientesCount();
        $Grupos = $this->Clientes->GetListGrupos();
        $Niveles = $this->Escuela->GetListNiveles();
     

        //Load the Profile Page Template
require_once(__VIEWS__ . 'header.template.php');
        require_once(__VIEWS__ . 'firmar_pago.template.php');

	require_once(__VIEWS__ . 'footer.template.php');
    if ($_SESSION['avatar'] == "1")
    {
    $this->Users->_Logout();
    }



        }





    }

?>