<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
	exit();


//Load the folders Page Model
require_once(__MODELS__ . 'folders.model.php');
require_once(__MODELS__ . 'apartado.model.php');
require_once __MODELS__ . 'pagos.model.php';

class _Financiacion
	{
	private $DBLink;
	private $Apartados;
    private $Pagos;
	public function __construct(&$DBLink)
		{
		//If DataBase Link is Valid
		if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
			{
			//Link the Class DataBase Link to the Given DataBase Link
			$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else
			trigger_error('No MySQL connection!', E_USER_ERROR);

		$this->Users = new _UsersModel($this->DBLink);
        $this->Pagos = new _PagosModel($this->DBLink);
		//Logout Function or Invalid Session
		if (isset($_GET['logout']) || $this->Users->_IsLogged() == false)
			{
			$this->Users->_Logout();

			header('Location: ./login');
			exit();
			}
		$this->Apartados = new _ApartadoModel($this->DBLink);

		/*CREATE APARTADO*/


		//Get this User Information
		$User_Data = $this->Users->_GetUserData();
		//$User_Data['user_id']
		//$User_Data['user_role']
		//$User_Data['user_origin']
		//$User_Data['user_referrer']
		//$User_Data['user_email']
		//$User_Data['user_password']
		//$User_Data['user_purchases']
		//$User_Data['user_bonuses']
		//$User_Data['user_referrals']
		//$User_Data['user_tokens']
		//$User_Data['user_oneups']
		//$User_Data['user_address']
		//$User_Data['user_avatar']
		//$User_Data['user_code']
		//$User_Data['user_last_seen']
		//$User_Data['user_first_seen']





		$permisos = [];
		//echo var_dump($_SESSION);
		if ($User_Data['id_rol'] != NULL)
			{
			$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
			//echo var_dump($permisos);

			}
		if (!in_array('financiacion', $permisos, true))
			{
			header('Location: ./login');
			exit();
			}

        $Bancos = $this->Pagos->GetListBancos();
		//mostrar datos de carpetas
		$Apartados = $this->Apartados->GetListApartados();
		$Apartados_Count = $this->Apartados->GetApartadosCount();
		$Medidas = $this->Apartados->GetListMedidas();

		
		require_once(__VIEWS__ . 'header.template.php');

		//Load the Profile Page Template
		require_once(__VIEWS__ . 'financiacion.template.php');

		//Load the Footer Template
		require_once(__VIEWS__ . 'footer.template.php');


		}




	}

?>