<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))

	exit();





require_once(__LIBRARIES__ . 'anti_csrf.class.php');



class _fichaje

	{

	private $DBLink;

	private $Profile;

	private $Users;

	private $Sales;

	private $Browser;



	public function __construct(&$DBLink, $Fichaje = NULL, $FechaInicio = 0, $FechaFinal = 0)

		{

		//If DataBase Link is Valid

		if ($DBLink instanceof mysqli && $DBLink->connect_error === null)

			{

			//Link the Class DataBase Link to the Given DataBase Link

			$this->DBLink = $DBLink;

			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

			} else

			trigger_error('No MySQL connection!', E_USER_ERROR);



		$this->Users = new _UsersModel($this->DBLink);



		//Logout Function or Invalid Session

		if (isset($_GET['logout']) || $this->Users->_IsLogged() == false)

			{

			$this->Users->_Logout();



			header('Location: ./login');

			exit();

			}



		$User_Data = $this->Users->_GetUserData();

		$Miembro = $this->Users->GetMiembroByIdUser($User_Data['user_id']);



		if ($Miembro == null)

			{



			require_once(__VIEWS__ . 'header.template.php');



			//Load the Profile Page Template

			require_once(__VIEWS__ . 'usuario_no_verificado.template.php');



			//Load the Footer Template

			require_once(__VIEWS__ . 'footer.template.php');

			exit();

			}







		//Get this User Information





		$Fichaje = $this->Users->GetFichajeActivo($Miembro['id_miembro']);













		$Jornada = $this->Users->GetJornada($Miembro['id_miembro']);







		$User_Count = $this->Users->_GetUsersCount();



		$User_List = $this->Users->_GetUsersList();



		require_once(__VIEWS__ . 'header.template.php');



		//Load the Profile Page Template

		require_once(__VIEWS__ . 'fichaje.template.php');



		//Load the Footer Template

		require_once(__VIEWS__ . 'footer.template.php');

		}





	}

?>