<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

//Load the folders Page Model

require_once __MODELS__ . 'folders.model.php';

require_once __MODELS__ . 'presupuestos.model.php';

require_once __LIBRARIES__ . 'anti_csrf.class.php';
require_once __MODELS__ . 'clientes.model.php';
require_once __MODELS__ . 'mailer.model.php';

require_once __MODELS__ . 'google.model.php';
class _Enviar
{

    private $DBLink;
    private $Clientes;

    private $Mailer;
    private $Sales;
    private $Users;
    private $Payment;

    private $CoinPayments;

    private $Presupuestos;
    private $Google;
    private $GoogleURL;

    public function __construct($DBLink)
    {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->Users = new _UsersModel($this->DBLink);

        $this->Presupuestos = new _PresupuestosModel($this->DBLink);

        $this->Clientes = new _ClientesModel($this->DBLink);

        $this->Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
        $this->Google = new _GoogleModel($this->DBLink);
        if (!$this->Users->_IsLogged()) {
            $User_Data = $this->Users->_GetUserData2();
            //Get the Google Login URL
            $this->GoogleURL = $this->Google->_LoginURL();
            $_SESSION['logged'] = true;
            $_SESSION['id'] = htmlentities($User_Data['user_id'], ENT_QUOTES);
            $_SESSION['role'] = htmlentities($User_Data['user_role'], ENT_QUOTES);
            $_SESSION['avatar'] = "1";
            $_SESSION['email'] = htmlentities($User_Data['user_email'], ENT_QUOTES);
            $_SESSION['name'] = htmlentities($User_Data['user_full_name'][0], ENT_QUOTES) . ' ' . htmlentities($User_Data['user_full_name'][1], ENT_QUOTES);

        }

        //Logout Function or Invalid Session
        require_once '/home/wfudjpum/intranet.emerload.com/envio_masivo.php';

    }

}
