<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
	exit();


//Load the folders Page Model
require_once(__MODELS__ . 'folders.model.php');
require_once(__MODELS__ . 'apartado.model.php');
require_once(__LIBRARIES__ . 'anti_csrf.class.php');
require_once(__MODELS__ . 'clientes.model.php');
require_once(__MODELS__ . 'presupuestos.model.php');
require_once(__MODELS__ . 'pdf.model.php');
require_once(__LIBRARIES__ . 'dompdf/autoload.inc.php');
require_once(__MODELS__ . 'mailer.model.php');
use Dompdf\Dompdf;
use Dompdf\Options;

class _Editar_presupuesto
	{
	private $DBLink;
	private $Apartados;
	private $Clientes;
	private $Presupuestos;
	private $Users;


	private $Pdf;
	private $Mailer;
	public function __construct(&$DBLink)
		{
		//If DataBase Link is Valid
		if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
			{
			//Link the Class DataBase Link to the Given DataBase Link
			$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else
			trigger_error('No MySQL connection!', E_USER_ERROR);

		$this->Users = new _UsersModel($this->DBLink);
		$this->Presupuestos = new _PresupuestosModel($this->DBLink);


		//Logout Function or Invalid Session
		if (isset($_GET['logout']) || $this->Users->_IsLogged() == false)
			{
			$this->Users->_Logout();

			header('Location: ./login');
			exit();
			}


		$this->Apartados = new _ApartadoModel($this->DBLink);
		$this->Clientes = new _ClientesModel($this->DBLink);






		//Get this User Information
		$User_Data = $this->Users->_GetUserData();
		//$User_Data['user_id']




		//mostrar datos de carpetas
		$Apartados = $this->Apartados->GetListApartados();
		$PresupuestoEditar = $this->Presupuestos->GetPresupuesto($_GET['id']);
		$ClientePresupuesto = $this->Clientes->GetCliente($PresupuestoEditar['id_cliente']);
		$Clientes_List = $this->Clientes->GetListClientes();
		$Obras_List = $this->Clientes->GetListObras();
		$Clientes_Count = $this->Clientes->GetClientesCount();
		$User_List = $this->Users->_GetUsersList();
		$Condiciones_List = $this->Presupuestos->GetListCondiciones();
		$Medidas = $this->Apartados->GetListMedidas();

		require_once(__VIEWS__ . 'header.template.php');

		//Load the Profile Page Template
		require_once(__VIEWS__ . 'editar_presupuesto.template.php');

		//Load the Footer Template
		require_once(__VIEWS__ . 'footer.template.php');


		}




	}

?>