<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) exit();
	
	require_once(__MODELS__.'presupuestos.model.php');
	require_once(__LIBRARIES__.'anti_csrf.class.php');
	require_once(__MODELS__.'clientes.model.php');
	class _crear_subvenciones {
		private $DBLink;
		private $Profile;
		private $Users;
		private $Sales;
		private $Browser;
		private $Clientes;
		public function __construct(&$DBLink) {
			//If DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			$this->Clientes = new _ClientesModel($this->DBLink);
			$this->Presupuestos = new _PresupuestosModel($this->DBLink);
			//Logout Function or Invalid Session
			if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
				$this->Users->_Logout();
				
				header('Location: ./login');
				exit();
			}
			
			//Get this User Information
			$User_Data = $this->Users->_GetUserData();
			//$User_Data['user_id']
			//$User_Data['user_role']
			//$User_Data['user_origin']
			//$User_Data['user_referrer']
			//$User_Data['user_email']
			//$User_Data['user_password']
			//$User_Data['user_purchases']
			//$User_Data['user_bonuses']
			//$User_Data['user_referrals']
			//$User_Data['user_tokens']
			//$User_Data['user_oneups']
			//$User_Data['user_address']
			//$User_Data['user_avatar']
			//$User_Data['user_code']
			//$User_Data['user_last_seen']
			//$User_Data['user_first_seen']
			
			//Check the User Permissions
			if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {
				//Check the User Index Page
				if (is_array($User_Data) && isset($User_Data['user_role'])) {
					//Get the User Index Page
					$Index = _RoleHome($User_Data['user_role']);
					
					//Check for Valid Index Page
					if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {
						header('Location: ./'.$Index);
						exit();
					} else if ($Index !== false) {
						header('Location: ./'.$Index);
						exit();
					}
				}
				
				header('Location: ./login');
				exit();
			}
			
			
			if(isset($_FILES['imagen_portada'])){
					
				echo $this->Clientes->SubirImagen($_FILES['imagen_portada']);
				
				exit();
			}

			if(isset($_POST['id_zona_eliminar'])){
					
				$DeleteZona = $this->Clientes->DeleteZona($_POST['id_zona_eliminar']);
					
			}
			if(isset($_POST['id_sector_eliminar'])){
					
				$DeleteSector = $this->Clientes->DeleteSector($_POST['id_sector_eliminar']);
					
			}
			if(isset($_POST['id_fase_eliminar'])){
					
				$DeleteFase = $this->Clientes->DeleteFase($_POST['id_fase_eliminar']);
					
			}
			if(isset($_POST['nombre_zona'])&& isset($_POST['cliente_zona_id'])){
					
				$CreateZona = $this->Clientes->CreateZona($_POST['nombre_zona'],$_POST['cliente_zona_id']);
					
			}
			if(isset($_POST['nombre_sector'])&& isset($_POST['cliente_sector_id'])){
					
				$CreateSector = $this->Clientes->CreateSector($_POST['nombre_sector'],$_POST['cliente_sector_id']);
					
			}
			if(isset($_POST['nombre_fase'])&& isset($_POST['cliente_fase_id'])){
					
				$CreateFase = $this->Clientes->CreateFase($_POST['nombre_fase'],$_POST['cliente_fase_id']);
					
			}



			//echo var_dump($_POST);
			if(isset($_POST['email']) &&
				isset($_POST['id_cliente']) &&
				isset($_POST['id_subvencion'])){
					if(isset($_POST['cif']) &&
					isset($_POST['domicilio']) &&
					isset($_POST['cp']) &&
					isset($_POST['telefono']) &&
					isset($_POST['email']) &&
					isset($_POST['nombre']) &&
					isset($_POST['tipo']) &&
					isset($_POST['empleados']) &&
					isset($_POST['importe']) &&
					isset($_POST['enlace']) &&
					isset($_POST['usuario']) &&
					isset($_POST['fase']) &&
					isset($_POST['sector']) &&
					isset($_POST['email_marketing']) &&
					isset($_POST['zona'])&&
					isset($_POST['url_portada'])&&
					isset($_POST['condiciones'])&&				
					isset($_POST['titulo']))
					{
						
						if(isset($_POST['fecha_envio'])){
							$crearDatos = $this->Users->CreateDatosCliente(
								$this->Users->EnviarSubvencion($_POST['id_cliente'],$_POST['id_subvencion'],$_POST['email'],$_POST['email_marketing'],$_POST['url_portada'],$_POST['condiciones'],$_POST['fecha_envio']),
								$_POST['cif'],
								$_POST['cp'],
								$_POST['telefono'],
								$_POST['email'],
								$_POST['nombre'],
								$_POST['sector'],
								$_POST['fase'],
								$_POST['zona'],
								$_POST['tipo'],
								$_POST['empleados'],
								$_POST['importe'],
								$_POST['enlace'],
								$_POST['usuario'],
								$_POST['domicilio'],
								$_POST['titulo']			
								);
								$this->Clientes->SetEstadoCliente($_POST['id_cliente'],'Potencial');
						}else{


						$crearDatos = $this->Users->CreateDatosCliente(
							$this->Users->EnviarSubvencion($_POST['id_cliente'],$_POST['id_subvencion'],$_POST['email'],($_POST['email_marketing']),$_POST['url_portada'],$_POST['condiciones']),
							$_POST['cif'],
							$_POST['cp'],
							$_POST['telefono'],
							$_POST['email'],
							$_POST['nombre'],
							$_POST['sector'],
							$_POST['fase'],
							$_POST['zona'],
							$_POST['tipo'],
							$_POST['empleados'],
							$_POST['importe'],
							$_POST['enlace'],
							$_POST['usuario'],
							$_POST['domicilio'],
							$_POST['titulo']			
							);
					}

					}
				}
            	$permisos = [];
			//echo var_dump($_SESSION);
			if($User_Data['id_rol'] != NULL){
				$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
			//echo var_dump($permisos);
			
			}
			if(!in_array('crearsubvenciones', $permisos, true)){
				header('Location: ./login');
				exit();
              }
            $User_Count = $this->Users->_GetUsersCount();
			$Sectores = $this->Clientes->GetListSectores();
			$User_List = $this->Users->_GetUsersList();
            $Clientes_List= $this->Clientes->GetListClientes();
			$Subvenciones_List= $this->Clientes->GetListSubvenciones();
            $Clientes_Count= $this->Clientes->GetClientesCount();
			$Condiciones_List =  $this->Presupuestos->GetListCondiciones();
			require_once(__VIEWS__.'header.template.php');
			
			//Load the Profile Page Template
			require_once(__VIEWS__.'crear_subvenciones.template.php');
			
			//Load the Footer Template
			require_once(__VIEWS__.'footer.template.php');
		}
		
		
	}
?>