<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

//Load the folders Page Model

require_once __MODELS__ . 'actividades.model.php';
require_once __MODELS__ . 'vacaciones.model.php';

class _control_vacaciones
{
    private $DBLink;
    private $Actividades;
    private $Vacaciones;
    private $Users;
    public function __construct(&$DBLink)
    {
        //If DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->Users = new _UsersModel($this->DBLink);
        $this->Vacaciones = new _VacacionesModel($this->DBLink);

        $this->Actividades = new _ActividadesModel($this->DBLink);
        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
            $this->Users->_Logout();

            header('Location: ./login');
            exit();
        }

        //Get this User Information
        $User_Data = $this->Users->_GetUserData();

        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != null) {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

        }
        if (!in_array('controldevacaciones', $permisos, true)) {
            header('Location: ./login');
            exit();
        }

        //mostrar datos de carpetas

        $Periodos = $this->Vacaciones->GetListPeriodoVacaciones();
        $Empleados = $this->Vacaciones->GetListEmpleados();
        $Empleados_Count = count($Empleados);
        $User_List = $this->Users->_GetUsersList();
   
        require_once __VIEWS__ . 'header.template.php';

        //Load the Profile Page Template
        require_once __VIEWS__ . 'control_vacaciones.template.php';

        //Load the Footer Template
        require_once __VIEWS__ . 'footer.template.php';

    }

}
