<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))

	exit();





//Include the Browser Detection Library

require_once (__LIBRARIES__ . 'browser.php');

//Include the Google Model

require_once (__MODELS__ . 'google.model.php');

//Include the GeoIP Library

require_once (__LIBRARIES__ . 'maxmind/autoload.php');

require_once (__MODELS__ . 'personalizacion.model.php');

require_once (__LIBRARIES__ . 'anti_csrf.class.php');



class _Configuration

{

	private $DBLink;

	private $Users;

	private $Sales;
private $Provincias;
		private $Localidades;
	private $Browser;
 private $Google;
	private $Personalizacion;

	public function __construct(&$DBLink)

	{

		//If DataBase Link is Valid

		if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

			//Link the Class DataBase Link to the Given DataBase Link

			$this->DBLink = $DBLink;

			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

		} else

			trigger_error('No MySQL connection!', E_USER_ERROR);

 $this->Google = new _GoogleModel($this->DBLink);

		$this->Users = new _UsersModel($this->DBLink);

		$this->Personalizacion = new _PersonalizacionModel($this->DBLink);

		//Logout Function or Invalid Session

		if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

			$this->Users->_Logout();



			header('Location: ./login');

			exit();

		}

$Provincias = $this->Users->GetProvinciasList();
	$Localidades = $this->Users->GetLocalidadesList();
			

		//Get this User Information

		$User_Data = $this->Users->_GetUserData();

        $googleData = $this->Google->GetGoogleData();

        

        $google_client_id = null;

        if(isset($googleData[0]['client_id'])){

            $google_client_id = $googleData[0]['client_id'];

        }



        $google_client_secret = null;

        if(isset($googleData[0]['client_secret'])){

            $google_client_secret = $googleData[0]['client_secret'];

        }



        $google_redirect_link = null;

        if(isset($googleData[0]['redirect_link'])){

            $google_redirect_link = $googleData[0]['redirect_link'];

        }



		//Check the User Permissions

	


		//Get this User Login List

		$User_Logins = $this->Users->_LoginList();

		
		


$Roles = $this->Personalizacion->GetListRoles();
		$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);

		//Change Avatar

		if (isset($_FILES['avatar']) && is_array($_FILES['avatar']) && NoCSRF::check('csrf_token', $_POST)) {

			$Avatar = $this->Users->_ChangeAvatar($User_Data['user_id'], $_FILES['avatar']);

		}

		if (isset($_FILES['imagen_portada_configuracion']) && is_array($_FILES['imagen_portada_configuracion'])) {



			$personalizacion['imagen_portada_configuracion'] = $this->Personalizacion->CambiarLogoPortada($_FILES['imagen_portada_configuracion']);

			$personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

			file_put_contents('personalizacion.json', $personalizacionEncoded);



		}



		//Restore Avatar

		if (isset($_GET['restore_avatar']) && NoCSRF::check('csrf_token', $_GET)) {



			$Avatar = $this->Users->_RestoreAvatar($User_Data['user_id']);



		}



		$User_List = $this->Users->_GetUsersList();



		//Delete Profile

		if (isset($_GET['delete_profile']) && NoCSRF::check('csrf_token', $_GET)) {



			$DeleteUser = $this->Users->_DeleteUser($User_Data['user_id']);



			if ($DeleteUser === true) {

				$this->Users->_Logout();



				header('Location: ./login');

				exit();

			}

		}



		$csrf_token = NoCSRF::generate('csrf_token');



		if (isset($_GET['modal_configuration']) && $_GET['modal_configuration'] == 'none') {



			if (!mysqli_query($this->DBLink, "UPDATE `users` SET `modal_configuration` = 'none' WHERE (`user_id` = '{$User_Data['user_id']}');")) {

				//Revert the DataBase Queries

				mysqli_rollback($this->DBLink);



				//Start the DataBase Auto-Commit

				mysqli_autocommit($this->DBLink, true);



				return -14;

			}



			header('Location: ./configuration');

			exit();

		}



		$correos = array();

        if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `mailing`;")) {

            $correos = array();



            //Loop around the Referrals

            while ($Result = mysqli_fetch_assoc($Query)) {

                $correos[] = $Result;

            }



        }





		require_once (__VIEWS__ . 'header.template.php');



		//Load the Profile Page Template

		require_once (__VIEWS__ . 'configuration.template.php');



		//Load the Footer Template

		require_once (__VIEWS__ . 'footer.template.php');

	}



	function _ParseBrowser($UserAgent)

	{

		if (!($this->Browser instanceof Browser)) {

			$this->Browser = new Browser($UserAgent);

		} else {

			$this->Browser->setUserAgent($UserAgent);

		}



		$Browser = $this->Browser->getBrowser();



		if ($Browser == false || $Browser == 'unknown') {

			return 'Desconocido';

		}



		$Version = $this->Browser->getVersion();



		if ($Version == false || $Version == 'unknown') {

			return 'Desconocido';

		}





		return $Browser . ' ' . $Version;

	}



	//https://stackoverflow.com/questions/1416697/converting-timestamp-to-time-ago-in-php-e-g-1-day-ago-2-days-ago

	function time_elapsed_string($datetime, $full = false)

	{

		$now = new DateTime;

		$ago = new DateTime($datetime);

		$diff = $now->diff($ago);



		$diff->w = floor($diff->d / 7);

		$diff->d -= $diff->w * 7;



		$string = array(

			'y' => _('año'),

			'm' => _('mes'),

			'w' => _('semana'),

			'd' => _('día'),

			'h' => _('hora'),

			'i' => _('minuto'),

			's' => _('segundo'),

		);

		foreach ($string as $k => &$v) {

			if ($diff->$k) {

				$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');

			} else {

				unset($string[$k]);

			}

		}



		if (!$full)

			$string = array_slice($string, 0, 1);

		return $string ? implode(', ', $string) . _(' atrás') : _('justo ahora');

	}

}

?>