<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) exit();
	

	//Load the folders Page Model
	require_once(__MODELS__.'folders.model.php');
	require_once(__MODELS__.'apartado.model.php');
	require_once(__LIBRARIES__.'anti_csrf.class.php');
    require_once(__MODELS__.'presupuestos.model.php');
	
	class _Condiciones {
		private $DBLink;
		private $Apartados;
        private $Presupuestos;
		
		public function __construct(&$DBLink) {
			//If DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			$this->Presupuestos = new _PresupuestosModel($this->DBLink);
			//Logout Function or Invalid Session
			if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
				$this->Users->_Logout();
				
				header('Location: ./login');
				exit();
			}
			$this->Apartados = new _ApartadoModel($this->DBLink);

			/*CREATE APARTADO*/ 

			
             if(isset($_POST['condicion']) && isset($_POST['titulo'])){
                $CreateCondicion = $this->Presupuestos->CreateCondicion($_POST['condicion'],$_POST['titulo']);
            }
							
			

            /*DELETE APARTADO */
            if(isset($_POST['id_condicion_eliminar'])){
                $EliminarCondicion = $this->Presupuestos->EliminarCondicion($_POST['id_condicion_eliminar']);
            }


             /*DELETE APARTADO */
             if(isset($_POST['id_condicion_editar']) && isset($_POST['condicion_editar']) && isset($_POST['titulo_editar']) ){
                $UpdateCondicion = $this->Presupuestos->UpdateCondicion($_POST['id_condicion_editar'],$_POST['condicion_editar'],$_POST['titulo_editar']);
            }

			//Get this User Information
			$User_Data = $this->Users->_GetUserData();
			//$User_Data['user_id']
			//$User_Data['user_role']
			//$User_Data['user_origin']
			//$User_Data['user_referrer']
			//$User_Data['user_email']
			//$User_Data['user_password']
			//$User_Data['user_purchases']
			//$User_Data['user_bonuses']
			//$User_Data['user_referrals']
			//$User_Data['user_tokens']
			//$User_Data['user_oneups']
			//$User_Data['user_address']
			//$User_Data['user_avatar']
			//$User_Data['user_code']
			//$User_Data['user_last_seen']
			//$User_Data['user_first_seen']
		
			//Check the User Permissions
			if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {
				//Check the User Index Page
				if (is_array($User_Data) && isset($User_Data['user_role'])) {
					//Get the User Index Page
					$Index = _RoleHome($User_Data['user_role']);
					
					//Check for Valid Index Page
					if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {
						header('Location: ./'.$Index);
						exit();
					} else if ($Index !== false) {
						header('Location: ./'.$Index);
						exit();
					}
				}
				
				header('Location: ./login');
				exit();
			}
			$this->Folders = New _FoldersModel($this->DBLink);
            
            //Crear carpeta
			if(isset($_POST['folder_name']) && !empty($_POST['folder_name']) && isset($_POST['pulled_apart']) && is_numeric($_POST['pulled_apart']) && isset($_POST['folder'])){
                
              $CreateFolder = $this->Folders->CreateFolder($_POST['folder_name'], $_POST['pulled_apart'], $_POST['folder'], $_POST['tags']);
              
            }
      
            //Eliminar carpeta
            if(isset($_GET['delete']) && is_numeric($_GET['delete']) && $_GET['delete'] > 0 && NoCSRF::check('csrf_token', $_GET)) {
                
                $DeleteFolder = $this->Folders->DeleteFolder($_GET['delete']);
    
            }
            
            	
			if ($Query = mysqli_query($this->DBLink, "SELECT * FROM `folders`")) {
				$Folders = array();
				
				//Loop around the Referrals
				while ($Result = mysqli_fetch_assoc($Query)) {
					$Folders[] = $Result;
				}
				
				
			}
            $permisos = [];
			//echo var_dump($_SESSION);
			if($User_Data['id_rol'] != NULL){
				$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
			//echo var_dump($permisos);
			
			}
			if(!in_array('condiciones', $permisos, true)){
				header('Location: ./login');
				exit();
              }
            //mostrar datos de carpetas
           $Apartados =  $this->Apartados->GetListApartados();
           $Apartados_Count =  $this->Apartados->GetApartadosCount();
           $Condiciones_List =  $this->Presupuestos->GetListCondiciones();

            	 $csrf_token = NoCSRF::generate('csrf_token');
			require_once(__VIEWS__.'header.template.php');
			
			//Load the Profile Page Template
			require_once(__VIEWS__.'condiciones.template.php');
			
			//Load the Footer Template
			require_once(__VIEWS__.'footer.template.php');
            
 
		}
		
		


	}

?>