<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) exit();
	
require_once(__MODELS__.'facturas.model.php');	
	require_once(__LIBRARIES__.'anti_csrf.class.php');
	require_once(__MODELS__.'pagos.model.php');
require_once(__MODELS__.'presupuestos.model.php');
require_once(__MODELS__.'clientes.model.php');
	class _cobros_pendientes {
		private $DBLink;
		private $Profile;
		private $Users;
		private $Sales;
		private $Browser;
		private $Pagos;
private $Presupuestos;
private $Facturas;
	private $Clientes;
		public function __construct(&$DBLink, $FechaInicio=0, $FechaFinal=0) {
			//If DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			$this->Pagos = new _PagosModel($this->DBLink);
			$this->Presupuestos = new _PresupuestosModel($this->DBLink);
			$this->Clientes = new _ClientesModel($this->DBLink);
	$this->Facturas = new _FacturasModel($this->DBLink);		
			//Logout Function or Invalid Session
			if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
				$this->Users->_Logout();
				
				header('Location: ./login');
				exit();
			}
			
			//Get this User Information
			$User_Data = $this->Users->_GetUserData();
		
			$Bancos = $this->Pagos->GetListBancos();
			$Metodos = $this->Pagos->GetListMetodos();


			
			$permisos = [];
			//echo var_dump($_SESSION);
			if($User_Data['id_rol'] != NULL){
				$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
			//echo var_dump($permisos);
			
			}
			if(!in_array('cobrospendientes', $permisos, true)){
				header('Location: ./login');
				exit();
              }

            
			require_once(__VIEWS__.'header.template.php');
			
			//Load the Profile Page Template
			require_once(__VIEWS__.'cobros_pendientes.template.php');
			
			//Load the Footer Template
			require_once(__VIEWS__.'footer.template.php');
		}
		
		
	}
?>