<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
	exit();





require_once(__LIBRARIES__ . 'anti_csrf.class.php');



//Include clientes Model

require_once(__MODELS__ . 'clientes.model.php');

class _clientes
	{

	private $DBLink;

	private $Profile;

	private $Users;

	private $Sales;

	private $Browser;

	private $Clientes;



	public function __construct(&$DBLink)
		{

		//If DataBase Link is Valid

		if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
			{

			//Link the Class DataBase Link to the Given DataBase Link

			$this->DBLink = $DBLink;

			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

			} else
			trigger_error('No MySQL connection!', E_USER_ERROR);



		$this->Users = new _UsersModel($this->DBLink);

		$this->Clientes = new _ClientesModel($this->DBLink);

		//Logout Function or Invalid Session

		if (isset($_GET['logout']) || $this->Users->_IsLogged() == false)
			{

			$this->Users->_Logout();



			header('Location: ./login');

			exit();

			}



		/*CREATE CLIENTE*/

		if (isset($_POST['id_cliente_editar']) && isset($_POST['nombre_cliente_editar']) && isset($_POST['cif_cliente_editar']) && isset($_POST['direccion_cliente_editar']) && isset($_POST['cp_cliente_editar']) && isset($_POST['email_cliente_editar']) && isset($_POST['tel_cliente_editar']) && isset($_POST['fecha_nacimiento_cliente_editar']))
			{




			if ($_POST['cp_cliente_editar'] == 0)
				{
				$_POST['cp_cliente_editar'] = "";
				}

			if ($_POST['tel_cliente_editar'] == 0)
				{
				$_POST['tel_cliente_editar'] = "";
				}

			$EditCliente = $this->Clientes->EditCliente($_POST['id_cliente_editar'], $_POST['nombre_cliente_editar'], $_POST['direccion_cliente_editar'], $_POST['tel_cliente_editar'], $_POST['cp_cliente_editar'], $_POST['cif_cliente_editar'], $_POST['email_cliente_editar'], $_POST['fecha_nacimiento_cliente_editar']);

			}
		if (isset($_POST['id_cliente_eliminar']))
			{


			$DeleteCliente = $this->Clientes->DeleteCliente($_POST['id_cliente_eliminar']);

			}
		if (isset($_POST['nombre_cliente']) && isset($_POST['cif_cliente']) && isset($_POST['direccion_cliente']) && isset($_POST['cp_cliente']) && isset($_POST['email_cliente']) && isset($_POST['tel_cliente']) && isset($_POST['fecha_nacimiento_cliente']))
			{



			if ($_POST['cp_cliente'] == 0)
				{
				$_POST['cp_cliente'] = "";
				}

			if ($_POST['tel_cliente'] == 0)
				{
				$_POST['tel_cliente'] = "";
				}

			$CreateCliente = $this->Clientes->CreateCliente($_POST['nombre_cliente'], $_POST['direccion_cliente'], $_POST['tel_cliente'], $_POST['cp_cliente'], $_POST['cif_cliente'], $_POST['email_cliente'], $_POST['fecha_nacimiento_cliente']);

			}
		//Get this User Information

		$User_Data = $this->Users->_GetUserData();

		//$User_Data['user_id']

		//$User_Data['user_role']

		//$User_Data['user_origin']

		//$User_Data['user_referrer']

		//$User_Data['user_email']

		//$User_Data['user_password']

		//$User_Data['user_purchases']

		//$User_Data['user_bonuses']

		//$User_Data['user_referrals']

		//$User_Data['user_tokens']

		//$User_Data['user_oneups']

		//$User_Data['user_address']

		//$User_Data['user_avatar']

		//$User_Data['user_code']

		//$User_Data['user_last_seen']

		//$User_Data['user_first_seen']







		//Check the User Permissions

		if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true)
			{

			//Check the User Index Page

			if (is_array($User_Data) && isset($User_Data['user_role']))
				{

				//Get the User Index Page

				$Index = _RoleHome($User_Data['user_role']);



				//Check for Valid Index Page

				if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE']))
					{

					header('Location: ./' . $Index);

					exit();

					} else if ($Index !== false)
					{

					header('Location: ./' . $Index);

					exit();

					}

				}



			header('Location: ./login');

			exit();

			}

		$permisos = [];
		//echo var_dump($_SESSION);
		if ($User_Data['id_rol'] != NULL)
			{
			$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
			//echo var_dump($permisos);

			}
		if (!in_array('clientestotales', $permisos, true))
			{
			header('Location: ./login');
			exit();
			}




		$User_Count = $this->Users->_GetUsersCount();



		$User_List = $this->Users->_GetUsersList();



		$Clientes_List = $this->Clientes->GetListClientes();

		$Clientes_Count = $this->Clientes->GetClientesCount();
		$Grupos = $this->Clientes->GetListGrupos();
		require_once(__VIEWS__ . 'header.template.php');



		//Load the Profile Page Template

		require_once(__VIEWS__ . 'clientes.template.php');



		//Load the Footer Template

		require_once(__VIEWS__ . 'footer.template.php');

		}





	}

?>