<?php

//Exit if isn't called from the main controller

if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

require_once __LIBRARIES__ . 'anti_csrf.class.php';

require_once __MODELS__ . 'facturas.model.php';
require_once __MODELS__ . 'facturamanual.model.php';
//Include clientes Model
require_once __MODELS__ . 'pdf.model.php';
require_once __LIBRARIES__ . 'dompdf/autoload.inc.php';
require_once __MODELS__ . 'mailer.model.php';
require_once __MODELS__ . 'clientes.model.php';
require_once __MODELS__ . 'productosyservicios.model.php';
require_once __MODELS__ . 'presupuestos.model.php';
require_once __MODELS__ . 'albaranes.model.php';
use Dompdf\Dompdf;
use Dompdf\Options;

class _cliente
{

    private $DBLink;
    private $Facturas;
    private $Profile;
    private $PyS;
    private $Users;

    private $Sales;

    private $Browser;
    private $FacturaManual;
    private $Clientes;
    private $Mailer;
    private $Presupuestos;
    private $Albaranes;
    public function __construct(&$DBLink)
    {

        //If DataBase Link is Valid

        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {

            //Link the Class DataBase Link to the Given DataBase Link

            $this->DBLink = $DBLink;

            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution

        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }
        $this->FacturaManual = new _FacturaManualModel($this->DBLink);
        $this->Facturas = new _FacturasModel($this->DBLink);
        $this->Presupuestos = new _PresupuestosModel($this->DBLink);
        $this->Albaranes = new _AlbaranesModel($this->DBLink);
        $this->Users = new _UsersModel($this->DBLink);
        $this->Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);
        $this->Clientes = new _ClientesModel($this->DBLink);
        $this->PyS = new _ProductosyserviciosModel($this->DBLink);
        //Logout Function or Invalid Session

        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {

            $this->Users->_Logout();

            header('Location: ./login');

            exit();

        }

        if (isset($_FILES['imagen_portada'])) {

            $fotos = json_decode($this->Clientes->GetDatosClientePeluqueria($_GET["id"])["fotos"]);
            if ($fotos == null) {
                $fotos = [];
            }

            $foto = array(
                "url" => $this->Clientes->SubirImagen($_FILES['imagen_portada']),
                "nombre" => $_FILES['imagen_portada']["name"],
            );
            array_push($fotos, $foto);
            $JSON = json_encode($fotos);

            $this->Clientes->AddFotosCliente($_GET["id"], $JSON);
        }

        if (isset($_POST['image_url'])) {

            $fotos = json_decode($this->Clientes->GetDatosClientePeluqueria($_GET["id"])["fotos"]);
            $index = 0;
            foreach ($fotos as $foto) {

                if ($foto->url == $_POST['image_url']) {

                    array_splice($fotos, $index);
                }
                $index++;
            }

            $JSON = json_encode($fotos);
            $this->Clientes->AddFotosCliente($_GET["id"], $JSON);

        }
        //Get this User Information

        $User_Data = $this->Users->_GetUserData();

        //$User_Data['user_id']

        //$User_Data['user_role']

        //$User_Data['user_origin']

        //$User_Data['user_referrer']

        //$User_Data['user_email']

        //$User_Data['user_password']

        //$User_Data['user_purchases']

        //$User_Data['user_bonuses']

        //$User_Data['user_referrals']

        //$User_Data['user_tokens']

        //$User_Data['user_oneups']

        //$User_Data['user_address']

        //$User_Data['user_avatar']

        //$User_Data['user_code']

        //$User_Data['user_last_seen']

        //$User_Data['user_first_seen']

        $Creador = $this->Users->_GetUserData($_SESSION['id']);

        //Check the User Permissions

        if (!is_array($User_Data) || _IsAllowed($User_Data['user_role']) !== true) {

            //Check the User Index Page

            if (is_array($User_Data) && isset($User_Data['user_role'])) {

                //Get the User Index Page

                $Index = _RoleHome($User_Data['user_role']);

                //Check for Valid Index Page

                if ($Index !== false && (isset($GLOBALS['ACTIVE_PAGE']) && $Index != $GLOBALS['ACTIVE_PAGE'])) {

                    header('Location: ./' . $Index);

                    exit();

                } else if ($Index !== false) {

                    header('Location: ./' . $Index);

                    exit();

                }

            }

            header('Location: ./login');

            exit();

        }

        $PendientesTab = 0;
        $NotasTab = 0;
        $EnviadosTab = 0;
        $FacturasTab = 0;

        /*EDITAR FOTO CLIENTE*/
        if (isset($_GET["notastab"])) {

            $NotasTab = 1;

        }

        if (isset($_GET["enviadostab"])) {

            $EnviadosTab = 1;

        }
        if (isset($_GET["pendientestab"])) {

            $PendientesTab = 1;

        }
        if (isset($_GET["facturastab"])) {

            $FacturasTab = 1;

        }
        if (isset($_FILES['imagen_cliente']) && is_array($_FILES['imagen_cliente'])) {

            $Avatar = $this->Clientes->CambiarImagen($_FILES['imagen_cliente'], $_GET['id']);
        }

        /*CREAR NOTA*/
        if (isset($_POST["cuerpo_nota"])) {

            $CrearNota = $this->Clientes->CreateNota($_POST["cuerpo_nota"], $_GET['id']);

        }

        /*eliminar NOTA*/
        if (isset($_POST["id_nota_eliminar"])) {

            $DeleteNota = $this->Clientes->DeleteNota($_POST["id_nota_eliminar"]);

        }

        //echo var_dump( $_POST);

        /*eDITAR NOTA*/
        if (isset($_POST["id_nota_editar"]) && isset($_POST["cuerpo_nota_editar"])) {

            $EditNota = $this->Clientes->UpdateNota($_POST["id_nota_editar"], $_POST["cuerpo_nota_editar"]);

        }

        /*ACEPTAR PRESUPUESTO */
        if (isset($_POST["id_presupuesto_aceptar"])) {

            $AceptarPresupuesto = $this->Presupuestos->AceptarPresupuesto($_POST["id_presupuesto_aceptar"]);
            $ContratarCliente = $this->Clientes->ContratarCliente($_GET["id"]);

        }

        if (isset($_POST["id_presupuesto_aceptar2"])) {

            $AceptarPresupuesto = $this->Presupuestos->AceptarPresupuesto($_POST["id_presupuesto_aceptar2"]);
            $ContratarCliente = $this->Clientes->ContratarCliente($_GET["id"]);
        }

        /*REENVIAR PRESUPUESTO */
        if (isset($_POST["id_presupuesto_reenviar"])) {

            $ReenviarPresupuesto = $this->Presupuestos->ReenviarPresupuesto($_POST["id_presupuesto_reenviar"]);

        }

        /*RECHAZAR PRESUPUESTO */
        if (isset($_POST["id_presupuesto_rechazar"])) {
            $RechazarPresupuesto = $this->Presupuestos->RechazarPresupuesto($_POST["id_presupuesto_rechazar"]);

        }
        /*RECHAZAR PRESUPUESTO */
        if (isset($_POST["id_presupuesto_rechazar2"])) {
            $RechazarPresupuesto = $this->Presupuestos->RechazarPresupuesto($_POST["id_presupuesto_rechazar2"]);

        }
        if (isset($_POST['id_factura_eliminar'])) {
            //
            $DeleteFactura = $this->Facturas->DeleteFactura($_POST['id_factura_eliminar']);

        }
        /*ELIMINAR PRESUPUESTO */
        if (isset($_POST["id_presupuesto_eliminar"])) {
            $EliminarPresupuesto = $this->Presupuestos->EliminarPresupuesto($_POST["id_presupuesto_eliminar"]);

        }

        if (isset($_POST['id_aceptar']) && isset($_POST['id_cliente_aceptar'])) {
            $this->Clientes->SetEstadoCliente($_POST['id_cliente_aceptar'], 'Si');
            $this->Clientes->SetEstadoClienteSubvencion($_POST['id_aceptar'], "Aceptado");
        }
        if (isset($_POST['id_rechazar'])) {

            $this->Clientes->SetEstadoClienteSubvencion($_POST['id_rechazar'], "Rechazado");
        }
        if (isset($_POST['id_eliminar'])) {

            $this->Clientes->EliminarClienteSubvencion($_POST['id_eliminar']);
        }
        if (isset($_POST['nombre_estado_agregar'])) {

            $CreateEstadoSubvencion = $this->Clientes->CreateEstadoSubvencion($_POST['nombre_estado_agregar']);

        }
        if (isset($_POST['id_estado_material_eliminar'])) {

            $EliminarEstado = $this->Clientes->DeleteEstadoSubvencion($_POST['id_estado_material_eliminar']);

        }
        if (isset($_POST['id_cliente_subvencion_estado']) && isset($_POST['id_estado_subvencion'])) {
            $this->Clientes->SetEstadoClienteSubvencion2($_POST['id_cliente_subvencion_estado'], $_POST['id_estado_subvencion']);

        }
        if (isset($_POST['id_cliente_subvencion_tag']) && isset($_POST['tag'])) {
            $this->Clientes->setTagClienteSubvencion($_POST['id_cliente_subvencion_tag'], $_POST['tag']);

        }


        $User_Count = $this->Users->_GetUsersCount();

        $User_List = $this->Users->_GetUsersList();

        $Cliente = $this->Clientes->GetCliente($_GET['id']);
        $VehiculosCliente = $this->Clientes->GetVentasCliente($_GET['id']);
        $Notas = $this->Clientes->GetNotasCliente($_GET['id']);
        $Clientes_List = $this->Clientes->GetListClientes();
        $Facturas_List = $this->Facturas->GetListFacturas();
        $Subvenciones_List = $this->Clientes->GetListSubvencionesEnviadasCliente($_GET['id']);
        $Facturas_Count = $this->Facturas->GetFacturasCount();
        $Clientes_Count = $this->Clientes->GetClientesCount();
        $FacturasManualesCliente = $this->FacturaManual->GetFacturasManualesCliente($_GET['id']);
        $PresupuestosCliente = $this->Presupuestos->GetPresupuestosCliente($_GET['id']);
        $AlbaranesCliente = $this->Albaranes->GetAlbaranesCliente($_GET['id']);
        $ComprasCliente = 0;

        $PresupuestosAceptadosCount = 0;
        $PresupuestosPendientesCount = 0;
        $PresupuestosNoEnviadosCount = 0;
        $PresupuestosRechazadosCount = 0;
        foreach ($PresupuestosCliente as $P) {
            if ($P["estado"] == "Aceptado") {
                $PresupuestosAceptadosCount++;
            }
            if ($P["estado"] == "Pendiente") {
                $PresupuestosPendientesCount++;
            }
            if ($P["estado"] == "No enviado") {
                $PresupuestosNoEnviadosCount++;
            }
            if ($P["estado"] == "Rechazado") {
                $PresupuestosRechazadosCount++;
            }
        }
        $ComprasCliente = $this->PyS->GetListComprasFrom($_GET['id']);
        require_once __VIEWS__ . 'header.template.php';

        //Load the Profile Page Template

        require_once __VIEWS__ . 'cliente.template.php';

        //Load the Footer Template

        require_once __VIEWS__ . 'footer.template.php';

    }

}