<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) {
    exit();
}

require_once __MODELS__ . 'clientes.model.php';
require_once __LIBRARIES__ . 'anti_csrf.class.php';
require_once __MODELS__ . 'trabajadores.model.php';
require_once __MODELS__ . 'productosyservicios.model.php';
class _calendario_citas
{
    private $DBLink;
    private $Profile;
    private $Users;
    private $Sales;
    private $Browser;
    private $Trabajadores;
    private $Clientes;
    private $PyS;
    public function __construct(&$DBLink)
    {
        //If DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
        } else {
            trigger_error('No MySQL connection!', E_USER_ERROR);
        }

        $this->Clientes = new _ClientesModel($this->DBLink);
        $this->PyS = new _ProductosyserviciosModel($this->DBLink);
        $this->Users = new _UsersModel($this->DBLink);
        $this->Trabajadores = new _TrabajadoresModel($this->DBLink);
        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
            $this->Users->_Logout();

            header('Location: ./login');
            exit();
        }

        if (isset($_POST['id_usuario_trabajador'])) {

            $CreateTrabajador = $this->Users->SetTrabajadorPeluqueria($_POST['id_usuario_trabajador'], 1);
        }

        if (isset($_POST['id_usuario_trabajador_eliminar'])) {
            $Servicios_trabajadores = $this->PyS->GetListServiciosTrabajadores();
            foreach ($Servicios_trabajadores as $S) {
                if ($S["user_id"] == $_POST['id_usuario_trabajador_eliminar']) {
                    $this->Users->DeleteServicioTrabajador($S["id_servicio_trabajador"]);
                }
            }
            $DeleteTrabajador = $this->Users->SetTrabajadorPeluqueria($_POST['id_usuario_trabajador_eliminar'], 0);
        }
        if (isset($_POST['id_turno_eliminar'])) {

            $this->Users->DeleteServicioTrabajador($_POST['id_turno_eliminar']);
        }
        if (isset($_POST['usuario_asignar']) && isset($_POST['fecha_i']) && isset($_POST['fecha_f'])) {

            $CreateServicioTrabajador = $this->Users->CreateServicioTrabajador($_POST['usuario_asignar'], $_POST['fecha_i'], $_POST['fecha_f']);
        }
        if (isset($_POST['id_usuario_turno_1']) && isset($_POST['id_cliente_turno_1']) && isset($_POST['id_servicio_turno_1']) && isset($_POST['fecha_i_1']) && isset($_POST['fecha_f_1'])) {

            $CreateTurnoCompleto = $this->Users->CreateTurnoCompleto($_POST['id_usuario_turno_1'], $_POST['id_cliente_turno_1'], $_POST['id_servicio_turno_1'], $_POST['fecha_i_1'], $_POST['fecha_f_1']);
        }
        if (isset($_POST['id_turno_editar']) && isset($_POST['id_usuario_turno_2']) && isset($_POST['id_cliente_turno_2']) && isset($_POST['id_servicio_turno_2']) && isset($_POST['fecha_i_2']) && isset($_POST['fecha_f_2'])) {

            $EditarTurno = $this->Users->EditarTurno($_POST['id_turno_editar'], $_POST['id_usuario_turno_2'], $_POST['id_cliente_turno_2'], $_POST['id_servicio_turno_2'], $_POST['fecha_i_2'], $_POST['fecha_f_2']);
        }
        if (isset($_POST['id_servicio_peluqueria']) && isset($_POST['color_servicio_peluqueria'])) {

            $CreateServicioCalendario = $this->Users->CreateServicioCalendario($_POST['id_servicio_peluqueria'], $_POST['color_servicio_peluqueria']);
        }
        if (isset($_POST['color_servicio_editar']) && isset($_POST['id_servicio_editar'])) {

            $CambiarColor = $this->PyS->CambiarColor($_POST['id_servicio_editar'], $_POST['color_servicio_editar']);
        }

        if (isset($_POST['id_servicio_trabajador_cambiar'])

            && isset($_POST['fecha_i_cambiar'])
            && isset($_POST['fecha_f_cambiar'])
        ) {

            $CambiarDia = $this->Users->CambiarDia($_POST['id_servicio_trabajador_cambiar'], $_POST['fecha_i_cambiar'], $_POST['fecha_f_cambiar']);
        }

        //Get this User Information
        $User_Data = $this->Users->_GetUserData();
        $Users = $this->Users->_GetUsersList();
        $User_List = $this->Users->_GetUsersList();
        //$User_Data['user_id']
        //$User_Data['user_role']
        //$User_Data['user_origin']
        //$User_Data['user_referrer']
        //$User_Data['user_email']
        //$User_Data['user_password']
        //$User_Data['user_purchases']
        //$User_Data['user_bonuses']
        //$User_Data['user_referrals']
        //$User_Data['user_tokens']
        //$User_Data['user_oneups']
        //$User_Data['user_address']
        //$User_Data['user_avatar']
        //$User_Data['user_code']
        //$User_Data['user_last_seen']
        //$User_Data['user_first_seen']

        //Check the User Permissions

        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != null) {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

        }
        if (!in_array('calendariocitas', $permisos, true)) {
            header('Location: ./login');
            exit();
        }
        $Trabajadores_Count = $this->Trabajadores->GetTrabajadoresCount();
        $Clientes = $this->Clientes->GetListClientes();
        $Clientes_List = $this->Clientes->GetListClientes();
        $Trabajadores_List = $this->Trabajadores->GetListTrabajadores();
        $Servicios = $this->PyS->GetListServicios();
        $Servicios_calendario = $this->PyS->GetListServiciosCalendario();
        require_once __VIEWS__ . 'header.template.php';

        //Load the Profile Page Template
        require_once __VIEWS__ . 'calendario_citas.template.php';

        //Load the Footer Template
        require_once __VIEWS__ . 'footer.template.php';
    }

}