<?php
	//Exit if isn't called from the main controller
	if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__')) exit();
	
	require_once(__MODELS__.'productosyservicios.model.php');
	require_once(__MODELS__.'clientes.model.php');
	require_once(__LIBRARIES__.'anti_csrf.class.php');

	class _agregar_productos_y_servicios {
		private $DBLink;
		private $Profile;
		private $Users;
		private $Sales;
		private $Browser;
		private $PyS;
		
		public function __construct(&$DBLink) {
			//If DataBase Link is Valid
			if ($DBLink instanceof mysqli && $DBLink->connect_error === null) {
				//Link the Class DataBase Link to the Given DataBase Link
				$this->DBLink = $DBLink;
			// If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
			} else trigger_error('No MySQL connection!', E_USER_ERROR);
			
			$this->Users = new _UsersModel($this->DBLink);
			$this->Clientes = new _ClientesModel($this->DBLink);
			$this->PyS = new _ProductosyserviciosModel($this->DBLink);
			//Logout Function or Invalid Session
			if (isset($_GET['logout']) || $this->Users->_IsLogged() == false) {
				$this->Users->_Logout();
				
				header('Location: ./login');
				exit();
			}
			$User_Data = $this->Users->_GetUserData();
			$permisos = [];
			//echo var_dump($_SESSION);
			if($User_Data['id_rol'] != NULL){
				$permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
			//echo var_dump($permisos);
			
			}
			if(!in_array('agregarproductosyservicios', $permisos, true)){
				header('Location: ./login');
				exit();
              }
			
			  if(isset($_FILES['imagen_producto'])){
					
				echo $this->Clientes->SubirImagen($_FILES['imagen_producto']);
				
				exit();
			}
			if(isset($_FILES['imagen_producto_editar'])){
					
				echo $this->Clientes->SubirImagen($_FILES['imagen_producto_editar']);
				
				exit();
			}
			if(isset($_FILES['imagen_servicio'])){
					
				echo $this->Clientes->SubirImagen($_FILES['imagen_servicio']);
				
				exit();
			}
			if(isset($_FILES['imagen_servicio_editar'])){
					
				echo $this->Clientes->SubirImagen($_FILES['imagen_servicio_editar']);
				
				exit();
			}
			
			  if(isset($_POST['nombre_subcategoria'])){
					
				$this->PyS->CreateSubcategoria($_POST['nombre_subcategoria']);
					
			}
			if(isset($_POST['id_subcategoria_eliminar'])){
					
				$this->PyS->EliminarSubcategoria($_POST['id_subcategoria_eliminar']);
					
			}
			if(isset($_POST['id_producto_eliminar'])){
					
				$this->PyS->EliminarProducto($_POST['id_producto_eliminar']);
					
			}
			if(isset($_POST['id_servicio_eliminar'])){
					
				$this->PyS->EliminarServicio($_POST['id_servicio_eliminar']);
					
			}
			

			if(isset($_POST['nombre_producto'])&& isset($_POST['imagen_producto']) && isset($_POST['precio_producto'])&& isset($_POST['numero_producto'])&& isset($_POST['id_subcategoria_producto'])&& isset($_POST['descripcion_producto'])&& isset($_POST['oxidacion_producto'])){
					
				$this->PyS->CreateProducto($_POST['nombre_producto'],$_POST['imagen_producto'],$_POST['precio_producto'],$_POST['numero_producto'],$_POST['id_subcategoria_producto'],$_POST['descripcion_producto'],$_POST['oxidacion_producto']);
					
			}
			if(isset($_POST['nombre_servicio'])&& isset($_POST['imagen_servicio']) && isset($_POST['precio_servicio'])&& isset($_POST['id_subcategoria_servicio'])&& isset($_POST['descripcion_servicio'])){
					
				$this->PyS->CreateServicio($_POST['nombre_servicio'],$_POST['imagen_servicio'],$_POST['precio_servicio'],$_POST['id_subcategoria_servicio'],$_POST['descripcion_servicio']);
					
			}
			if(isset($_POST['id_producto_editar'])&&isset($_POST['nombre_producto_editar'])&& isset($_POST['imagen_producto_editar']) && isset($_POST['precio_producto_editar'])&& isset($_POST['numero_producto_editar'])&& isset($_POST['id_subcategoria_producto_editar'])&& isset($_POST['descripcion_producto_editar'])&& isset($_POST['oxidacion_producto_editar'])){
					
				$this->PyS->UpdateProducto($_POST['id_producto_editar'],$_POST['nombre_producto_editar'],$_POST['imagen_producto_editar'],$_POST['precio_producto_editar'],$_POST['numero_producto_editar'],$_POST['id_subcategoria_producto_editar'],$_POST['descripcion_producto_editar'],$_POST['oxidacion_producto_editar']);
					
			}
			if(isset($_POST['id_servicio_editar'])&&isset($_POST['nombre_servicio_editar'])&& isset($_POST['imagen_servicio_editar']) && isset($_POST['precio_servicio_editar'])&& isset($_POST['id_subcategoria_servicio_editar'])&& isset($_POST['descripcion_servicio_editar'])){
					
				$this->PyS->UpdateServicio($_POST['id_servicio_editar'],$_POST['nombre_servicio_editar'],$_POST['imagen_servicio_editar'],$_POST['precio_servicio_editar'],$_POST['id_subcategoria_servicio_editar'],$_POST['descripcion_servicio_editar']);
					
			}

			$Productos = $this->PyS->GetListProductos();
			$Servicios = $this->PyS->GetListServicios();
            
			require_once(__VIEWS__.'header.template.php');
			
			//Load the Profile Page Template
			require_once(__VIEWS__.'agregar_productos_y_servicios.template.php');
			
			//Load the Footer Template
			require_once(__VIEWS__.'footer.template.php');
		}
		
		
	}
?>