<?php
//Exit if isn't called from the main controller
if (!defined('__MODELS__') || !defined('__VIEWS__') || !defined('__CONTROLLERS__') || !defined('__LIBRARIES__') || !defined('__EMAILS__'))
    {
    exit();
    }

//Include the Mailer Model
require_once __MODELS__ . 'mailer.model.php';

require_once __LIBRARIES__ . 'anti_csrf.class.php';

class _Admission
    {
    private $DBLink;
    private $Profile;
    private $Users;
    private $Sales;
    private $Browser;

    public function __construct(&$DBLink)
        {
        //If DataBase Link is Valid
        if ($DBLink instanceof mysqli && $DBLink->connect_error === null)
            {
            //Link the Class DataBase Link to the Given DataBase Link
            $this->DBLink = $DBLink;
            // If DataBase Link is Invalid Trigger a Fatal Error Message and Stop Execution
            } else
            {
            trigger_error('No MySQL connection!', E_USER_ERROR);
            }

        $this->Users = new _UsersModel($this->DBLink);

        //Logout Function or Invalid Session
        if (isset($_GET['logout']) || $this->Users->_IsLogged() == false)
            {
            $this->Users->_Logout();

            header('Location: ./login');
            exit();
            }

        //Get this User Information
        $User_Data = $this->Users->_GetUserData();


        //Check the User Permissions
        $permisos = [];
        //echo var_dump($_SESSION);
        if ($User_Data['id_rol'] != null)
            {
            $permisos = json_decode($this->Users->GetRol($User_Data['id_rol'])['links']);
            //echo var_dump($permisos);

            }


        if (isset($_GET['approve']) && is_numeric($_GET['approve']) && $_GET['approve'] > 0 && NoCSRF::check('csrf_token', $_GET))
            {

            if (!mysqli_query($this->DBLink, "UPDATE `users` SET `user_verification_status` = '1', user_supervisor = {$_SESSION['id']} WHERE (`user_id` = '{$_GET['approve']}');"))
                {
                //Revert the DataBase Queries
                mysqli_rollback($this->DBLink);

                //Start the DataBase Auto-Commit
                mysqli_autocommit($this->DBLink, true);

                return -1;
                } else
                {

                $UserApprove = $this->Users->_GetUserData($_GET['approve']);
                $Newsletter = file_get_contents(__ROOT__ . '/emails/aprobado.html');
                //Check for Newsletter Reading Error
                if ($Newsletter == false)
                    {
                    //Revert the DataBase Queries
                    mysqli_rollback($this->DBLink);

                    //Start the DataBase Auto-Commit
                    mysqli_autocommit($this->DBLink, true);

                    return -2;
                    }

                $Keywords[] = array('%user_name%', htmlentities($UserApprove['user_full_name'], ENT_QUOTES));

                $personalizacion = json_decode(file_get_contents('personalizacion.json'), true);

                $Keywords[] = array('%imagen%', htmlentities($personalizacion['imagen_email_usuario'], ENT_QUOTES));
                $Keywords[] = array('%cabecera%', htmlentities($personalizacion['cabecera_email_usuario'], ENT_QUOTES));
                $Keywords[] = array('%cuerpo%', htmlentities($personalizacion['texto_email_usuario'], ENT_QUOTES));
                $Keywords[] = array('%asunto%', htmlentities($personalizacion['asunto_email'], ENT_QUOTES));

                $this->Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

                //Set the Message Keywords
                $this->Mailer->_SetKeywords($Keywords);

                //Send the E-Mail to the User
                 $this->Mailer->_Mail(EMAIL_VALIDATE_USERNAME, trim($UserApprove['user_email']), 'Solicitud aceptada', $Newsletter, APP_NAME);
                /*
                //Check for Invalid E-Mail
                if ($Email !== true) {
                //Revert the DataBase Queries
                mysqli_rollback($this->DBLink);
                //Start the DataBase Auto-Commit
                mysqli_autocommit($this->DBLink, true);
                return -21;
                }
                */
                //Send the DataBase Commit
                if (!mysqli_commit($this->DBLink))
                    {
                    //Revert the DataBase Queries
                    mysqli_rollback($this->DBLink);

                    //Start the DataBase Auto-Commit
                    mysqli_autocommit($this->DBLink, true);

                    return -22;
                    }

                //Start the DataBase Auto-Commit
                mysqli_autocommit($this->DBLink, true);

                $approve = true;
                }

            }

        if (isset($_GET['delete']) && is_numeric($_GET['delete']) && $_GET['delete'] > 0 && NoCSRF::check('csrf_token', $_GET))
            {
            $DeleteUser = $this->DeleteUser($_GET['delete']);

            }

        //Get this User Login List
        $User_Count = $this->Users->_GetUsersCountPending();

        $User_List = $this->Users->_GetUsersListPending();
        $csrf_token = NoCSRF::generate('csrf_token');

        require_once __VIEWS__ . 'header.template.php';

        //Load the Profile Page Template
        require_once __VIEWS__ . 'admission.template.php';

        //Load the Footer Template
        require_once __VIEWS__ . 'footer.template.php';
        }

    private function _DeleteLoginsByID($UserID)
        {
        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);

        if (!mysqli_query($this->DBLink, "DELETE FROM `logins` WHERE (`login_user` = '{$UserID}');"))
            {
            return -1;
            }

        return true;
        }

    private function DeleteUser($UserID)
        {
        $UserID = mysqli_real_escape_string($this->DBLink, $UserID);
        //Stop the DataBase Auto-Commit
        mysqli_autocommit($this->DBLink, false);

        //Disable the Foreign Key Checks
        if (!mysqli_query($this->DBLink, "SET foreign_key_checks = 0;"))
            {
            return -1;
            }

        //Try to Delete the Logins for this User
        if ($this->_DeleteLoginsByID($UserID) !== true)
            {
            //echo 'Delete Logins'.PHP_EOL;

            //Enable the Foreign Key Checks
            mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");

            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -11;
            }

        //Try to Delete this User
        if ($this->Users->_DeleteUser($UserID) !== true)
            {
            //echo 'Delete this User'.PHP_EOL;

            //Enable the Foreign Key Checks
            mysqli_query($this->DBLink, "SET foreign_key_checks = 1;");

            //Revert the DataBase Queries
            mysqli_rollback($this->DBLink);

            //Start the DataBase Auto-Commit
            mysqli_autocommit($this->DBLink, true);

            return -13;
            }

        //Enable the Foreign Key Checks
        if (!mysqli_query($this->DBLink, "SET foreign_key_checks = 1;"))
            {
            return -1;
            }

        //Start the DataBase Auto-Commit
        mysqli_autocommit($this->DBLink, true);

        return true;
        }

    }