<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_venta'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM ventas where id_venta=:id_venta");

        $sql->bindValue(':id_venta', $_GET['id_venta']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    }

    if (isset($_GET['vendidos'])) {

        $vendidos = $_GET['vendidos'];



        $sql = $dbConn->prepare("SELECT

        e.*,

        v.fecha,

        COALESCE(c.nombre, 'Ninguno') AS nombre_modelo,

        COALESCE(b.nombre, 'Ninguna') AS nombre_marca,

        COALESCE(a.nombre, 'Ninguno') AS nombre_combustible,

        COALESCE(cl.nombre, 'Ninguno') AS nombre_cliente,

        cl.telefono,

        cl.email

    FROM

        vehiculos e

    JOIN(

        SELECT DISTINCT

            id_vehiculo,

            client_id,

            fecha

        FROM

            ventas

    ) v

    ON

        e.id_vehiculo = v.id_vehiculo

    JOIN clientes cl ON

        v.client_id = cl.client_id

    LEFT JOIN modelos c ON

        e.id_modelo = c.id_modelo

    LEFT JOIN marcas b ON

        e.id_marca = b.id_marca

    LEFT JOIN combustibles a ON

        e.id_combustible = a.id_combustible;");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }if (isset($_GET['client_id'])) {

        $client_id = $_GET['client_id'];



        $sql = $dbConn->prepare("SELECT e.*, 

        COALESCE(m.nombre, 'Ninguno') AS nombre_modelo, 

        COALESCE(ma.nombre, 'Ninguna') AS nombre_marca, 

        COALESCE(f.nombre, 'Ninguna') AS nombre_financiera, 

        COALESCE(r.nombre, 'Ninguna') AS nombre_metodo, 

        COALESCE(a.nombre, 'Ninguno') AS nombre_cliente,

        COALESCE(v.matricula, 'No matriculado') AS numero_matricula,

        v.proxima_itv,

        COALESCE(v.fecha_matriculacion, 'No matriculado') AS fecha_matriculacion,

        CASE 

            WHEN e.id_financiera IS NULL THEN NULL

            WHEN DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) < NOW() THEN TRUE

            ELSE FALSE

        END AS financiacion_vencida,

        DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) AS fecha_vencimiento

 FROM ventas e

 LEFT JOIN vehiculos v ON e.id_vehiculo = v.id_vehiculo

 LEFT JOIN modelos m ON v.id_modelo = m.id_modelo

 LEFT JOIN marcas ma ON v.id_marca = ma.id_marca

 LEFT JOIN clientes a ON e.client_id = a.client_id

 LEFT JOIN metodos_pago r ON e.id_metodo = r.id_metodo

 LEFT JOIN financieras f ON e.id_financiera = f.id_financiera

             WHERE e.client_id = :client_id;");

             $sql->bindParam(':client_id', $client_id);

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    } else {



        if (isset($_GET['fecha_i']) && isset($_GET['fecha_i'])) {

            $fecha_i = $_GET['fecha_i'];

            $fecha_f = $_GET['fecha_f'];



            $sql = $dbConn->prepare("SELECT e.*, 

       COALESCE(m.nombre, 'Ninguno') AS nombre_modelo, 

       COALESCE(ma.nombre, 'Ninguna') AS nombre_marca, 

       COALESCE(f.nombre, 'Ninguna') AS nombre_financiera, 

       COALESCE(r.nombre, 'Ninguna') AS nombre_metodo, 

       COALESCE(a.nombre, 'Ninguno') AS nombre_cliente,

       COALESCE(v.fecha_matriculacion, 'Ninguna') AS fecha_matriculacion,

       v.envio_vencimiento,

       CASE 

           WHEN e.id_financiera IS NULL THEN NULL

           WHEN DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) < NOW() THEN TRUE

           ELSE FALSE

       END AS financiacion_vencida,

       DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) AS fecha_vencimiento

FROM ventas e

LEFT JOIN vehiculos v ON e.id_vehiculo = v.id_vehiculo

LEFT JOIN modelos m ON v.id_modelo = m.id_modelo

LEFT JOIN marcas ma ON v.id_marca = ma.id_marca

LEFT JOIN clientes a ON e.client_id = a.client_id

LEFT JOIN metodos_pago r ON e.id_metodo = r.id_metodo

LEFT JOIN financieras f ON e.id_financiera = f.id_financiera

            WHERE DATE_FORMAT(e.fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f;");





            $sql->bindParam(':fecha_i', $fecha_i);

            $sql->bindParam(':fecha_f', $fecha_f);

        } else {

            $sql = $dbConn->prepare("SELECT e.*, 

       COALESCE(m.nombre, 'Ninguno') AS nombre_modelo, 

       COALESCE(ma.nombre, 'Ninguna') AS nombre_marca, 

       COALESCE(f.nombre, 'Ninguna') AS nombre_financiera, 

       COALESCE(r.nombre, 'Ninguna') AS nombre_metodo, 

       COALESCE(a.nombre, 'Ninguno') AS nombre_cliente,

       COALESCE(v.fecha_matriculacion, 'Ninguna') AS fecha_matriculacion,

       v.envio_vencimiento,

       CASE 

           WHEN e.id_financiera IS NULL THEN NULL

           WHEN DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) < NOW() THEN TRUE

           ELSE FALSE

       END AS financiacion_vencida,

       DATE_ADD(e.fecha, INTERVAL e.plazo MONTH) AS fecha_vencimiento

FROM ventas e

LEFT JOIN vehiculos v ON e.id_vehiculo = v.id_vehiculo

LEFT JOIN modelos m ON v.id_modelo = m.id_modelo

LEFT JOIN marcas ma ON v.id_marca = ma.id_marca

LEFT JOIN clientes a ON e.client_id = a.client_id

LEFT JOIN metodos_pago r ON e.id_metodo = r.id_metodo

LEFT JOIN financieras f ON e.id_financiera = f.id_financiera;

");

        }

        //Mostrar lista de post





        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }

}















// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["envio_vencimiento"]) && isset($_POST["id_vehiculo"])) {



        $envio_vencimiento = $_POST["envio_vencimiento"];

        $id_vehiculo = $_POST["id_vehiculo"];



        $sql = "UPDATE vehiculos SET envio_vencimiento = :envio_vencimiento WHERE id_vehiculo = :id_vehiculo";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_vehiculo', $id_vehiculo);

        $statement->bindValue(':envio_vencimiento', $envio_vencimiento);



        $statement->execute();

        $object = [

            'id' => $id_vehiculo,

            'envio_vencimiento' => $envio_vencimiento,



        ];

        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();

    }

    if (

        isset($_POST["fecha"])

        && isset($_POST["id_metodo"])

        && isset($_POST["client_id"])

        && isset($_POST["id_vehiculo"])

        && isset($_POST["id_financiera"])

        && isset($_POST["plazo"])



    ) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;

            $value = ($value == "No") ? null : $value;



            $$key = $value;

        }

        try {

            if (isset($_POST["id_venta"])) {



                $id_venta = $_POST["id_venta"];

                $sql = "UPDATE ventas SET 

                fecha = :fecha,

                id_metodo = :id_metodo,

                client_id = :client_id,

                id_vehiculo = :id_vehiculo,

                id_financiera = :id_financiera,

                plazo = :plazo

               

                WHERE id_venta = :id_venta";

                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':id_venta', $id_venta);

            } else {

                $sql = "INSERT INTO ventas

            (fecha,

            id_metodo,

            client_id,

            id_vehiculo,

            id_financiera,

            plazo)

            VALUES

            (:fecha,

            :id_metodo,

            :client_id,

            :id_vehiculo,

            :id_financiera,

            :plazo)";

                $statement = $dbConn->prepare($sql);

            }







            $statement->bindValue(':fecha', $fecha);

            $statement->bindValue(':id_metodo', $id_metodo);

            $statement->bindValue(':client_id', $client_id);

            $statement->bindValue(':id_vehiculo', $id_vehiculo);

            $statement->bindValue(':id_financiera', $id_financiera);

            $statement->bindValue(':plazo', $plazo);



            $statement->execute();



            $postId = $dbConn->lastInsertId();



            $input['id'] = $postId;



            $response = array('success' => true, 'title' => "Venta agregada.", 'message' => "Se ha agregado la venta correctamente.");

            header("HTTP/1.1 200 OK");

            echo json_encode($response);

            exit();

        } catch (PDOException $e) {







            $response = array('success' => false, 'title' => "Venta vendido.", 'message' => "El vehículo ya fue vendido a un cliente.");





            header("HTTP/1.1 200 OK");

            echo json_encode($response);

            exit();

        }

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM ventas where id_venta =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//Actualizar





//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");